/*
 * Decompiled with CFR 0.152.
 */
package org.noear.nami.channel.http.okhttp;

import okhttp3.MediaType;
import okhttp3.Response;
import org.noear.nami.Channel;
import org.noear.nami.Context;
import org.noear.nami.Encoder;
import org.noear.nami.NamiManager;
import org.noear.nami.Result;
import org.noear.nami.channel.http.okhttp.HttpUtils;

public class HttpChannel
implements Channel {
    public static final HttpChannel instance = new HttpChannel();

    public Result call(Context ctx) throws Throwable {
        byte[] bytes;
        this.pretreatment(ctx);
        boolean is_get = "GET".equals(ctx.action);
        String url = ctx.url;
        if (is_get && ctx.args.size() > 0) {
            StringBuilder sb = new StringBuilder(ctx.url);
            sb.append(ctx.url.contains("?") ? "&" : "?");
            ctx.args.forEach((k, v) -> {
                if (v != null) {
                    sb.append((String)k).append("=").append(HttpUtils.urlEncode(v.toString())).append("&");
                }
            });
            url = sb.substring(0, sb.length() - 1);
        }
        if (ctx.config.getDecoder() == null) {
            throw new IllegalArgumentException("There is no suitable decoder");
        }
        ctx.config.getDecoder().pretreatment(ctx);
        HttpUtils http = HttpUtils.http(url).headers(ctx.headers).timeout(ctx.config.getTimeout());
        Response response = null;
        Encoder encoder = ctx.config.getEncoder();
        if (is_get || ctx.args.size() == 0) {
            response = http.exec("GET");
        } else if (encoder == null) {
            String ct0 = ctx.headers.getOrDefault("Content-Type", "");
            if (ct0.length() == 0) {
                response = http.data(ctx.args).exec(ctx.action);
            } else {
                encoder = NamiManager.getEncoder((String)ct0);
            }
        } else {
            encoder = ctx.config.getEncoder();
        }
        if (response == null && encoder != null && (bytes = encoder.encode(ctx.body)) != null) {
            response = http.bodyRaw(bytes, encoder.enctype()).exec(ctx.action);
        }
        if (response == null) {
            return null;
        }
        Result result = new Result(response.code(), response.body().bytes());
        int len = response.headers().size();
        for (int i = 0; i < len; ++i) {
            result.headerAdd(response.headers().name(i), response.headers().value(i));
        }
        MediaType contentType = response.body().contentType();
        if (contentType != null) {
            result.charsetSet(contentType.charset());
        }
        return result;
    }

    private void pretreatment(Context ctx) {
        String ct;
        if (ctx.config.getDecoder() == null) {
            String at = ctx.config.getHeader("Accept");
            if (at == null) {
                at = "application/json";
            }
            ctx.config.setDecoder(NamiManager.getDecoder((String)at));
        }
        if (ctx.config.getEncoder() == null && (ct = ctx.config.getHeader("Content-Type")) != null) {
            ctx.config.setEncoder(NamiManager.getEncoder((String)ct));
        }
    }
}

