/*
 * Decompiled with CFR 0.152.
 */
package org.noear.nami.channel.http.hutool;

import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import cn.hutool.http.Method;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;
import org.noear.nami.NamiException;

class HttpUtils {
    private HttpRequest _builder;

    public static HttpUtils http(String url) {
        return new HttpUtils(url);
    }

    public static String urlEncode(String str) {
        try {
            return URLEncoder.encode(str, "utf-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new NamiException((Throwable)ex);
        }
    }

    public HttpUtils(String url) {
        this._builder = new HttpRequest(url);
    }

    public HttpUtils charset(String charset) {
        this._builder.charset(charset);
        return this;
    }

    public HttpUtils headers(Map<String, String> headers) {
        if (headers != null) {
            headers.forEach((k, v) -> this._builder.header(k, v));
        }
        return this;
    }

    public HttpUtils data(Map<String, Object> data) {
        if (data != null) {
            this._builder.form(data);
        }
        return this;
    }

    public HttpUtils bodyRaw(byte[] bytes, String contentType) {
        this._builder.body(bytes).contentType(contentType);
        return this;
    }

    public HttpResponse exec(String mothod) throws Exception {
        switch (mothod.toUpperCase()) {
            case "GET": {
                this._builder.method(Method.GET);
                break;
            }
            case "POST": {
                this._builder.method(Method.POST);
                break;
            }
            case "PUT": {
                this._builder.method(Method.PUT);
                break;
            }
            case "DELETE": {
                this._builder.method(Method.DELETE);
                break;
            }
            case "PATCH": {
                this._builder.method(Method.PATCH);
                break;
            }
            case "OPTIONS": {
                this._builder.method(Method.OPTIONS);
                break;
            }
            default: {
                throw new RuntimeException("This method is not supported");
            }
        }
        return this._builder.execute();
    }
}

