/*
 * Decompiled with CFR 0.152.
 */
package org.noear.nami.coder.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import org.noear.nami.Context;
import org.noear.nami.Encoder;

public class JacksonEncoder
implements Encoder {
    public static final JacksonEncoder instance = new JacksonEncoder();
    ObjectMapper mapper = new ObjectMapper();

    public JacksonEncoder() {
        this.mapper.enable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        this.mapper.registerModule((Module)new JavaTimeModule());
        this.mapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
        this.mapper.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
    }

    public String enctype() {
        return "application/json";
    }

    public byte[] encode(Object obj) throws JsonProcessingException {
        return this.mapper.writeValueAsBytes(obj);
    }

    public void pretreatment(Context ctx) {
    }
}

