/*
 * Decompiled with CFR 0.152.
 */
package org.noear.nami.coder.fastjson;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.parser.ParserConfig;
import java.lang.reflect.Type;
import org.noear.nami.Context;
import org.noear.nami.Decoder;
import org.noear.nami.EncoderTyped;
import org.noear.nami.Result;
import org.noear.nami.exception.NamiDecodeException;
import org.noear.solon.Utils;

public class FastjsonDecoder
implements Decoder {
    public static final FastjsonDecoder instance;

    public String enctype() {
        return "application/json";
    }

    public <T> T decode(Result rst, Type type) {
        if (rst.body().length == 0) {
            return null;
        }
        String str = rst.bodyAsString();
        if ("null".equals(str)) {
            return null;
        }
        try {
            if (str.contains("\"stackTrace\":[{")) {
                return (T)JSON.parseObject((String)str, Throwable.class);
            }
            if (String.class == type && Utils.isNotEmpty((String)str) && str.charAt(0) != '\'' && str.charAt(0) != '\"') {
                return (T)str;
            }
            return (T)JSON.parseObject((String)str, (Type)type, (Feature[])new Feature[0]);
        }
        catch (Throwable ex) {
            throw new NamiDecodeException("Decoding failure, type: " + type.getTypeName() + ", data: " + str, ex);
        }
    }

    public void pretreatment(Context ctx) {
        if (ctx.config.getEncoder() instanceof EncoderTyped) {
            ctx.headers.put("X-Serialization", "@type_json");
        }
        ctx.headers.put("Accept", "application/json");
    }

    static {
        ParserConfig.getGlobalInstance().setAutoTypeSupport(true);
        instance = new FastjsonDecoder();
    }
}

