/*
 * Decompiled with CFR 0.152.
 */
package org.nlpcn.es4sql.query.maker;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.expr.SQLBooleanExpr;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLMethodInvokeExpr;
import com.alibaba.druid.sql.ast.expr.SQLNumericLiteralExpr;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.search.join.ScoreMode;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.common.geo.builders.ShapeBuilder;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.json.JsonXContent;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.GeoPolygonQueryBuilder;
import org.elasticsearch.index.query.MatchPhraseQueryBuilder;
import org.elasticsearch.index.query.MatchQueryBuilder;
import org.elasticsearch.index.query.MultiMatchQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.QueryStringQueryBuilder;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.elasticsearch.index.query.RegexpFlag;
import org.elasticsearch.index.query.RegexpQueryBuilder;
import org.elasticsearch.index.query.WildcardQueryBuilder;
import org.elasticsearch.join.query.JoinQueryBuilders;
import org.elasticsearch.script.Script;
import org.nlpcn.es4sql.domain.Condition;
import org.nlpcn.es4sql.domain.Paramer;
import org.nlpcn.es4sql.domain.Where;
import org.nlpcn.es4sql.exception.SqlParseException;
import org.nlpcn.es4sql.parse.ScriptFilter;
import org.nlpcn.es4sql.parse.SubQueryExpression;
import org.nlpcn.es4sql.query.maker.QueryMaker;
import org.nlpcn.es4sql.spatial.BoundingBoxFilterParams;
import org.nlpcn.es4sql.spatial.DistanceFilterParams;
import org.nlpcn.es4sql.spatial.Point;
import org.nlpcn.es4sql.spatial.PolygonFilterParams;
import org.nlpcn.es4sql.spatial.WktToGeoJsonConverter;

public abstract class Maker {
    private static final Set<Condition.OPEAR> NOT_OPEAR_SET = ImmutableSet.of((Object)((Object)Condition.OPEAR.N), (Object)((Object)Condition.OPEAR.NIN), (Object)((Object)Condition.OPEAR.ISN), (Object)((Object)Condition.OPEAR.NBETWEEN), (Object)((Object)Condition.OPEAR.NLIKE), (Object)((Object)Condition.OPEAR.NIN_TERMS), (Object[])new Condition.OPEAR[]{Condition.OPEAR.NTERM});

    protected Maker(Boolean isQuery) {
    }

    protected ToXContent make(Condition cond) throws SqlParseException {
        String name = cond.getName();
        Object value = cond.getValue();
        ToXContent x = null;
        x = value instanceof SQLMethodInvokeExpr ? this.make(cond, name, (SQLMethodInvokeExpr)value) : (value instanceof SubQueryExpression ? this.make(cond, name, ((SubQueryExpression)value).getValues()) : this.make(cond, name, value));
        return x;
    }

    private ToXContent make(Condition cond, String name, SQLMethodInvokeExpr value) throws SqlParseException {
        ToXContent bqb = null;
        Paramer paramer = null;
        switch (value.getMethodName().toLowerCase()) {
            case "query": {
                paramer = Paramer.parseParamer(value);
                QueryStringQueryBuilder queryString = QueryBuilders.queryStringQuery((String)paramer.value);
                bqb = Paramer.fullParamer(queryString, paramer);
                bqb = this.fixNot(cond, bqb);
                break;
            }
            case "matchquery": 
            case "match_query": {
                paramer = Paramer.parseParamer(value);
                MatchQueryBuilder matchQuery = QueryBuilders.matchQuery((String)name, (Object)paramer.value);
                bqb = Paramer.fullParamer(matchQuery, paramer);
                bqb = this.fixNot(cond, bqb);
                break;
            }
            case "score": 
            case "scorequery": 
            case "score_query": {
                Float boost = Float.valueOf(Float.parseFloat(((SQLExpr)value.getParameters().get(1)).toString()));
                Condition subCond = new Condition(cond.getConn(), cond.getName(), null, cond.getOpear(), value.getParameters().get(0), null);
                bqb = QueryBuilders.constantScoreQuery((QueryBuilder)((QueryBuilder)this.make(subCond))).boost(boost.floatValue());
                break;
            }
            case "wildcardquery": 
            case "wildcard_query": {
                paramer = Paramer.parseParamer(value);
                WildcardQueryBuilder wildcardQuery = QueryBuilders.wildcardQuery((String)name, (String)paramer.value);
                bqb = Paramer.fullParamer(wildcardQuery, paramer);
                break;
            }
            case "matchphrasequery": 
            case "match_phrase": 
            case "matchphrase": {
                paramer = Paramer.parseParamer(value);
                MatchPhraseQueryBuilder matchPhraseQuery = QueryBuilders.matchPhraseQuery((String)name, (Object)paramer.value);
                bqb = Paramer.fullParamer(matchPhraseQuery, paramer);
                break;
            }
            case "multimatchquery": 
            case "multi_match": 
            case "multimatch": {
                paramer = Paramer.parseParamer(value);
                MultiMatchQueryBuilder multiMatchQuery = QueryBuilders.multiMatchQuery((Object)paramer.value, (String[])new String[0]).fields(paramer.fieldsBoosts);
                bqb = Paramer.fullParamer(multiMatchQuery, paramer);
                break;
            }
            default: {
                throw new SqlParseException("it did not support this query method " + value.getMethodName());
            }
        }
        return bqb;
    }

    private ToXContent make(Condition cond, String name, Object value) throws SqlParseException {
        RangeQueryBuilder x = null;
        switch (cond.getOpear()) {
            case ISN: 
            case IS: 
            case N: 
            case EQ: {
                if (value == null || value instanceof SQLIdentifierExpr) {
                    if (value == null || ((SQLIdentifierExpr)value).getName().equalsIgnoreCase("missing")) {
                        x = QueryBuilders.boolQuery().mustNot((QueryBuilder)QueryBuilders.existsQuery((String)name));
                        break;
                    }
                    throw new SqlParseException(String.format("Cannot recoginze Sql identifer %s", ((SQLIdentifierExpr)value).getName()));
                }
                x = QueryBuilders.matchPhraseQuery((String)name, (Object)value);
                break;
            }
            case LIKE: 
            case NLIKE: {
                String queryStr = (String)value;
                queryStr = queryStr.replace('%', '*').replace('_', '?');
                queryStr = queryStr.replace("&PERCENT", "%").replace("&UNDERSCORE", "_");
                x = QueryBuilders.wildcardQuery((String)name, (String)queryStr);
                break;
            }
            case REGEXP: {
                Object[] values = (Object[])value;
                RegexpQueryBuilder regexpQuery = QueryBuilders.regexpQuery((String)name, (String)values[0].toString());
                if (1 < values.length) {
                    String[] flags = values[1].toString().split("\\|");
                    RegexpFlag[] regexpFlags = new RegexpFlag[flags.length];
                    for (int i = 0; i < flags.length; ++i) {
                        regexpFlags[i] = RegexpFlag.valueOf((String)flags[i]);
                    }
                    regexpQuery.flags(regexpFlags);
                }
                if (2 < values.length) {
                    regexpQuery.maxDeterminizedStates(Integer.parseInt(values[2].toString()));
                }
                x = regexpQuery;
                break;
            }
            case GT: {
                x = QueryBuilders.rangeQuery((String)name).gt(value);
                break;
            }
            case GTE: {
                x = QueryBuilders.rangeQuery((String)name).gte(value);
                break;
            }
            case LT: {
                x = QueryBuilders.rangeQuery((String)name).lt(value);
                break;
            }
            case LTE: {
                x = QueryBuilders.rangeQuery((String)name).lte(value);
                break;
            }
            case NIN: 
            case IN: {
                Object[] values = (Object[])value;
                MatchPhraseQueryBuilder[] matchQueries = new MatchPhraseQueryBuilder[values.length];
                for (int i = 0; i < values.length; ++i) {
                    matchQueries[i] = QueryBuilders.matchPhraseQuery((String)name, (Object)values[i]);
                }
                BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();
                for (MatchPhraseQueryBuilder matchQuery : matchQueries) {
                    boolQuery.should((QueryBuilder)matchQuery);
                }
                x = boolQuery;
                break;
            }
            case BETWEEN: 
            case NBETWEEN: {
                x = QueryBuilders.rangeQuery((String)name).gte(((Object[])value)[0]).lte(((Object[])value)[1]);
                break;
            }
            case GEO_INTERSECTS: {
                String wkt = cond.getValue().toString();
                try {
                    ShapeBuilder shapeBuilder = this.getShapeBuilderFromString(wkt);
                    x = QueryBuilders.geoShapeQuery((String)cond.getName(), (ShapeBuilder)shapeBuilder);
                    break;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    throw new SqlParseException("couldn't create shapeBuilder from wkt: " + wkt);
                }
            }
            case GEO_BOUNDING_BOX: {
                BoundingBoxFilterParams boxFilterParams = (BoundingBoxFilterParams)cond.getValue();
                Point topLeft = boxFilterParams.getTopLeft();
                Point bottomRight = boxFilterParams.getBottomRight();
                x = QueryBuilders.geoBoundingBoxQuery((String)cond.getName()).setCorners(topLeft.getLat(), topLeft.getLon(), bottomRight.getLat(), bottomRight.getLon());
                break;
            }
            case GEO_DISTANCE: {
                DistanceFilterParams distanceFilterParams = (DistanceFilterParams)cond.getValue();
                Point fromPoint = distanceFilterParams.getFrom();
                String distance = this.trimApostrophes(distanceFilterParams.getDistance());
                x = QueryBuilders.geoDistanceQuery((String)cond.getName()).distance(distance).point(fromPoint.getLat(), fromPoint.getLon());
                break;
            }
            case GEO_POLYGON: {
                PolygonFilterParams polygonFilterParams = (PolygonFilterParams)cond.getValue();
                ArrayList<GeoPoint> geoPoints = new ArrayList<GeoPoint>();
                for (Point p : polygonFilterParams.getPolygon()) {
                    geoPoints.add(new GeoPoint(p.getLat(), p.getLon()));
                }
                GeoPolygonQueryBuilder polygonFilterBuilder = QueryBuilders.geoPolygonQuery((String)cond.getName(), geoPoints);
                x = polygonFilterBuilder;
                break;
            }
            case NIN_TERMS: 
            case IN_TERMS: {
                Object[] termValues = (Object[])value;
                if (termValues.length == 1 && termValues[0] instanceof SubQueryExpression) {
                    termValues = ((SubQueryExpression)termValues[0]).getValues();
                }
                Object[] termValuesObjects = new Object[termValues.length];
                for (int i = 0; i < termValues.length; ++i) {
                    termValuesObjects[i] = this.parseTermValue(termValues[i]);
                }
                x = QueryBuilders.termsQuery((String)name, (Object[])termValuesObjects);
                break;
            }
            case NTERM: 
            case TERM: {
                Object term = ((Object[])value)[0];
                x = QueryBuilders.termQuery((String)name, (Object)this.parseTermValue(term));
                break;
            }
            case IDS_QUERY: {
                String[] ids;
                Object[] idsParameters = (Object[])value;
                String type = idsParameters[0].toString();
                if (idsParameters.length == 2 && idsParameters[1] instanceof SubQueryExpression) {
                    Object[] idsFromSubQuery = ((SubQueryExpression)idsParameters[1]).getValues();
                    ids = this.arrayOfObjectsToStringArray(idsFromSubQuery, 0, idsFromSubQuery.length - 1);
                } else {
                    ids = this.arrayOfObjectsToStringArray(idsParameters, 1, idsParameters.length - 1);
                }
                x = QueryBuilders.idsQuery((String[])new String[]{type}).addIds(ids);
                break;
            }
            case NESTED_COMPLEX: {
                if (value == null || !(value instanceof Where)) {
                    throw new SqlParseException("unsupported nested condition");
                }
                Where whereNested = (Where)value;
                BoolQueryBuilder nestedFilter = QueryMaker.explan(whereNested);
                x = QueryBuilders.nestedQuery((String)name, (QueryBuilder)nestedFilter, (ScoreMode)ScoreMode.None);
                break;
            }
            case CHILDREN_COMPLEX: {
                if (value == null || !(value instanceof Where)) {
                    throw new SqlParseException("unsupported nested condition");
                }
                Where whereChildren = (Where)value;
                BoolQueryBuilder childrenFilter = QueryMaker.explan(whereChildren);
                x = JoinQueryBuilders.hasChildQuery((String)name, (QueryBuilder)childrenFilter, (ScoreMode)ScoreMode.None);
                break;
            }
            case SCRIPT: {
                ScriptFilter scriptFilter = (ScriptFilter)value;
                Map<Object, Object> params = new HashMap();
                if (scriptFilter.containsParameters()) {
                    params = scriptFilter.getArgs();
                }
                x = QueryBuilders.scriptQuery((Script)new Script(scriptFilter.getScriptType(), "painless", scriptFilter.getScript(), params));
                break;
            }
            default: {
                throw new SqlParseException("not define type " + cond.getName());
            }
        }
        x = this.fixNot(cond, (ToXContent)x);
        return x;
    }

    private String[] arrayOfObjectsToStringArray(Object[] values, int from, int to) {
        String[] strings = new String[to - from + 1];
        int counter = 0;
        for (int i = from; i <= to; ++i) {
            strings[counter] = values[i].toString();
            ++counter;
        }
        return strings;
    }

    private ShapeBuilder getShapeBuilderFromString(String str) throws IOException {
        String json = str.contains("{") ? this.fixJsonFromElastic(str) : WktToGeoJsonConverter.toGeoJson(this.trimApostrophes(str));
        return this.getShapeBuilderFromJson(json);
    }

    private String fixJsonFromElastic(String elasticJson) {
        String properJson = elasticJson.replaceAll("=", ":");
        properJson = properJson.replaceAll("(type)(:)([a-zA-Z]+)", "\"type\":\"$3\"");
        properJson = properJson.replaceAll("coordinates", "\"coordinates\"");
        return properJson;
    }

    private ShapeBuilder getShapeBuilderFromJson(String json) throws IOException {
        XContentParser parser = null;
        parser = JsonXContent.jsonXContent.createParser(NamedXContentRegistry.EMPTY, json);
        parser.nextToken();
        return ShapeBuilder.parse((XContentParser)parser);
    }

    private String trimApostrophes(String str) {
        return str.substring(1, str.length() - 1);
    }

    private ToXContent fixNot(Condition cond, ToXContent bqb) {
        if (NOT_OPEAR_SET.contains((Object)cond.getOpear())) {
            bqb = QueryBuilders.boolQuery().mustNot((QueryBuilder)bqb);
        }
        return bqb;
    }

    private Object parseTermValue(Object termValue) {
        if (termValue instanceof SQLNumericLiteralExpr) {
            if ((termValue = ((SQLNumericLiteralExpr)termValue).getNumber()) instanceof BigDecimal || termValue instanceof Double) {
                termValue = ((Number)termValue).doubleValue();
            } else if (termValue instanceof Float) {
                termValue = Float.valueOf(((Number)termValue).floatValue());
            } else if (termValue instanceof BigInteger || termValue instanceof Long) {
                termValue = ((Number)termValue).longValue();
            } else if (termValue instanceof Integer) {
                termValue = ((Number)termValue).intValue();
            } else if (termValue instanceof Short) {
                termValue = ((Number)termValue).shortValue();
            } else if (termValue instanceof Byte) {
                termValue = ((Number)termValue).byteValue();
            }
        } else {
            termValue = termValue instanceof SQLBooleanExpr ? Boolean.valueOf(((SQLBooleanExpr)termValue).getValue()) : termValue.toString();
        }
        return termValue;
    }
}

