/*
 * Decompiled with CFR 0.152.
 */
package org.nlpcn.es4sql.query.join;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.elasticsearch.client.Client;
import org.nlpcn.es4sql.domain.Condition;
import org.nlpcn.es4sql.domain.Field;
import org.nlpcn.es4sql.domain.JoinSelect;
import org.nlpcn.es4sql.domain.Where;
import org.nlpcn.es4sql.domain.hints.Hint;
import org.nlpcn.es4sql.domain.hints.HintType;
import org.nlpcn.es4sql.exception.SqlParseException;
import org.nlpcn.es4sql.query.join.ESJoinQueryAction;
import org.nlpcn.es4sql.query.join.HashJoinElasticRequestBuilder;
import org.nlpcn.es4sql.query.join.JoinRequestBuilder;

public class ESHashJoinQueryAction
extends ESJoinQueryAction {
    public ESHashJoinQueryAction(Client client, JoinSelect joinSelect) {
        super(client, joinSelect);
    }

    @Override
    protected void fillSpecificRequestBuilder(JoinRequestBuilder requestBuilder) throws SqlParseException {
        String t1Alias = this.joinSelect.getFirstTable().getAlias();
        String t2Alias = this.joinSelect.getSecondTable().getAlias();
        List<List<Map.Entry<Field, Field>>> comparisonFields = this.getComparisonFields(t1Alias, t2Alias, this.joinSelect.getConnectedWhere());
        ((HashJoinElasticRequestBuilder)requestBuilder).setT1ToT2FieldsComparison(comparisonFields);
    }

    @Override
    protected JoinRequestBuilder createSpecificBuilder() {
        return new HashJoinElasticRequestBuilder();
    }

    @Override
    protected void updateRequestWithHints(JoinRequestBuilder requestBuilder) {
        super.updateRequestWithHints(requestBuilder);
        for (Hint hint : this.joinSelect.getHints()) {
            if (hint.getType() != HintType.HASH_WITH_TERMS_FILTER) continue;
            ((HashJoinElasticRequestBuilder)requestBuilder).setUseTermFiltersOptimization(true);
        }
    }

    private List<Map.Entry<Field, Field>> getComparisonFields(String t1Alias, String t2Alias, List<Condition> connectedConditions) throws SqlParseException {
        ArrayList<Map.Entry<Field, Field>> comparisonFields = new ArrayList<Map.Entry<Field, Field>>();
        for (Condition condition : connectedConditions) {
            Field t2Field;
            Field t1Field;
            if (condition.getOpear() != Condition.OPEAR.EQ) {
                throw new SqlParseException(String.format("HashJoin should only be with EQ conditions, got:%s on condition:%s", condition.getOpear().name(), condition.toString()));
            }
            String firstField = condition.getName();
            String secondField = condition.getValue().toString();
            if (firstField.startsWith(t1Alias)) {
                t1Field = new Field(this.removeAlias(firstField, t1Alias), null);
                t2Field = new Field(this.removeAlias(secondField, t2Alias), null);
            } else {
                t1Field = new Field(this.removeAlias(secondField, t1Alias), null);
                t2Field = new Field(this.removeAlias(firstField, t2Alias), null);
            }
            comparisonFields.add(new AbstractMap.SimpleEntry<Field, Field>(t1Field, t2Field));
        }
        return comparisonFields;
    }

    private List<List<Map.Entry<Field, Field>>> getComparisonFields(String t1Alias, String t2Alias, Where connectedWhere) throws SqlParseException {
        ArrayList<List<Map.Entry<Field, Field>>> comparisonFields = new ArrayList<List<Map.Entry<Field, Field>>>();
        if (connectedWhere == null) {
            return comparisonFields;
        }
        boolean allAnds = true;
        for (Where innerWhere : connectedWhere.getWheres()) {
            if (innerWhere.getConn() != Where.CONN.OR) continue;
            allAnds = false;
            break;
        }
        if (allAnds) {
            List<Map.Entry<Field, Field>> innerComparisonFields = this.getComparisonFieldsFromWhere(t1Alias, t2Alias, connectedWhere);
            comparisonFields.add(innerComparisonFields);
        } else {
            for (Where innerWhere : connectedWhere.getWheres()) {
                comparisonFields.add(this.getComparisonFieldsFromWhere(t1Alias, t2Alias, innerWhere));
            }
        }
        return comparisonFields;
    }

    private List<Map.Entry<Field, Field>> getComparisonFieldsFromWhere(String t1Alias, String t2Alias, Where where) throws SqlParseException {
        ArrayList<Condition> conditions = new ArrayList<Condition>();
        if (where instanceof Condition) {
            conditions.add((Condition)where);
        } else {
            for (Where innerWhere : where.getWheres()) {
                if (!(innerWhere instanceof Condition)) {
                    throw new SqlParseException("if connectedCondition is AND than all inner wheres should be Conditions ");
                }
                conditions.add((Condition)innerWhere);
            }
        }
        return this.getComparisonFields(t1Alias, t2Alias, conditions);
    }

    private String removeAlias(String field, String alias) {
        return field.replace(alias + ".", "");
    }
}

