/*
 * Decompiled with CFR 0.152.
 */
package org.nlpcn.es4sql.parse;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.expr.SQLCaseExpr;
import com.alibaba.druid.sql.ast.expr.SQLNullExpr;
import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.List;
import org.nlpcn.es4sql.Util;
import org.nlpcn.es4sql.domain.Condition;
import org.nlpcn.es4sql.domain.Where;
import org.nlpcn.es4sql.exception.SqlParseException;
import org.nlpcn.es4sql.parse.ScriptFilter;
import org.nlpcn.es4sql.parse.SqlParser;
import org.nlpcn.es4sql.parse.WhereParser;

public class CaseWhenParser {
    private SQLCaseExpr caseExpr;
    private String alias;
    private String tableAlias;

    public CaseWhenParser(SQLCaseExpr caseExpr, String alias, String tableAlias) {
        this.alias = alias;
        this.tableAlias = tableAlias;
        this.caseExpr = caseExpr;
    }

    public String parse() throws SqlParseException {
        ArrayList<String> result = new ArrayList<String>();
        for (SQLCaseExpr.Item item : this.caseExpr.getItems()) {
            SQLExpr conditionExpr = item.getConditionExpr();
            WhereParser parser = new WhereParser(new SqlParser(), conditionExpr);
            String scriptCode = this.explain(parser.findWhere());
            if (scriptCode.startsWith(" &&")) {
                scriptCode = scriptCode.substring(3);
            }
            if (result.size() == 0) {
                result.add("if(" + scriptCode + "){" + Util.getScriptValueWithQuote(item.getValueExpr(), "'") + "}");
                continue;
            }
            result.add("else if(" + scriptCode + "){" + Util.getScriptValueWithQuote(item.getValueExpr(), "'") + "}");
        }
        SQLExpr elseExpr = this.caseExpr.getElseExpr();
        if (elseExpr == null) {
            result.add("else { null }");
        } else {
            result.add("else {" + Util.getScriptValueWithQuote(elseExpr, "'") + "}");
        }
        return Joiner.on((String)" ").join(result);
    }

    public String explain(Where where) throws SqlParseException {
        ArrayList<String> codes = new ArrayList<String>();
        while (where.getWheres().size() == 1) {
            where = where.getWheres().getFirst();
        }
        this.explainWhere(codes, where);
        String relation = where.getConn().name().equals("AND") ? " && " : " || ";
        return Joiner.on((String)relation).join(codes);
    }

    private void explainWhere(List<String> codes, Where where) throws SqlParseException {
        if (where instanceof Condition) {
            Condition condition = (Condition)where;
            if (condition.getValue() instanceof ScriptFilter) {
                codes.add("(" + ((ScriptFilter)condition.getValue()).getScript() + ")");
            } else if (condition.getOpear() == Condition.OPEAR.BETWEEN) {
                Object[] objs = (Object[])condition.getValue();
                codes.add("(doc['" + condition.getName() + "'].value >= " + objs[0] + " && doc['" + condition.getName() + "'].value <=" + objs[1] + ")");
            } else {
                SQLExpr nameExpr = condition.getNameExpr();
                SQLExpr valueExpr = condition.getValueExpr();
                if (valueExpr instanceof SQLNullExpr) {
                    codes.add("(doc['" + nameExpr.toString() + "'].empty)");
                } else {
                    codes.add("(" + Util.getScriptValueWithQuote(nameExpr, "'") + condition.getOpertatorSymbol() + Util.getScriptValueWithQuote(valueExpr, "'") + ")");
                }
            }
        } else {
            for (Where subWhere : where.getWheres()) {
                ArrayList<String> subCodes = new ArrayList<String>();
                this.explainWhere(subCodes, subWhere);
                String relation = subWhere.getConn().name().equals("AND") ? "&&" : "||";
                codes.add(Joiner.on((String)relation).join(subCodes));
            }
        }
    }
}

