/*
 * Decompiled with CFR 0.152.
 */
package org.nlpcn.es4sql.domain;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.nlpcn.es4sql.domain.Condition;
import org.nlpcn.es4sql.domain.Field;
import org.nlpcn.es4sql.domain.MethodField;
import org.nlpcn.es4sql.domain.Order;
import org.nlpcn.es4sql.domain.Query;
import org.nlpcn.es4sql.domain.Where;
import org.nlpcn.es4sql.domain.hints.Hint;
import org.nlpcn.es4sql.parse.SubQueryExpression;

public class Select
extends Query {
    private final List<String> aggsFunctions = Arrays.asList("SUM", "MAX", "MIN", "AVG", "TOPHITS", "COUNT", "STATS", "EXTENDED_STATS", "PERCENTILES", "SCRIPTED_METRIC");
    private List<Hint> hints = new ArrayList<Hint>();
    private List<Field> fields = new ArrayList<Field>();
    private List<List<Field>> groupBys = new ArrayList<List<Field>>();
    private List<Order> orderBys = new ArrayList<Order>();
    private int offset;
    private int rowCount = 200;
    private boolean containsSubQueries;
    private List<SubQueryExpression> subQueries;
    public boolean isQuery = false;
    private boolean selectAll = false;
    public boolean isAgg = false;

    public List<Field> getFields() {
        return this.fields;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public void setRowCount(int rowCount) {
        this.rowCount = rowCount;
    }

    public void addGroupBy(Field field) {
        ArrayList<Field> wrapper = new ArrayList<Field>();
        wrapper.add(field);
        this.addGroupBy(wrapper);
    }

    public void addGroupBy(List<Field> fields) {
        this.isAgg = true;
        this.groupBys.add(fields);
    }

    public List<List<Field>> getGroupBys() {
        return this.groupBys;
    }

    public List<Order> getOrderBys() {
        return this.orderBys;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public void addOrderBy(String nestedPath, String name, String type) {
        if ("_score".equals(name)) {
            this.isQuery = true;
        }
        this.orderBys.add(new Order(nestedPath, name, type));
    }

    public void addField(Field field) {
        if (field == null) {
            return;
        }
        if (field.getName().equals("*")) {
            this.selectAll = true;
        }
        if (field instanceof MethodField && this.aggsFunctions.contains(field.getName().toUpperCase())) {
            this.isAgg = true;
        }
        this.fields.add(field);
    }

    public List<Hint> getHints() {
        return this.hints;
    }

    public void fillSubQueries() {
        this.subQueries = new ArrayList<SubQueryExpression>();
        Where where = this.getWhere();
        this.fillSubQueriesFromWhereRecursive(where);
    }

    private void fillSubQueriesFromWhereRecursive(Where where) {
        block5: {
            block4: {
                if (where == null) {
                    return;
                }
                if (!(where instanceof Condition)) break block4;
                Condition condition = (Condition)where;
                if (condition.getValue() instanceof SubQueryExpression) {
                    this.subQueries.add((SubQueryExpression)condition.getValue());
                    this.containsSubQueries = true;
                }
                if (!(condition.getValue() instanceof Object[])) break block5;
                for (Object o : (Object[])condition.getValue()) {
                    if (!(o instanceof SubQueryExpression)) continue;
                    this.subQueries.add((SubQueryExpression)o);
                    this.containsSubQueries = true;
                }
                break block5;
            }
            for (Where innerWhere : where.getWheres()) {
                this.fillSubQueriesFromWhereRecursive(innerWhere);
            }
        }
    }

    public boolean containsSubQueries() {
        return this.containsSubQueries;
    }

    public List<SubQueryExpression> getSubQueries() {
        return this.subQueries;
    }

    public boolean isOrderdSelect() {
        return this.getOrderBys() != null && this.getOrderBys().size() > 0;
    }

    public boolean isSelectAll() {
        return this.selectAll;
    }
}

