/*
 * Decompiled with CFR 0.152.
 */
package org.nlpcn.es4sql.domain;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.common.document.DocumentField;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.bucket.filter.InternalFilter;
import org.elasticsearch.search.aggregations.bucket.terms.InternalTerms;
import org.elasticsearch.search.aggregations.bucket.terms.LongTerms;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.metrics.InternalNumericMetricsAggregation;
import org.elasticsearch.search.aggregations.metrics.tophits.InternalTopHits;
import org.elasticsearch.search.aggregations.metrics.valuecount.InternalValueCount;
import org.nlpcn.es4sql.domain.Select;
import org.nlpcn.es4sql.exception.SqlParseException;

public class SearchResult {
    private List<Map<String, Object>> results;
    private long total;
    double maxScore = 0.0;

    public SearchResult(SearchResponse resp) {
        SearchHits hits = resp.getHits();
        this.total = hits.getTotalHits();
        this.results = new ArrayList<Map<String, Object>>(hits.getHits().length);
        for (SearchHit searchHit : hits.getHits()) {
            if (searchHit.getSourceAsMap() != null) {
                this.results.add(searchHit.getSourceAsMap());
                continue;
            }
            if (searchHit.getFields() == null) continue;
            Map fields = searchHit.getFields();
            this.results.add(this.toFieldsMap(fields));
        }
    }

    public SearchResult(SearchResponse resp, Select select) throws SqlParseException {
        Aggregations aggs = resp.getAggregations();
        if (aggs.get("filter") != null) {
            InternalFilter inf = (InternalFilter)aggs.get("filter");
            aggs = inf.getAggregations();
        }
        if (aggs.get("group by") != null) {
            InternalTerms terms = (InternalTerms)aggs.get("group by");
            List buckets = terms.getBuckets();
            this.total = buckets.size();
            this.results = new ArrayList<Map<String, Object>>(buckets.size());
            for (Terms.Bucket bucket : buckets) {
                Map<String, Object> aggsMap = this.toAggsMap(bucket.getAggregations().getAsMap());
                aggsMap.put("docCount", bucket.getDocCount());
                this.results.add(aggsMap);
            }
        } else {
            this.results = new ArrayList<Map<String, Object>>(1);
            this.total = 1L;
            HashMap<String, Object> map = new HashMap<String, Object>();
            for (Aggregation aggregation : aggs) {
                map.put(aggregation.getName(), this.covenValue(aggregation));
            }
            this.results.add(map);
        }
    }

    private Map<String, Object> toFieldsMap(Map<String, DocumentField> fields) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Map.Entry<String, DocumentField> entry : fields.entrySet()) {
            if (entry.getValue().getValues().size() > 1) {
                result.put(entry.getKey(), entry.getValue().getValues());
                continue;
            }
            result.put(entry.getKey(), entry.getValue().getValue());
        }
        return result;
    }

    private Map<String, Object> toAggsMap(Map<String, Aggregation> fields) throws SqlParseException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Map.Entry<String, Aggregation> entry : fields.entrySet()) {
            result.put(entry.getKey(), this.covenValue(entry.getValue()));
        }
        return result;
    }

    private Object covenValue(Aggregation value) throws SqlParseException {
        if (value instanceof InternalNumericMetricsAggregation.SingleValue) {
            return ((InternalNumericMetricsAggregation.SingleValue)value).value();
        }
        if (value instanceof InternalValueCount) {
            return ((InternalValueCount)value).getValue();
        }
        if (value instanceof InternalTopHits) {
            return value;
        }
        if (value instanceof LongTerms) {
            return value;
        }
        throw new SqlParseException("unknow this agg type " + value.getClass());
    }

    public List<Map<String, Object>> getResults() {
        return this.results;
    }

    public void setResults(List<Map<String, Object>> results) {
        this.results = results;
    }

    public long getTotal() {
        return this.total;
    }

    public void setTotal(long total) {
        this.total = total;
    }

    public double getMaxScore() {
        return this.maxScore;
    }

    public void setMaxScore(double maxScore) {
        this.maxScore = maxScore;
    }
}

