/*
 * Decompiled with CFR 0.152.
 */
package org.nlpcn.es4sql.domain;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.druid.sql.ast.expr.SQLCharExpr;
import com.alibaba.druid.sql.ast.expr.SQLMethodInvokeExpr;
import com.alibaba.druid.sql.ast.expr.SQLNumericLiteralExpr;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.index.query.MatchPhraseQueryBuilder;
import org.elasticsearch.index.query.MatchQueryBuilder;
import org.elasticsearch.index.query.MultiMatchQueryBuilder;
import org.elasticsearch.index.query.Operator;
import org.elasticsearch.index.query.QueryStringQueryBuilder;
import org.elasticsearch.index.query.WildcardQueryBuilder;
import org.nlpcn.es4sql.Util;
import org.nlpcn.es4sql.exception.SqlParseException;

public class Paramer {
    public String analysis;
    public Float boost;
    public String value;
    public Integer slop;
    public Map<String, Float> fieldsBoosts = new HashMap<String, Float>();
    public String type;
    public Float tieBreaker;
    public Operator operator;

    public static Paramer parseParamer(SQLMethodInvokeExpr method) throws SqlParseException {
        Paramer instance = new Paramer();
        List parameters = method.getParameters();
        block20: for (SQLExpr expr : parameters) {
            if (expr instanceof SQLCharExpr) {
                if (instance.value == null) {
                    instance.value = ((SQLCharExpr)expr).getText();
                    continue;
                }
                instance.analysis = ((SQLCharExpr)expr).getText();
                continue;
            }
            if (expr instanceof SQLNumericLiteralExpr) {
                instance.boost = Float.valueOf(((SQLNumericLiteralExpr)expr).getNumber().floatValue());
                continue;
            }
            if (!(expr instanceof SQLBinaryOpExpr)) continue;
            SQLBinaryOpExpr sqlExpr = (SQLBinaryOpExpr)expr;
            switch (Util.expr2Object(sqlExpr.getLeft()).toString()) {
                case "query": {
                    instance.value = Util.expr2Object(sqlExpr.getRight()).toString();
                    break;
                }
                case "analyzer": {
                    instance.analysis = Util.expr2Object(sqlExpr.getRight()).toString();
                    break;
                }
                case "boost": {
                    instance.boost = Float.valueOf(Float.parseFloat(Util.expr2Object(sqlExpr.getRight()).toString()));
                    break;
                }
                case "slop": {
                    instance.slop = Integer.parseInt(Util.expr2Object(sqlExpr.getRight()).toString());
                    break;
                }
                case "fields": {
                    for (String f : Strings.split((String)Util.expr2Object(sqlExpr.getRight()).toString(), (String)",")) {
                        int index = f.lastIndexOf(94);
                        if (-1 < index) {
                            instance.fieldsBoosts.put(f.substring(0, index), Float.valueOf(Float.parseFloat(f.substring(index + 1))));
                            continue;
                        }
                        instance.fieldsBoosts.put(f, Float.valueOf(1.0f));
                    }
                    continue block20;
                }
                case "type": {
                    instance.type = Util.expr2Object(sqlExpr.getRight()).toString();
                    break;
                }
                case "tie_breaker": {
                    instance.tieBreaker = Float.valueOf(Float.parseFloat(Util.expr2Object(sqlExpr.getRight()).toString()));
                    break;
                }
                case "operator": {
                    instance.operator = Operator.fromString((String)Util.expr2Object(sqlExpr.getRight()).toString());
                    break;
                }
            }
        }
        return instance;
    }

    public static ToXContent fullParamer(MatchPhraseQueryBuilder query, Paramer paramer) {
        if (paramer.analysis != null) {
            query.analyzer(paramer.analysis);
        }
        if (paramer.boost != null) {
            query.boost(paramer.boost.floatValue());
        }
        if (paramer.slop != null) {
            query.slop(paramer.slop.intValue());
        }
        return query;
    }

    public static ToXContent fullParamer(MatchQueryBuilder query, Paramer paramer) {
        if (paramer.analysis != null) {
            query.analyzer(paramer.analysis);
        }
        if (paramer.boost != null) {
            query.boost(paramer.boost.floatValue());
        }
        return query;
    }

    public static ToXContent fullParamer(WildcardQueryBuilder query, Paramer paramer) {
        if (paramer.boost != null) {
            query.boost(paramer.boost.floatValue());
        }
        return query;
    }

    public static ToXContent fullParamer(QueryStringQueryBuilder query, Paramer paramer) {
        if (paramer.analysis != null) {
            query.analyzer(paramer.analysis);
        }
        if (paramer.boost != null) {
            query.boost(paramer.boost.floatValue());
        }
        if (paramer.slop != null) {
            query.phraseSlop(paramer.slop.intValue());
        }
        return query;
    }

    public static ToXContent fullParamer(MultiMatchQueryBuilder query, Paramer paramer) {
        if (paramer.analysis != null) {
            query.analyzer(paramer.analysis);
        }
        if (paramer.boost != null) {
            query.boost(paramer.boost.floatValue());
        }
        if (paramer.slop != null) {
            query.slop(paramer.slop.intValue());
        }
        if (paramer.type != null) {
            query.type((Object)paramer.type);
        }
        if (paramer.tieBreaker != null) {
            query.tieBreaker(paramer.tieBreaker);
        }
        if (paramer.operator != null) {
            query.operator(paramer.operator);
        }
        return query;
    }
}

