/*
 * Decompiled with CFR 0.152.
 */
package org.nlpcn.es4sql;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLNumericLiteralExpr;
import com.alibaba.druid.sql.ast.expr.SQLPropertyExpr;
import com.alibaba.druid.sql.ast.expr.SQLVariantRefExpr;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import org.elasticsearch.common.collect.Tuple;
import org.nlpcn.es4sql.Util;
import org.nlpcn.es4sql.domain.KVValue;

public class SQLFunctions {
    public static final Set<String> buildInFunctions = Sets.newHashSet((Object[])new String[]{"exp", "log", "log10", "sqrt", "cbrt", "ceil", "floor", "rint", "pow", "round", "random", "abs", "split", "concat_ws", "substring", "trim", "add", "multiply", "divide", "subtract", "modulus", "field", "date_format"});

    public static Tuple<String, String> function(String methodName, List<KVValue> paramers, String name, boolean returnValue) {
        Tuple functionStr = null;
        switch (methodName) {
            case "split": {
                if (paramers.size() == 3) {
                    functionStr = SQLFunctions.split(Util.expr2Object((SQLExpr)paramers.get((int)0).value).toString(), Util.expr2Object((SQLExpr)paramers.get((int)1).value).toString(), Integer.parseInt(Util.expr2Object((SQLExpr)paramers.get((int)2).value).toString()), name);
                    break;
                }
                functionStr = SQLFunctions.split(paramers.get((int)0).value.toString(), paramers.get((int)1).value.toString(), name);
                break;
            }
            case "concat_ws": {
                ArrayList result = Lists.newArrayList();
                for (int i = 1; i < paramers.size(); ++i) {
                    result.add((SQLExpr)paramers.get((int)i).value);
                }
                functionStr = SQLFunctions.concat_ws(paramers.get((int)0).value.toString(), result, name);
                break;
            }
            case "date_format": {
                functionStr = SQLFunctions.date_format(Util.expr2Object((SQLExpr)paramers.get((int)0).value).toString(), Util.expr2Object((SQLExpr)paramers.get((int)1).value).toString(), 2 < paramers.size() ? Util.expr2Object((SQLExpr)paramers.get((int)2).value).toString() : null, name);
                break;
            }
            case "floor": 
            case "round": 
            case "log": 
            case "log10": 
            case "ceil": 
            case "cbrt": 
            case "rint": 
            case "pow": 
            case "exp": 
            case "sqrt": {
                functionStr = SQLFunctions.mathSingleValueTemplate("Math." + methodName, methodName, Util.expr2Object((SQLExpr)paramers.get((int)0).value).toString(), name);
                break;
            }
            case "substring": {
                functionStr = SQLFunctions.substring(Util.expr2Object((SQLExpr)paramers.get((int)0).value).toString(), Integer.parseInt(Util.expr2Object((SQLExpr)paramers.get((int)1).value).toString()), Integer.parseInt(Util.expr2Object((SQLExpr)paramers.get((int)2).value).toString()), name);
                break;
            }
            case "trim": {
                functionStr = SQLFunctions.trim(Util.expr2Object((SQLExpr)paramers.get((int)0).value).toString(), name);
                break;
            }
            case "add": {
                functionStr = SQLFunctions.add((SQLExpr)paramers.get((int)0).value, (SQLExpr)paramers.get((int)1).value);
                break;
            }
            case "subtract": {
                functionStr = SQLFunctions.subtract((SQLExpr)paramers.get((int)0).value, (SQLExpr)paramers.get((int)1).value);
                break;
            }
            case "divide": {
                functionStr = SQLFunctions.divide((SQLExpr)paramers.get((int)0).value, (SQLExpr)paramers.get((int)1).value);
                break;
            }
            case "multiply": {
                functionStr = SQLFunctions.multiply((SQLExpr)paramers.get((int)0).value, (SQLExpr)paramers.get((int)1).value);
                break;
            }
            case "modulus": {
                functionStr = SQLFunctions.modulus((SQLExpr)paramers.get((int)0).value, (SQLExpr)paramers.get((int)1).value);
                break;
            }
            case "field": {
                functionStr = SQLFunctions.field(Util.expr2Object((SQLExpr)paramers.get((int)0).value).toString());
                break;
            }
        }
        if (returnValue) {
            String generatedFieldName = (String)functionStr.v1();
            String returnCommand = ";return " + generatedFieldName + ";";
            String newScript = (String)functionStr.v2() + returnCommand;
            functionStr = new Tuple((Object)generatedFieldName, (Object)newScript);
        }
        return functionStr;
    }

    public static String random() {
        return Math.abs(new Random().nextInt()) + "";
    }

    private static Tuple<String, String> concat_ws(String split, List<SQLExpr> columns, String valueName) {
        String name = "concat_ws_" + SQLFunctions.random();
        ArrayList result = Lists.newArrayList();
        for (SQLExpr column : columns) {
            String strColumn = Util.expr2Object(column).toString();
            if (strColumn.startsWith("def ")) {
                result.add(strColumn);
                continue;
            }
            if (SQLFunctions.isProperty(column)) {
                result.add("doc['" + strColumn + "'].value");
                continue;
            }
            result.add("'" + strColumn + "'");
        }
        return new Tuple((Object)name, (Object)("def " + name + " =" + Joiner.on((String)("+ " + split + " +")).join((Iterable)result)));
    }

    public static Tuple<String, String> split(String strColumn, String pattern, int index, String valueName) {
        String name = "split_" + SQLFunctions.random();
        String script = "";
        script = valueName == null ? "def " + name + " = doc['" + strColumn + "'].value.split('" + pattern + "')[" + index + "]" : "; def " + name + " = " + valueName + ".split('" + pattern + "')[" + index + "]";
        return new Tuple((Object)name, (Object)script);
    }

    private static Tuple<String, String> date_format(String strColumn, String pattern, String zoneId, String valueName) {
        String name = "date_format_" + SQLFunctions.random();
        if (valueName == null) {
            return new Tuple((Object)name, (Object)("def " + name + " = DateTimeFormatter.ofPattern('" + pattern + "').withZone(" + (zoneId != null ? "ZoneId.of('" + zoneId + "')" : "ZoneId.systemDefault()") + ").format(Instant.ofEpochMilli(doc['" + strColumn + "'].value.getMillis()))"));
        }
        return new Tuple((Object)name, (Object)(strColumn + "; def " + name + " = new SimpleDateFormat('" + pattern + "').format(new Date(" + valueName + " - 8*1000*60*60))"));
    }

    public static Tuple<String, String> add(SQLExpr a, SQLExpr b) {
        return SQLFunctions.binaryOpertator("add", "+", a, b);
    }

    private static Tuple<String, String> modulus(SQLExpr a, SQLExpr b) {
        return SQLFunctions.binaryOpertator("modulus", "%", a, b);
    }

    public static Tuple<String, String> field(String a) {
        String name = "field_" + SQLFunctions.random();
        return new Tuple((Object)name, (Object)("def " + name + " = doc['" + a + "'].value"));
    }

    private static Tuple<String, String> subtract(SQLExpr a, SQLExpr b) {
        return SQLFunctions.binaryOpertator("subtract", "-", a, b);
    }

    private static Tuple<String, String> multiply(SQLExpr a, SQLExpr b) {
        return SQLFunctions.binaryOpertator("multiply", "*", a, b);
    }

    private static Tuple<String, String> divide(SQLExpr a, SQLExpr b) {
        return SQLFunctions.binaryOpertator("divide", "/", a, b);
    }

    private static Tuple<String, String> binaryOpertator(String methodName, String operator, SQLExpr a, SQLExpr b) {
        String name = methodName + "_" + SQLFunctions.random();
        return new Tuple((Object)name, (Object)(SQLFunctions.scriptDeclare(a) + SQLFunctions.scriptDeclare(b) + SQLFunctions.convertType(a) + SQLFunctions.convertType(b) + " def " + name + " = " + SQLFunctions.extractName(a) + " " + operator + " " + SQLFunctions.extractName(b)));
    }

    private static boolean isProperty(SQLExpr expr) {
        return expr instanceof SQLIdentifierExpr || expr instanceof SQLPropertyExpr || expr instanceof SQLVariantRefExpr;
    }

    private static String scriptDeclare(SQLExpr a) {
        if (SQLFunctions.isProperty(a) || a instanceof SQLNumericLiteralExpr) {
            return "";
        }
        return Util.expr2Object(a).toString() + ";";
    }

    private static String extractName(SQLExpr script) {
        if (SQLFunctions.isProperty(script)) {
            return "doc['" + script + "'].value";
        }
        String scriptStr = Util.expr2Object(script).toString();
        String[] variance = scriptStr.split(";");
        String newScript = variance[variance.length - 1];
        if (newScript.trim().startsWith("def ")) {
            return newScript.substring(4).split("=")[0].trim();
        }
        return scriptStr;
    }

    private static String convertType(SQLExpr script) {
        String[] variance = Util.expr2Object(script).toString().split(";");
        String newScript = variance[variance.length - 1];
        if (newScript.trim().startsWith("def ")) {
            String temp = newScript.substring(4).split("=")[0].trim();
            return " if( " + temp + " instanceof String) " + temp + "= Double.parseDouble(" + temp.trim() + "); ";
        }
        return "";
    }

    public static Tuple<String, String> log(String strColumn, String valueName) {
        return SQLFunctions.mathSingleValueTemplate("log", strColumn, valueName);
    }

    public static Tuple<String, String> log10(String strColumn, String valueName) {
        return SQLFunctions.mathSingleValueTemplate("log10", strColumn, valueName);
    }

    public static Tuple<String, String> sqrt(String strColumn, String valueName) {
        return SQLFunctions.mathSingleValueTemplate("Math.sqrt", "sqrt", strColumn, valueName);
    }

    public static Tuple<String, String> round(String strColumn, String valueName) {
        return SQLFunctions.mathSingleValueTemplate("Math.round", "round", strColumn, valueName);
    }

    public static Tuple<String, String> trim(String strColumn, String valueName) {
        return SQLFunctions.strSingleValueTemplate("trim", strColumn, valueName);
    }

    private static Tuple<String, String> mathSingleValueTemplate(String methodName, String strColumn, String valueName) {
        return SQLFunctions.mathSingleValueTemplate(methodName, methodName, strColumn, valueName);
    }

    private static Tuple<String, String> mathSingleValueTemplate(String methodName, String fieldName, String strColumn, String valueName) {
        String name = fieldName + "_" + SQLFunctions.random();
        if (valueName == null) {
            return new Tuple((Object)name, (Object)("def " + name + " = " + methodName + "(doc['" + strColumn + "'].value)"));
        }
        return new Tuple((Object)name, (Object)(strColumn + ";def " + name + " = " + methodName + "(" + valueName + ")"));
    }

    public static Tuple<String, String> strSingleValueTemplate(String methodName, String strColumn, String valueName) {
        String name = methodName + "_" + SQLFunctions.random();
        if (valueName == null) {
            return new Tuple((Object)name, (Object)("def " + name + " = doc['" + strColumn + "'].value." + methodName + "()"));
        }
        return new Tuple((Object)name, (Object)(strColumn + "; def " + name + " = " + valueName + "." + methodName + "()"));
    }

    public static Tuple<String, String> floor(String strColumn, String valueName) {
        return SQLFunctions.mathSingleValueTemplate("Math.floor", "floor", strColumn, valueName);
    }

    public static Tuple<String, String> substring(String strColumn, int pos, int len, String valueName) {
        String name = "substring_" + SQLFunctions.random();
        if (valueName == null) {
            return new Tuple((Object)name, (Object)("def " + name + " = doc['" + strColumn + "'].value.substring(" + pos + "," + len + ")"));
        }
        return new Tuple((Object)name, (Object)(strColumn + ";def " + name + " = " + valueName + ".substring(" + pos + "," + len + ")"));
    }

    public static Tuple<String, String> split(String strColumn, String pattern, String valueName) {
        String name = "split_" + SQLFunctions.random();
        if (valueName == null) {
            return new Tuple((Object)name, (Object)("def " + name + " = doc['" + strColumn + "'].value.split('" + pattern + "')"));
        }
        return new Tuple((Object)name, (Object)(strColumn + "; def " + name + " = " + valueName + ".split('" + pattern + "')"));
    }
}

