/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.plugin.nlpcn;

import java.io.IOException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.admin.indices.get.GetIndexRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.plugin.nlpcn.ElasticJoinExecutor;
import org.elasticsearch.plugin.nlpcn.GetIndexRequestRestListener;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.action.RestStatusToXContentListener;
import org.nlpcn.es4sql.exception.SqlParseException;
import org.nlpcn.es4sql.query.SqlElasticDeleteByQueryRequestBuilder;
import org.nlpcn.es4sql.query.SqlElasticRequestBuilder;
import org.nlpcn.es4sql.query.join.JoinRequestBuilder;

public class ActionRequestRestExecuter {
    private RestChannel channel;
    private Client client;
    private SqlElasticRequestBuilder requestBuilder;

    public ActionRequestRestExecuter(SqlElasticRequestBuilder requestBuilder, RestChannel channel, Client client) {
        this.requestBuilder = requestBuilder;
        this.channel = channel;
        this.client = client;
    }

    public void execute() throws Exception {
        ActionRequest request = this.requestBuilder.request();
        if (this.requestBuilder instanceof JoinRequestBuilder) {
            this.executeJoinRequestAndSendResponse();
        } else if (request instanceof SearchRequest) {
            this.client.search((SearchRequest)request, (ActionListener)new RestStatusToXContentListener(this.channel));
        } else {
            if (this.requestBuilder instanceof SqlElasticDeleteByQueryRequestBuilder) {
                throw new UnsupportedOperationException("currently not support delete on elastic 2.0.0");
            }
            if (request instanceof GetIndexRequest) {
                this.requestBuilder.getBuilder().execute((ActionListener)new GetIndexRequestRestListener(this.channel, (GetIndexRequest)request));
            } else {
                throw new Exception(String.format("Unsupported ActionRequest provided: %s", request.getClass().getName()));
            }
        }
    }

    private void executeJoinRequestAndSendResponse() throws IOException, SqlParseException {
        ElasticJoinExecutor executor = ElasticJoinExecutor.createJoinExecutor(this.client, this.requestBuilder);
        executor.run();
        executor.sendResponse(this.channel);
    }
}

