/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.actions;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JMenuItem;
import org.netbeans.modules.xml.util.Util;
import org.openide.awt.JInlineMenu;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.FolderLookup;
import org.openide.util.Lookup;
import org.openide.util.WeakListeners;
import org.openide.util.actions.Presenter;
import org.openide.util.actions.SystemAction;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public abstract class CollectSystemAction
extends SystemAction
implements Presenter.Popup {
    private static final long serialVersionUID = 6517322512481423122L;
    private Lookup.Result allActionsResult;
    static JMenuItem[] NONE = new JMenuItem[0];
    protected final List registeredAction = new ArrayList();

    protected abstract Class getActionLookClass();

    protected synchronized Collection getPossibleActions() {
        if (this.allActionsResult == null) {
            this.allActionsResult = Lookup.getDefault().lookup(new Lookup.Template(this.getActionLookClass()));
            this.addRegisteredAction();
        }
        return this.registeredAction;
    }

    protected abstract void addRegisteredAction();

    protected void addRegisteredAction(String folderPath) {
        ArrayList<String> actionClassNames = new ArrayList<String>();
        for (Object obj : this.registeredAction) {
            if (obj == null) continue;
            actionClassNames.add(obj.getClass().getName());
        }
        this.addRegisteredAction(this.allActionsResult, actionClassNames);
        this.addActionFromFolder(folderPath, actionClassNames);
    }

    private void addActionFromFolder(String folderPath, List<String> registeredActionClassNames) {
        FileObject layerRoot = Repository.getDefault().getDefaultFileSystem().getRoot();
        FileObject xmlActionsFileObj = layerRoot.getFileObject(folderPath);
        DataFolder xmlActionsFolder = DataFolder.findFolder((FileObject)xmlActionsFileObj);
        FolderLookup folderLookup = new FolderLookup((DataObject.Container)xmlActionsFolder);
        Lookup.Result xmlActionsResult = folderLookup.getLookup().lookup(new Lookup.Template(this.getActionLookClass()));
        this.addRegisteredAction(xmlActionsResult, registeredActionClassNames);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addRegisteredAction(Lookup.Result xmlActionsResult, List<String> registeredActionClassNames) {
        if (xmlActionsResult == null) {
            return;
        }
        List list = this.registeredAction;
        synchronized (list) {
            Collection lookupActions = xmlActionsResult.allInstances();
            for (Object lookupAction : lookupActions) {
                String lookupActionClassName = lookupAction.getClass().getName();
                if (registeredActionClassNames.contains(lookupActionClassName)) continue;
                this.registeredAction.add(lookupAction);
            }
        }
    }

    private JMenuItem[] createMenu() {
        JMenuItem[] menu = this.createMenu(this.getPossibleActions());
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("--- CollectSystemAction.createMenu: menu = " + menu);
        }
        return menu;
    }

    private JMenuItem[] createMenu(Collection coll) {
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("\n--> CollectSystemAction.createMenu: ( " + coll + " )");
        }
        ArrayList<JMenuItem> items = new ArrayList<JMenuItem>();
        for (SystemAction a : coll) {
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("-*- CollectSystemAction.createMenu: next action " + a + " -- " + (a.isEnabled() ? "<enabled>" : "[disabled]"));
            }
            if (!a.isEnabled()) continue;
            JMenuItem item = null;
            if (a instanceof Presenter.Popup) {
                item = ((Presenter.Popup)a).getPopupPresenter();
            }
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("-*- CollectSystemAction.createMenu: menu item = " + item);
            }
            if (item == null) continue;
            items.add(item);
        }
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("<-- CollectSystemAction.createMenu: all items = " + items + "\n");
        }
        JMenuItem[] array = new JMenuItem[items.size()];
        items.toArray(array);
        return array;
    }

    public JMenuItem getPopupPresenter() {
        return new Menu();
    }

    public void actionPerformed(ActionEvent e) {
    }

    private class Menu
    extends JInlineMenu {
        private static final long serialVersionUID = -4962039848190160129L;
        private JMenuItem[] last = NONE;
        private PropL propL = new PropL();
        boolean needsChange = false;

        Menu() {
            this.changeMenuItems(CollectSystemAction.this.createMenu());
            TopComponent.Registry r = WindowManager.getDefault().getRegistry();
            r.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.propL, (Object)r));
        }

        synchronized void changeMenuItems(JMenuItem[] items) {
            this.removeListeners(this.last);
            this.addListeners(items);
            this.last = items;
            this.setMenuItems(items);
        }

        private void addListeners(JMenuItem[] items) {
            int len = items.length;
            for (int i = 0; i < len; ++i) {
                items[i].addPropertyChangeListener(this.propL);
            }
        }

        private void removeListeners(JMenuItem[] items) {
            int len = items.length;
            for (int i = 0; i < len; ++i) {
                items[i].removePropertyChangeListener(this.propL);
            }
        }

        public void addNotify() {
            if (this.needsChange) {
                this.changeMenuItems(CollectSystemAction.this.createMenu());
                this.needsChange = false;
            }
            super.addNotify();
        }

        public void removeNotify() {
            this.removeListeners(this.last);
            this.last = NONE;
        }

        private class PropL
        implements PropertyChangeListener {
            private PropL() {
            }

            @Override
            public void propertyChange(PropertyChangeEvent ev) {
                String name = ev.getPropertyName();
                if (name == null || name.equals("enabled") || name.equals("activatedNodes")) {
                    Menu.this.needsChange = true;
                }
            }
        }
    }
}

