/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.text.DateFormat;
import java.text.Format;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import org.netbeans.modules.xml.XMLDataObject;
import org.netbeans.modules.xml.util.Util;
import org.openide.ErrorManager;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataLoaderPool;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.ExtensionList;
import org.openide.loaders.FileEntry;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.loaders.UniFileLoader;
import org.openide.util.MapFormat;

public class XMLDataLoader
extends UniFileLoader {
    private static final long serialVersionUID = 3824119075670384804L;
    private static final String XML_EXT = "xml";
    private static final String XMLINFO_EXT = "xmlinfo";

    public XMLDataLoader() {
        super("org.netbeans.modules.xml.XMLDataObject");
    }

    protected void initialize() {
        super.initialize();
        ExtensionList ext = this.getExtensions();
        ext.addExtension(XML_EXT);
        ext.addMimeType("text/xml");
        ext.addMimeType("application/xml");
        this.setExtensions(ext);
    }

    protected String actionsContext() {
        return "Loaders/text/xml-mime/Actions/";
    }

    protected String defaultDisplayName() {
        return Util.THIS.getString(XMLDataLoader.class, "PROP_XmlLoader_Name");
    }

    protected FileObject findPrimaryFile(FileObject fo) {
        if (fo.isFolder()) {
            return null;
        }
        FileObject res = null;
        if (super.findPrimaryFile(fo) != null) {
            res = fo;
        } else if (XMLINFO_EXT.equals(fo.getExt())) {
            res = FileUtil.findBrother((FileObject)fo, (String)XML_EXT);
        } else if (fo.getMIMEType().endsWith("+xml")) {
            res = fo;
        }
        try {
            if (res != null && res.getFileSystem().isDefault() && DataLoaderPool.getPreferredLoader((FileObject)res) != this && !XMLDataLoader.isTemplate(res)) {
                res = null;
            }
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            // empty catch block
        }
        return res;
    }

    private static boolean isTemplate(FileObject fo) {
        Object o = fo.getAttribute("template");
        boolean ret = false;
        if (o instanceof Boolean) {
            ret = (Boolean)o;
        }
        return ret;
    }

    protected MultiDataObject createMultiObject(FileObject primaryFile) throws DataObjectExistsException {
        return new XMLDataObject(primaryFile, (MultiFileLoader)this);
    }

    protected MultiDataObject.Entry createPrimaryEntry(MultiDataObject obj, FileObject primaryFile) {
        return new XMLFileEntry(obj, primaryFile);
    }

    protected MultiDataObject.Entry createSecondaryEntry(MultiDataObject obj, FileObject secondaryFile) {
        return new FileEntry(obj, secondaryFile);
    }

    public static class XMLFileEntry
    extends FileEntry.Format {
        private static final long serialVersionUID = -7300320795693949470L;
        boolean disableInputStream;
        private Collection<InputStream> activeReaders;

        public XMLFileEntry(MultiDataObject obj, FileObject file) {
            super(obj, file);
        }

        protected Format createFormat(FileObject target, String name, String ext) {
            HashMap<String, String> map = new HashMap<String, String>();
            Date now = new Date();
            map.put("NAME", name + "." + ext);
            map.put("ROOT", "root");
            map.put("DATE", DateFormat.getDateInstance(1).format(now));
            map.put("TIME", DateFormat.getTimeInstance(3).format(now));
            map.put("USER", System.getProperty("user.name"));
            MapFormat format = new MapFormat(map);
            format.setLeftBrace("__");
            format.setRightBrace("__");
            format.setExactMatch(false);
            return format;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public FileObject createFromTemplate(FileObject f, String name) throws IOException {
            String ext = this.getFile().getExt();
            if (name == null) {
                name = FileUtil.findFreeFileName((FileObject)f, (String)this.getFile().getName(), (String)ext);
            }
            FileObject fo = f.createData(name, ext);
            Format frm = this.createFormat(f, name, ext);
            try (BufferedReader r = new BufferedReader(new InputStreamReader(this.getFile().getInputStream(), "UTF8"));){
                FileLock lock = fo.lock();
                try (BufferedWriter w = new BufferedWriter(new OutputStreamWriter(fo.getOutputStream(lock), "UTF8"));){
                    String current;
                    String line = null;
                    while ((current = r.readLine()) != null) {
                        line = frm.format(current);
                        w.write(line);
                        w.newLine();
                    }
                }
                finally {
                    lock.releaseLock();
                }
            }
            FileUtil.copyAttributes((FileObject)this.getFile(), (FileObject)fo);
            try {
                DataObject.find((FileObject)fo).setTemplate(false);
            }
            catch (DataObjectNotFoundException ex) {
                ErrorManager.getDefault().notify((Throwable)ex);
            }
            return fo;
        }

        private synchronized void addReader(InputStream r) {
            if (this.activeReaders == null) {
                this.activeReaders = new LinkedList<InputStream>();
            }
            this.activeReaders.add(r);
        }

        private synchronized void removeReader(InputStream r) {
            if (this.activeReaders == null) {
                return;
            }
            this.activeReaders.remove(r);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void delete() throws IOException {
            XMLFileEntry xMLFileEntry = this;
            synchronized (xMLFileEntry) {
                if (this.activeReaders != null && this.activeReaders.size() > 0) {
                    Iterator<InputStream> it = this.activeReaders.iterator();
                    while (it.hasNext()) {
                        InputStream r = it.next();
                        r.close();
                        it.remove();
                    }
                }
                this.activeReaders = null;
                this.disableInputStream = true;
            }
            super.delete();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public InputStream getInputStream() throws FileNotFoundException {
            FileObject fob = this.getFile();
            XMLFileEntry xMLFileEntry = this;
            synchronized (xMLFileEntry) {
                if (this.disableInputStream) {
                    throw new FileNotFoundException("File is being deleted.");
                }
                NotifyInputStream s = new NotifyInputStream(fob.getInputStream());
                this.addReader(s);
                return s;
            }
        }

        public FileLock takeLock() throws IOException {
            FileLock lock = super.takeLock();
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("XMLDataLoader.XMLEntry.takeLock()/" + this.getFile() + "=" + lock);
            }
            return lock;
        }

        private class NotifyInputStream
        extends FilterInputStream {
            public NotifyInputStream(InputStream is) {
                super(is);
            }

            @Override
            public void close() throws IOException {
                super.close();
                XMLFileEntry.this.removeReader(this);
            }
        }
    }
}

