/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.wizard.impl;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import org.netbeans.modules.xml.wizard.SchemaParser;
import org.netbeans.modules.xml.wizard.impl.ExternalReferenceDecorator;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.NbBundle;

public class ExternalReferenceDataNode
extends FilterNode {
    public static final String PROP_SELECTED = "selected";
    public static final String PROP_PREFIX = "prefix";
    private Sheet sheet;
    private boolean selected;
    private String prefix = null;
    private static int counter = 0;
    private ExternalReferenceDecorator decorator;
    private boolean resolveThroughCatalog;

    public ExternalReferenceDataNode(Node original, ExternalReferenceDecorator dec) {
        super(original, (org.openide.nodes.Children)new Children(original, dec));
        this.decorator = dec;
    }

    public void setResolveThroughCatalog(boolean resolve) {
        this.resolveThroughCatalog = resolve;
    }

    public boolean canRename() {
        return false;
    }

    public boolean canSelect() {
        DataObject dobj = (DataObject)this.getLookup().lookup(DataObject.class);
        return dobj != null && !dobj.getPrimaryFile().isFolder();
    }

    private Node.Property createProperty(String key, Class type, Object inst, String getter, String setter) {
        PropertySupport.Reflection prop = null;
        try {
            prop = new PropertySupport.Reflection(inst, type, getter, setter);
            prop.setName(key);
            prop.setDisplayName(NbBundle.getMessage(ExternalReferenceDataNode.class, (String)("CTL_SchemaPanel_Column_Name_" + key)));
            prop.setShortDescription(NbBundle.getMessage(ExternalReferenceDataNode.class, (String)("CTL_SchemaPanel_Column_Desc_" + key)));
        }
        catch (NoSuchMethodException nsme) {
            ErrorManager.getDefault().notify((Throwable)nsme);
        }
        return prop;
    }

    protected Sheet createSheet() {
        Sheet sheet = Sheet.createDefault();
        Sheet.Set set = sheet.get("properties");
        set.put(this.createProperty("name", String.class, (Object)this, "getHtmlDisplayName", null));
        if (this.canSelect()) {
            set.put(this.createProperty(PROP_SELECTED, Boolean.TYPE, (Object)this, "isSelected", "setSelected"));
        }
        return sheet;
    }

    protected final synchronized Sheet getSheet() {
        if (this.sheet != null) {
            return this.sheet;
        }
        this.sheet = this.createSheet();
        this.firePropertySetsChange(null, null);
        return this.sheet;
    }

    public Node.PropertySet[] getPropertySets() {
        Sheet s = this.getSheet();
        return s.toArray();
    }

    public String getHtmlDisplayName() {
        String name = this.getOriginal().getHtmlDisplayName();
        return name;
    }

    public String getPrefix() {
        if (this.prefix == null) {
            DataObject dobj = (DataObject)this.getLookup().lookup(DataObject.class);
            this.prefix = dobj != null && !dobj.getPrimaryFile().isFolder() ? this.decorator.generatePrefix(this.prefix, dobj) : "";
        }
        return this.prefix;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setDisplayName(String s) {
        super.disableDelegation(12);
        super.setDisplayName(s);
    }

    public void setPrefix(String prefix) {
        String old = this.prefix;
        this.prefix = prefix;
        this.firePropertyChange(PROP_PREFIX, old, prefix);
    }

    public void setSelected(boolean selected) {
        if (!this.canSelect()) {
            throw new IllegalStateException("node cannot be selected");
        }
        boolean old = this.selected;
        this.selected = selected;
        this.firePropertyChange(PROP_SELECTED, new Boolean(old), new Boolean(selected));
    }

    public String getNamespace() {
        DataObject dobj = (DataObject)this.getLookup().lookup(DataObject.class);
        if (dobj != null) {
            FileObject fobj = dobj.getPrimaryFile();
            return SchemaParser.getNamespace(fobj);
        }
        return null;
    }

    public boolean isResolveThroughCatalog() {
        return this.resolveThroughCatalog;
    }

    public String getSchemaFileName() {
        DataObject dobj = (DataObject)this.getLookup().lookup(DataObject.class);
        if (dobj != null) {
            FileObject fobj = dobj.getPrimaryFile();
            File file = FileUtil.toFile((FileObject)fobj);
            String uri = file.getPath();
            if (uri != null) {
                try {
                    uri = new URI(uri).toASCIIString();
                }
                catch (URISyntaxException uRISyntaxException) {
                    // empty catch block
                }
            }
            return uri;
        }
        return null;
    }

    private static class Children
    extends FilterNode.Children {
        ExternalReferenceDecorator decorator;

        public Children(Node original, ExternalReferenceDecorator dec) {
            super(original);
            this.decorator = dec;
        }

        protected Node[] createNodes(Node n) {
            DataObject dobj = (DataObject)n.getLookup().lookup(DataObject.class);
            if (dobj != null) {
                FileObject fobj = dobj.getPrimaryFile();
                if (fobj.isFolder() && fobj.getNameExt().equals("nbproject") && fobj.getFileObject("project.xml") != null) {
                    return new Node[0];
                }
                String fname = fobj.getNameExt();
                String ext = this.decorator.getDocumentType();
                if (fobj.isFolder() || fname.endsWith(ext)) {
                    return super.createNodes(n);
                }
            }
            return new Node[0];
        }

        protected Node copyNode(Node node) {
            return this.decorator.createExternalReferenceNode(node);
        }
    }
}

