/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.tax.beans.editor;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.Customizer;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.DefaultCellEditor;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.netbeans.modules.xml.tax.beans.Lib;
import org.netbeans.modules.xml.tax.beans.TreeObjectListProxyListener;
import org.netbeans.modules.xml.tax.beans.editor.Util;
import org.netbeans.modules.xml.tax.util.TAXUtil;
import org.netbeans.tax.TreeAttribute;
import org.netbeans.tax.TreeException;
import org.netbeans.tax.TreeName;
import org.netbeans.tax.TreeNamedObjectMap;
import org.netbeans.tax.TreeObjectList;
import org.openide.util.WeakListeners;

public class TreeElementAttributeListCustomizer
extends JPanel
implements Customizer,
PropertyChangeListener {
    private static final long serialVersionUID = 1071471854210683733L;
    private String headerToolTip = Util.THIS.getString("PROP_headerTooltip");
    private final int COL_NAME = 0;
    private final int COL_VALUE = 1;
    private final int COL_COUNT = 2;
    private JTable attrTable;
    private JButton addButton;
    private JScrollPane tableScrollPane;
    private JButton downButton;
    private JButton upButton;
    private JButton removeButton;
    private TreeNamedObjectMap peer;
    private AttlistTableModel tableModel;

    public TreeElementAttributeListCustomizer() {
        this.initComponents();
        this.upButton.setMnemonic(Util.THIS.getChar("MNE_element_attributelist_up"));
        this.downButton.setMnemonic(Util.THIS.getChar("MNE_element_attributelist_down"));
        this.removeButton.setMnemonic(Util.THIS.getChar("MNE_element_attributelist_remove"));
        this.addButton.setMnemonic(Util.THIS.getChar("MNE_element_attributelist_add"));
        this.initAccessibility();
        this.attrTable.getTableHeader().setDefaultRenderer(new HeaderRenderer());
        JTextField editorComponent = new JTextField();
        editorComponent.getCaret().setVisible(true);
        DefaultCellEditor singleClickEditor = new DefaultCellEditor(editorComponent);
        singleClickEditor.setClickCountToStart(1);
        this.attrTable.setDefaultEditor(String.class, singleClickEditor);
        this.attrTable.setSelectionMode(0);
        ListSelectionModel rowsm = this.attrTable.getSelectionModel();
        rowsm.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (Util.THIS.isLoggable()) {
                    Util.THIS.debug("\n#=- TreeElementAttributeListCustomizer::ListSelectionListener.valueChanged: event = " + e);
                }
                if (Util.THIS.isLoggable()) {
                    Util.THIS.debug("#=-     event.getValueIsAdjusting() = " + e.getValueIsAdjusting());
                }
                if (Util.THIS.isLoggable()) {
                    Util.THIS.debug("#=-     event.getFirstIndex()       = " + e.getFirstIndex());
                }
                if (Util.THIS.isLoggable()) {
                    Util.THIS.debug("#=-     event.getLastIndex()        = " + e.getLastIndex());
                }
                if (e.getValueIsAdjusting()) {
                    return;
                }
                ListSelectionModel lsm = (ListSelectionModel)e.getSource();
                if (Util.THIS.isLoggable()) {
                    Util.THIS.debug("#=-     event.getSource()                 = " + lsm);
                }
                if (Util.THIS.isLoggable()) {
                    Util.THIS.debug("#=-     selectionModel.isSelectionEmpty() = " + lsm.isSelectionEmpty());
                }
                if (Util.THIS.isLoggable()) {
                    Util.THIS.debug("#=-     attrTable.getSelectedRow()        = " + TreeElementAttributeListCustomizer.this.attrTable.getSelectedRow());
                }
                if (Util.THIS.isLoggable()) {
                    Util.THIS.debug("#=-     attrTable.getRowCount()           = " + TreeElementAttributeListCustomizer.this.attrTable.getRowCount());
                }
                if (lsm.isSelectionEmpty() || TreeElementAttributeListCustomizer.this.attrTable.getRowCount() == 0) {
                    TreeElementAttributeListCustomizer.this.upButton.setEnabled(false);
                    TreeElementAttributeListCustomizer.this.downButton.setEnabled(false);
                    TreeElementAttributeListCustomizer.this.removeButton.setEnabled(false);
                } else {
                    TreeElementAttributeListCustomizer.this.upButton.setEnabled(TreeElementAttributeListCustomizer.this.attrTable.getSelectedRow() > 0);
                    TreeElementAttributeListCustomizer.this.downButton.setEnabled(TreeElementAttributeListCustomizer.this.attrTable.getSelectedRow() < TreeElementAttributeListCustomizer.this.numRows() - 1);
                    TreeElementAttributeListCustomizer.this.removeButton.setEnabled(true);
                }
            }
        });
        this.attrTable.getTableHeader().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                TableColumnModel colModel = TreeElementAttributeListCustomizer.this.attrTable.getColumnModel();
                int columnIndex = colModel.getColumnIndexAtX(e.getX());
                if (columnIndex < 0) {
                    return;
                }
                int modelIndex = colModel.getColumn(columnIndex).getModelIndex();
                if (modelIndex < 0) {
                    return;
                }
                AttlistTableModel tm = (AttlistTableModel)TreeElementAttributeListCustomizer.this.attrTable.getModel();
                tm.sortByColumn(columnIndex);
            }
        });
    }

    private int numRows() {
        return this.attrTable.getModel().getRowCount();
    }

    private int numCols() {
        return this.attrTable.getModel().getColumnCount();
    }

    private void initComponents() {
        this.tableScrollPane = new JScrollPane();
        this.attrTable = new JTable();
        this.upButton = new JButton();
        this.downButton = new JButton();
        this.addButton = new JButton();
        this.removeButton = new JButton();
        this.setLayout(new GridBagLayout());
        this.setPreferredSize(new Dimension(350, 230));
        this.attrTable.setPreferredScrollableViewportSize(new Dimension(200, 150));
        this.tableScrollPane.setViewportView(this.attrTable);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 0, 0);
        this.add((Component)this.tableScrollPane, gridBagConstraints);
        this.upButton.setText(Util.THIS.getString("TEXT_element_attributelist_up"));
        this.upButton.setEnabled(false);
        this.upButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TreeElementAttributeListCustomizer.this.upButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(12, 12, 0, 11);
        this.add((Component)this.upButton, gridBagConstraints);
        this.downButton.setText(Util.THIS.getString("TEXT_element_attributelist_down"));
        this.downButton.setEnabled(false);
        this.downButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TreeElementAttributeListCustomizer.this.downButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(5, 12, 0, 11);
        this.add((Component)this.downButton, gridBagConstraints);
        this.addButton.setText(Util.THIS.getString("TEXT_element_attributelist_add"));
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TreeElementAttributeListCustomizer.this.addButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(5, 12, 0, 11);
        this.add((Component)this.addButton, gridBagConstraints);
        this.removeButton.setText(Util.THIS.getString("TEXT_element_attributelist_remove"));
        this.removeButton.setEnabled(false);
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TreeElementAttributeListCustomizer.this.removeButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(5, 12, 0, 11);
        this.add((Component)this.removeButton, gridBagConstraints);
    }

    private void addButtonActionPerformed(ActionEvent evt) {
        AttlistTableModel tm = (AttlistTableModel)this.attrTable.getModel();
        tm.addRow();
        int actualIndex = this.numRows() - 1;
        this.attrTable.getSelectionModel().setSelectionInterval(actualIndex, actualIndex);
    }

    private void upButtonActionPerformed(ActionEvent evt) {
        AttlistTableModel tm = (AttlistTableModel)this.attrTable.getModel();
        int index = this.attrTable.getSelectedRow();
        if (index > 0) {
            tm.moveRow(index, index - 1);
            this.attrTable.getSelectionModel().setSelectionInterval(index - 1, index - 1);
        }
    }

    private void removeButtonActionPerformed(ActionEvent evt) {
        AttlistTableModel tm = (AttlistTableModel)this.attrTable.getModel();
        int sel = this.attrTable.getSelectedRow();
        if (sel > -1) {
            tm.removeRow(sel);
            if (this.numRows() > 0) {
                if (sel <= this.numRows() - 1) {
                    this.attrTable.getSelectionModel().setSelectionInterval(sel, sel);
                } else {
                    this.attrTable.getSelectionModel().setSelectionInterval(sel - 1, sel - 1);
                }
            } else {
                this.removeButton.setEnabled(false);
            }
        }
    }

    private void downButtonActionPerformed(ActionEvent evt) {
        AttlistTableModel tm = (AttlistTableModel)this.attrTable.getModel();
        int index = this.attrTable.getSelectedRow();
        if (index > -1 && index < this.numRows() - 1) {
            tm.moveRow(index, index + 1);
            this.attrTable.getSelectionModel().setSelectionInterval(index + 1, index + 1);
        }
    }

    @Override
    public void setObject(Object obj) {
        this.peer = (TreeNamedObjectMap)obj;
        this.tableModel = new AttlistTableModel();
        this.attrTable.setModel(this.tableModel);
        TableColumn column = null;
        for (int i = 0; i < 2; ++i) {
            column = this.attrTable.getColumnModel().getColumn(i);
        }
        this.updateView();
        TreeObjectListProxyListener proxy = new TreeObjectListProxyListener((TreeObjectList)this.peer);
        proxy.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)proxy));
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (e.getSource() == null) {
            return;
        }
        this.updateView();
    }

    private void updateView() {
        this.tableModel.fireTableDataChanged();
    }

    public void initAccessibility() {
        this.getAccessibleContext().setAccessibleDescription(Util.THIS.getString("ACSD_TreeElementAttributeListCustomizer"));
        this.addButton.getAccessibleContext().setAccessibleDescription(Util.THIS.getString("ACSD_addButton"));
        this.removeButton.getAccessibleContext().setAccessibleDescription(Util.THIS.getString("ACSD_removeButton"));
        this.upButton.getAccessibleContext().setAccessibleDescription(Util.THIS.getString("ACSD_upButton"));
        this.downButton.getAccessibleContext().setAccessibleDescription(Util.THIS.getString("ACSD_downButton"));
        this.attrTable.getAccessibleContext().setAccessibleDescription(Util.THIS.getString("ACSD_attrTable"));
        this.attrTable.getAccessibleContext().setAccessibleName(Util.THIS.getString("ACSN_attrTable"));
    }

    private class HeaderRenderer
    extends JLabel
    implements TableCellRenderer {
        private static final long serialVersionUID = -3658206203140258583L;

        public HeaderRenderer() {
            this.setHorizontalAlignment(2);
            this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
            this.setToolTipText(TreeElementAttributeListCustomizer.this.headerToolTip);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JTableHeader header;
            if (table != null && (header = table.getTableHeader()) != null) {
                this.setForeground(header.getForeground());
                this.setBackground(header.getBackground());
                this.setFont(header.getFont());
            }
            AttlistTableModel tm = (AttlistTableModel)table.getModel();
            if (column == tm.SortedColumn) {
                this.setIcon(tm.ascending ? new ImageIcon(this.getClass().getResource("down.gif")) : new ImageIcon(this.getClass().getResource("up.gif")));
            } else {
                this.setIcon(new ImageIcon(this.getClass().getResource("no.gif")));
            }
            this.setText(value == null ? "" : value.toString());
            return this;
        }
    }

    private class AttlistTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1567143493464383838L;
        boolean ascending = true;
        int SortedColumn = -1;
        int[] indexes;

        @Override
        public int getRowCount() {
            return TreeElementAttributeListCustomizer.this.peer.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        public Class getColumnClass(int index) {
            return String.class;
        }

        public void addRow() {
            TreeAttribute attr = Lib.createAttributeDialog(true);
            if (attr != null) {
                boolean toSet = true;
                TreeAttribute oldAttribute = (TreeAttribute)TreeElementAttributeListCustomizer.this.peer.get((Object)attr.getTreeName());
                if (oldAttribute != null) {
                    toSet = Lib.confirmAction(Util.THIS.getString("MSG_replace_attribute", attr.getQName()));
                }
                if (toSet) {
                    TreeElementAttributeListCustomizer.this.peer.add((Object)attr);
                    this.SortedColumn = -1;
                    this.fireTableStructureChanged();
                }
            }
        }

        public void removeRow(int row) {
            TreeElementAttributeListCustomizer.this.peer.remove(row);
            this.fireTableStructureChanged();
        }

        public void moveRow(int fromIndex, int toIndex) {
            try {
                TreeElementAttributeListCustomizer.this.peer.switchObjects(fromIndex, toIndex);
                this.SortedColumn = -1;
                this.fireTableStructureChanged();
            }
            catch (TreeException exc) {
                TAXUtil.notifyTreeException(exc);
            }
        }

        @Override
        public Object getValueAt(int row, int column) {
            TreeAttribute attr = (TreeAttribute)TreeElementAttributeListCustomizer.this.peer.get(row);
            switch (column) {
                case 0: {
                    return attr.getQName();
                }
                case 1: {
                    return attr.getValue();
                }
            }
            return null;
        }

        @Override
        public void setValueAt(Object val, int row, int column) {
            TreeAttribute attr = (TreeAttribute)TreeElementAttributeListCustomizer.this.peer.get(row);
            try {
                if (column == 0) {
                    String attrName = (String)val;
                    boolean toSet = true;
                    TreeAttribute oldAttribute = (TreeAttribute)TreeElementAttributeListCustomizer.this.peer.get((Object)new TreeName(attrName));
                    if (attr != oldAttribute && oldAttribute != null) {
                        toSet = Lib.confirmAction(Util.THIS.getString("MSG_replace_attribute", attrName));
                    }
                    if (toSet) {
                        attr.setQName(attrName);
                    }
                } else if (column == 1) {
                    attr.setValue((String)val);
                }
            }
            catch (TreeException exc) {
                TAXUtil.notifyTreeException(exc);
            }
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return Util.THIS.getString("NAME_column_name");
                }
                case 1: {
                    return Util.THIS.getString("NAME_column_value");
                }
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return true;
        }

        public void sortByColumn(int column) {
            if (this.SortedColumn == column) {
                this.ascending = !this.ascending;
            } else {
                this.SortedColumn = column;
                this.ascending = true;
            }
            this.indexes = new int[this.getRowCount()];
            for (int row = 0; row < this.getRowCount(); ++row) {
                this.indexes[row] = row;
            }
            this.n2sort(column);
            int[] indx = new int[this.indexes.length];
            for (int row = 0; row < indx.length; ++row) {
                indx[this.indexes[row]] = row;
            }
            try {
                TreeElementAttributeListCustomizer.this.peer.reorder(indx);
                this.fireTableChanged(new TableModelEvent(this));
            }
            catch (TreeException exc) {
                TAXUtil.notifyTreeException(exc);
            }
        }

        private void n2sort(int col) {
            for (int i = 0; i < this.getRowCount(); ++i) {
                for (int j = i + 1; j < this.getRowCount(); ++j) {
                    if (this.compare(this.indexes[i], this.indexes[j], col) != -1) continue;
                    int tmp = this.indexes[i];
                    this.indexes[i] = this.indexes[j];
                    this.indexes[j] = tmp;
                }
            }
        }

        private int compare(int row1, int row2, int col) {
            int result = this.compareRowsByColumn(row1, row2, col);
            if (result != 0) {
                return this.ascending ? -result : result;
            }
            return 0;
        }

        private int compareRowsByColumn(int row1, int row2, int column) {
            Class type = this.getColumnClass(column);
            Object o1 = this.getValueAt(row1, column);
            Object o2 = this.getValueAt(row2, column);
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            if (type == String.class) {
                String s2;
                String s1 = (String)this.getValueAt(row1, column);
                int result = s1.compareTo(s2 = (String)this.getValueAt(row2, column));
                if (result < 0) {
                    return -1;
                }
                if (result > 0) {
                    return 1;
                }
                return 0;
            }
            return 0;
        }
    }

    private class RowKeyListener
    extends KeyAdapter {
        private JTable table;

        public RowKeyListener(JTable table) {
            this.table = table;
        }

        @Override
        public void keyReleased(KeyEvent e) {
            if (e.getKeyCode() == 127) {
                TreeElementAttributeListCustomizer.this.tableModel.removeRow(this.table.getSelectedRow());
            }
        }
    }
}

