/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.multiview;

import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.StyledDocument;
import org.openide.ErrorManager;
import org.openide.text.NbDocument;
import org.openide.util.RequestProcessor;

public class Utils {
    private static final int WAIT_FINISHED_TIMEOUT = 10000;

    public static boolean replaceDocument(final StyledDocument doc, final String newDoc) {
        if (doc == null) {
            return true;
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    int offset;
                    int tailIndex;
                    String origDocument = Utils.filterEndLines(doc.getText(0, doc.getLength()));
                    String newDocument = Utils.filterEndLines(newDoc);
                    if (origDocument.equals(newDocument)) {
                        return;
                    }
                    char[] origChars = origDocument.toCharArray();
                    char[] newcChars = newDocument.toCharArray();
                    int delta = newcChars.length - (tailIndex = origChars.length);
                    int n = delta < 0 ? tailIndex + delta : tailIndex;
                    for (offset = 0; offset < n && origChars[offset] == newcChars[offset]; ++offset) {
                    }
                    n = delta < 0 ? offset - delta : offset;
                    int i = tailIndex - 1;
                    while (i >= n && origChars[i] == newcChars[i + delta]) {
                        tailIndex = i--;
                    }
                    String s = newDocument.substring(offset, tailIndex + delta);
                    int length = tailIndex - offset;
                    if (doc instanceof AbstractDocument) {
                        ((AbstractDocument)((Object)doc)).replace(offset, length, s, null);
                    } else {
                        if (length > 0) {
                            doc.remove(offset, length);
                        }
                        if (s.length() > 0) {
                            doc.insertString(offset, s, null);
                        }
                    }
                }
                catch (BadLocationException e) {
                    ErrorManager.getDefault().notify((Throwable)e);
                }
            }
        };
        NbDocument.runAtomic((StyledDocument)doc, (Runnable)runnable);
        return true;
    }

    private static String filterEndLines(String str) {
        char[] text = str.toCharArray();
        if (text.length == 0) {
            return "";
        }
        int pos = 0;
        for (int i = 0; i < text.length; ++i) {
            char c = text[i];
            if (c == '\r') continue;
            if (pos != i) {
                text[pos] = c;
            }
            ++pos;
        }
        return new String(text, 0, pos);
    }

    public static void focusNextComponent(Component component) {
        Container focusCycleRoot = component.getFocusCycleRootAncestor();
        if (focusCycleRoot == null) {
            return;
        }
        FocusTraversalPolicy focusTraversalPolicy = focusCycleRoot.getFocusTraversalPolicy();
        if (focusTraversalPolicy == null) {
            return;
        }
        Component componentAfter = focusTraversalPolicy.getComponentAfter(focusCycleRoot, component);
        if (componentAfter != null) {
            componentAfter.requestFocus();
        }
    }

    public static void scrollToVisible(final JComponent component) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                component.scrollRectToVisible(new Rectangle(10, component.getHeight()));
            }
        });
    }

    public static void runInAwtDispatchThread(Runnable runnable) {
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    public static void makeTextAreaLikeTextField(JTextArea ta, JTextField tf) {
        ta.setBorder(tf.getBorder());
        ta.setFocusTraversalKeys(0, tf.getFocusTraversalKeys(0));
        ta.setFocusTraversalKeys(1, tf.getFocusTraversalKeys(1));
    }

    public static void waitFinished(RequestProcessor.Task task) {
        if (task.getDelay() > 0 && !task.isFinished()) {
            try {
                task.waitFinished(10000L);
            }
            catch (InterruptedException e) {
                ErrorManager.getDefault().notify((Throwable)e);
            }
        }
    }
}

