/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.jaxb.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import org.netbeans.modules.xml.jaxb.ui.JAXBBindingInfoPnl;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class FileListPanel
extends JPanel {
    private JButton btnAdd;
    private JButton btnRemove;
    private JList listFiles;
    private JScrollPane scrlPnFiles;
    private Vector<String> origFiles = new Vector();
    private File projDir = null;

    public FileListPanel() {
        this.initComponents();
    }

    private void initComponents() {
        this.scrlPnFiles = new JScrollPane();
        this.listFiles = new JList();
        this.btnAdd = new JButton();
        this.btnRemove = new JButton();
        this.setLayout(new GridBagLayout());
        this.scrlPnFiles.setAlignmentY(0.0f);
        this.scrlPnFiles.setPreferredSize(new Dimension(350, 50));
        this.scrlPnFiles.setRequestFocusEnabled(false);
        this.listFiles.setModel(this.getFileListModel());
        this.listFiles.setPreferredSize(new Dimension(300, 75));
        this.scrlPnFiles.setViewportView(this.listFiles);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.scrlPnFiles, gridBagConstraints);
        this.scrlPnFiles.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FileListPanel.class, (String)"ASN_Files"));
        this.scrlPnFiles.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FileListPanel.class, (String)"ASD_Files"));
        Mnemonics.setLocalizedText((AbstractButton)this.btnAdd, (String)NbBundle.getMessage(FileListPanel.class, (String)"LBL_BindingFiles_Add"));
        this.btnAdd.setToolTipText(NbBundle.getMessage(FileListPanel.class, (String)"TT_BindingFilesAddBtn"));
        this.btnAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FileListPanel.this.btnPressedEvent(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 5, 10);
        this.add((Component)this.btnAdd, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.btnRemove, (String)NbBundle.getMessage(FileListPanel.class, (String)"LBL_BindinfFiles_Remove"));
        this.btnRemove.setToolTipText(NbBundle.getMessage(FileListPanel.class, (String)"TT_BindingFilesRemoveBtn"));
        this.btnRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FileListPanel.this.btnPressedEvent(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 5, 10);
        this.add((Component)this.btnRemove, gridBagConstraints);
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FileListPanel.class, (String)"ASN_FileList"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FileListPanel.class, (String)"ASD_FileList"));
    }

    private void btnPressedEvent(ActionEvent evt) {
        if (evt.getSource() == this.btnAdd) {
            String fileSelected = JAXBBindingInfoPnl.selectFileFromFileSystem(this, this.projDir, "last.browsed.schema.dir");
            DefaultListModel model = (DefaultListModel)this.listFiles.getModel();
            if (fileSelected != null && !model.contains(fileSelected)) {
                model.addElement(fileSelected);
            }
        }
        if (evt.getSource() == this.btnRemove) {
            DefaultListModel model = (DefaultListModel)this.listFiles.getModel();
            int[] selectedFileIndxs = this.listFiles.getSelectedIndices();
            while (selectedFileIndxs.length > 0) {
                model.removeElementAt(selectedFileIndxs[0]);
                selectedFileIndxs = this.listFiles.getSelectedIndices();
            }
        }
    }

    private ListModel getFileListModel() {
        DefaultListModel<String> ret = new DefaultListModel<String>();
        for (String file : this.origFiles) {
            ret.addElement(file);
        }
        return ret;
    }

    public void setFiles(List<String> fls) {
        if (fls != null) {
            this.origFiles.addAll(fls);
            this.listFiles.setModel(this.getFileListModel());
        }
    }

    public void setProjDir(File pdir) {
        this.projDir = pdir;
    }

    public List<String> getFiles() {
        Vector<String> files = new Vector<String>();
        ListModel lm = this.listFiles.getModel();
        int numFiles = lm.getSize();
        if (numFiles > 0) {
            for (int i = 0; i < numFiles; ++i) {
                files.add((String)lm.getElementAt(i));
            }
        }
        return files;
    }
}

