/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.struts.editor;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Position;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.TokenItem;
import org.netbeans.editor.ext.ExtSyntaxSupport;
import org.netbeans.modules.editor.indent.api.Indent;
import org.netbeans.modules.editor.indent.api.Reformat;
import org.netbeans.modules.schema2beans.BaseBean;
import org.netbeans.modules.web.struts.config.model.FormProperty;
import org.netbeans.modules.web.struts.config.model.Forward;
import org.netbeans.modules.web.struts.config.model.StrutsException;
import org.openide.util.Exceptions;

public class StrutsEditorUtilities {
    protected static int XML_ATTRIBUTE = 5;
    protected static int XML_ELEMENT = 4;
    protected static int XML_ATTRIBUTE_VALUE = 7;
    public static String END_LINE = System.getProperty("line.separator");

    public static String getActionPath(BaseDocument doc, int offset) {
        try {
            TokenItem token;
            ExtSyntaxSupport sup = (ExtSyntaxSupport)doc.getSyntaxSupport();
            for (token = sup.getTokenChain(offset, offset + 1); token != null && (token.getTokenID().getNumericID() != XML_ELEMENT || token.getImage().equals("/>") || token.getImage().equals(">") || token.getImage().equals("<forward") || token.getImage().equals("<exception") || token.getImage().equals("</action") || token.getImage().equals("<description") || token.getImage().equals("<display-name") || token.getImage().equals("<set-property") || token.getImage().equals("<icon")); token = token.getPrevious()) {
            }
            if (token != null && token.getImage().equals("<action")) {
                for (token = token.getNext(); !(token == null || token.getTokenID().getNumericID() == XML_ELEMENT || token.getTokenID().getNumericID() == XML_ATTRIBUTE && token.getImage().equals("path")); token = token.getNext()) {
                }
                if (token != null && token.getImage().equals("path")) {
                    for (token = token.getNext(); token != null && token.getTokenID().getNumericID() != XML_ATTRIBUTE_VALUE && token.getTokenID().getNumericID() != XML_ELEMENT && token.getTokenID().getNumericID() != XML_ATTRIBUTE; token = token.getNext()) {
                    }
                    if (token != null && token.getTokenID().getNumericID() == XML_ATTRIBUTE_VALUE) {
                        String value = token.getImage().trim();
                        value = value.substring(1);
                        value = value.substring(0, value.length() - 1);
                        return value;
                    }
                }
            }
            return null;
        }
        catch (BadLocationException e) {
            Exceptions.printStackTrace((Throwable)e);
            return null;
        }
    }

    public static String getActionFormBeanName(BaseDocument doc, int offset) {
        try {
            TokenItem token;
            ExtSyntaxSupport sup = (ExtSyntaxSupport)doc.getSyntaxSupport();
            for (token = sup.getTokenChain(offset, offset + 1); token != null && (token.getTokenID().getNumericID() != XML_ELEMENT || token.getImage().equals("/>") || token.getImage().equals(">") || token.getImage().equals("<form-property") || token.getImage().equals("</form-bean") || token.getImage().equals("<description") || token.getImage().equals("<display-name") || token.getImage().equals("<set-property") || token.getImage().equals("<icon")); token = token.getPrevious()) {
            }
            if (token != null && token.getImage().equals("<form-bean")) {
                for (token = token.getNext(); !(token == null || token.getTokenID().getNumericID() == XML_ELEMENT || token.getTokenID().getNumericID() == XML_ATTRIBUTE && token.getImage().equals("name")); token = token.getNext()) {
                }
                if (token != null && token.getImage().equals("name")) {
                    for (token = token.getNext(); token != null && token.getTokenID().getNumericID() != XML_ATTRIBUTE_VALUE && token.getTokenID().getNumericID() != XML_ELEMENT && token.getTokenID().getNumericID() != XML_ATTRIBUTE; token = token.getNext()) {
                    }
                    if (token != null && token.getTokenID().getNumericID() == XML_ATTRIBUTE_VALUE) {
                        String value = token.getImage().trim();
                        value = value.substring(1);
                        value = value.substring(0, value.length() - 1);
                        return value;
                    }
                }
            }
            return null;
        }
        catch (BadLocationException e) {
            Exceptions.printStackTrace((Throwable)e);
            return null;
        }
    }

    public static int writeForwardIntoAction(BaseDocument doc, Forward forward, String actionName) throws IOException {
        return StrutsEditorUtilities.writeElementIntoFather(doc, forward, "action", actionName, "forward");
    }

    public static int writeExceptionIntoAction(BaseDocument doc, StrutsException ex, String actionName) throws IOException {
        return StrutsEditorUtilities.writeElementIntoFather(doc, ex, "action", actionName, "exception");
    }

    public static int writePropertyIntoBean(BaseDocument doc, FormProperty prop, String beanName) throws IOException {
        return StrutsEditorUtilities.writeElementIntoFather(doc, prop, "form-bean", beanName, "form-property");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int writeElementIntoFather(BaseDocument doc, BaseBean bean, String father, String fatherName, String element) throws IOException {
        int possition;
        block22: {
            possition = -1;
            ExtSyntaxSupport sup = (ExtSyntaxSupport)doc.getSyntaxSupport();
            TokenItem token = null;
            try {
                int offset = 0;
                do {
                    if ((token = sup.getTokenChain(offset = doc.getText(0, doc.getLength()).indexOf("\"" + fatherName + "\"", offset + 1), offset + 1)) == null || token.getTokenID().getNumericID() != XML_ATTRIBUTE_VALUE) continue;
                    while (token != null && token.getTokenID().getNumericID() != XML_ELEMENT) {
                        token = token.getPrevious();
                    }
                } while (offset > 0 && token != null && (token.getTokenID().getNumericID() != XML_ELEMENT || !token.getImage().equals("<" + father)));
                if (token == null || token.getTokenID().getNumericID() != XML_ELEMENT || !token.getImage().equals("<" + father)) break block22;
                for (token = token.getNext(); token != null && token.getTokenID().getNumericID() != XML_ELEMENT; token = token.getNext()) {
                }
                if (token != null && token.getImage().equals("/>")) {
                    StringBuffer text = new StringBuffer();
                    offset = token.getOffset();
                    text.append(">");
                    text.append(END_LINE);
                    text.append(StrutsEditorUtilities.addNewLines(bean));
                    text.append(END_LINE);
                    text.append("</");
                    text.append(father);
                    text.append(">");
                    Reformat fmt = Reformat.get((Document)doc);
                    fmt.lock();
                    try {
                        doc.atomicLock();
                        try {
                            doc.remove(offset, 2);
                            doc.insertString(offset, text.toString(), null);
                            Position endPos = doc.createPosition(offset + text.length() - 1);
                            fmt.reformat(offset, endPos.getOffset());
                            offset += Math.max(0, endPos.getOffset() - offset);
                            possition = offset;
                        }
                        finally {
                            doc.atomicUnlock();
                        }
                    }
                    finally {
                        fmt.unlock();
                    }
                }
                if (token != null && token.getImage().equals(">")) {
                    offset = -1;
                    while (!(token == null || token.getTokenID().getNumericID() == XML_ELEMENT && token.getImage().equals("</" + father))) {
                        while (token != null && (token.getTokenID().getNumericID() != XML_ELEMENT || !token.getImage().equals("<" + element) && !token.getImage().equals("</" + father))) {
                            token = token.getNext();
                        }
                        if (token != null && token.getImage().equals("<" + element)) {
                            while (token != null && (token.getTokenID().getNumericID() != XML_ELEMENT || !token.getImage().equals("/>") && !token.getImage().equals("</" + element))) {
                                token = token.getNext();
                            }
                            if (token != null && token.getImage().equals("</" + element)) {
                                while (!(token == null || token.getTokenID().getNumericID() == XML_ELEMENT && token.getImage().equals(">"))) {
                                    token = token.getNext();
                                }
                            }
                            if (token != null) {
                                offset = token.getOffset() + token.getImage().length() - 1;
                            }
                        }
                        if (token == null || !token.getImage().equals("</" + father) || offset != -1) continue;
                        while (token != null && (token.getTokenID().getNumericID() != XML_ELEMENT || !token.getImage().equals("/>") && !token.getImage().equals(">"))) {
                            token = token.getPrevious();
                        }
                        offset = token.getOffset() + token.getImage().length() - 1;
                    }
                    if (offset > 0) {
                        possition = StrutsEditorUtilities.writeString(doc, StrutsEditorUtilities.addNewLines(bean), offset);
                    }
                }
            }
            catch (BadLocationException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return possition;
    }

    public static int writeBean(BaseDocument doc, BaseBean bean, String element, String section) throws IOException {
        int possition = -1;
        boolean addroot = false;
        boolean addsection = false;
        String sBean = StrutsEditorUtilities.addNewLines(bean);
        StringBuffer appendText = new StringBuffer();
        ExtSyntaxSupport sup = (ExtSyntaxSupport)doc.getSyntaxSupport();
        try {
            String docText = doc.getText(0, doc.getLength());
            String findString = "</" + element;
            int offset = docText.lastIndexOf(findString);
            if (offset == -1) {
                offset = StrutsEditorUtilities.findEndOfElement(doc, "struts-config");
                if (offset == -1) {
                    offset = doc.getLength();
                    appendText = new StringBuffer();
                    appendText.append("<struts-config>");
                    appendText.append(END_LINE);
                    if (section != null && section.length() > 0) {
                        appendText.append("<" + section + ">");
                        appendText.append(END_LINE);
                        appendText.append(sBean);
                        appendText.append(END_LINE);
                        appendText.append("</" + section + ">");
                    } else {
                        appendText.append(sBean);
                    }
                    appendText.append(END_LINE);
                    appendText.append("</struts-config>");
                    appendText.append(END_LINE);
                    possition = StrutsEditorUtilities.writeString(doc, appendText.toString(), offset);
                } else {
                    if (section != null && section.length() > 0) {
                        int offsetSection = StrutsEditorUtilities.findEndOfElement(doc, section);
                        if (offsetSection == -1) {
                            appendText.append("<" + section + ">");
                            appendText.append(END_LINE);
                            appendText.append(sBean);
                            appendText.append(END_LINE);
                            appendText.append("</" + section + ">");
                        } else {
                            appendText.append(sBean);
                            offset = offsetSection;
                        }
                    } else {
                        appendText.append(sBean);
                    }
                    TokenItem token = sup.getTokenChain(offset, offset + 1);
                    if (token != null) {
                        token = token.getPrevious();
                    }
                    while (!(token == null || token.getTokenID().getNumericID() == XML_ELEMENT && token.getImage().equals(">"))) {
                        token = token.getPrevious();
                    }
                    if (token != null) {
                        offset = token.getOffset();
                    }
                    possition = StrutsEditorUtilities.writeString(doc, appendText.toString(), offset);
                }
            } else {
                TokenItem token = sup.getTokenChain(offset, offset + 1);
                if (token != null && token.getTokenID().getNumericID() == XML_ELEMENT) {
                    while (!(token == null || token.getTokenID().getNumericID() == XML_ELEMENT && token.getImage().equals(">"))) {
                        token = token.getPrevious();
                    }
                    if (token != null) {
                        possition = StrutsEditorUtilities.writeString(doc, sBean, token.getOffset());
                    }
                }
            }
        }
        catch (BadLocationException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return possition;
    }

    private static String addNewLines(BaseBean bean) throws IOException {
        StringWriter sWriter = new StringWriter();
        bean.writeNode((Writer)sWriter);
        String sBean = sWriter.toString();
        sBean = sBean.replaceAll("><", ">" + END_LINE + "<");
        return sBean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int writeString(BaseDocument doc, String text, int offset) throws BadLocationException {
        int formatLength = 0;
        Indent indent = Indent.get((Document)doc);
        Reformat fmt = Reformat.get((Document)doc);
        indent.lock();
        try {
            fmt.lock();
            try {
                doc.atomicLock();
                try {
                    offset = indent.indentNewLine(offset + 1);
                    doc.insertString(Math.min(offset, doc.getLength()), text, null);
                    Position endPos = doc.createPosition(offset + text.length() - 1);
                    fmt.reformat(offset, endPos.getOffset());
                    formatLength = Math.max(0, endPos.getOffset() - offset);
                }
                finally {
                    doc.atomicUnlock();
                }
            }
            finally {
                fmt.unlock();
            }
        }
        finally {
            indent.unlock();
        }
        return Math.min(offset + formatLength + 1, doc.getLength());
    }

    private static int findStartOfElement(BaseDocument doc, String element) throws BadLocationException {
        String docText = doc.getText(0, doc.getLength());
        int offset = doc.getText(0, doc.getLength()).indexOf("<" + element);
        ExtSyntaxSupport sup = (ExtSyntaxSupport)doc.getSyntaxSupport();
        while (offset > 0) {
            TokenItem token = sup.getTokenChain(offset, offset + 1);
            if (token != null && token.getTokenID().getNumericID() == XML_ELEMENT) {
                return token.getOffset();
            }
            offset = doc.getText(0, doc.getLength()).indexOf("<" + element);
        }
        return -1;
    }

    private static int findEndOfElement(BaseDocument doc, String element) throws BadLocationException {
        String docText = doc.getText(0, doc.getLength());
        int offset = doc.getText(0, doc.getLength()).indexOf("</" + element);
        ExtSyntaxSupport sup = (ExtSyntaxSupport)doc.getSyntaxSupport();
        while (offset > 0) {
            TokenItem token = sup.getTokenChain(offset, offset + 1);
            if (token != null && token.getTokenID().getNumericID() == XML_ELEMENT) {
                offset = token.getOffset();
                for (token = token.getNext(); !(token == null || token.getTokenID().getNumericID() == XML_ELEMENT && token.getImage().equals(">")); token = token.getNext()) {
                }
                if (token != null) {
                    offset = token.getOffset();
                }
                return offset;
            }
            offset = doc.getText(0, doc.getLength()).indexOf("</" + element);
        }
        return -1;
    }
}

