/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.editor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import org.netbeans.modules.csl.api.CodeCompletionContext;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.html.editor.api.gsf.HtmlParserResult;
import org.netbeans.modules.html.editor.lib.api.elements.Element;
import org.netbeans.modules.html.editor.lib.api.elements.OpenTag;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.web.el.CompilationContext;
import org.netbeans.modules.web.el.ELElement;
import org.netbeans.modules.web.el.ELParserResult;
import org.netbeans.modules.web.el.ELTypeUtilities;
import org.netbeans.modules.web.el.spi.ELPlugin;
import org.netbeans.modules.web.el.spi.Function;
import org.netbeans.modules.web.el.spi.ImplicitObject;
import org.netbeans.modules.web.el.spi.ImplicitObjectType;
import org.netbeans.modules.web.el.spi.ResolverContext;
import org.netbeans.modules.web.el.spi.ResourceBundle;
import org.netbeans.modules.web.jsfapi.api.Attribute;
import org.netbeans.modules.web.jsfapi.api.JsfSupport;
import org.netbeans.modules.web.jsfapi.api.Library;
import org.netbeans.modules.web.jsfapi.api.LibraryComponent;
import org.netbeans.modules.web.jsfapi.api.Tag;
import org.netbeans.modules.web.jsfapi.spi.JsfSupportProvider;
import org.openide.filesystems.FileObject;

public class JspJsfELPlugin
extends ELPlugin {
    private static final Logger LOGGER = Logger.getLogger(JspJsfELPlugin.class.getName());
    private static final String PLUGIN_NAME = "JSP JSF EL Plugin";
    private static final String VOID_RETURN_TYPE = "void";
    private Collection<String> MIMETYPES = Arrays.asList("text/x-jsp", "text/x-tag");
    private Collection<ImplicitObject> implicitObjects;

    public String getName() {
        return PLUGIN_NAME;
    }

    public Collection<String> getMimeTypes() {
        return this.MIMETYPES;
    }

    public Collection<ImplicitObject> getImplicitObjects(FileObject file) {
        return this.MIMETYPES.contains(file.getMIMEType()) ? this.getImplicitObjects() : Collections.emptyList();
    }

    public List<ResourceBundle> getResourceBundles(FileObject file, ResolverContext context) {
        return Collections.emptyList();
    }

    public boolean isValidProperty(ExecutableElement executableElement, Source source, CodeCompletionContext completionContext, CompilationContext compilationContext) {
        String attributeName;
        if (executableElement == null || source == null || completionContext == null || compilationContext == null || executableElement.getReturnType() == null) {
            return false;
        }
        Attribute attribute = JspJsfELPlugin.getAttributeOnCaret(source, completionContext);
        if (attribute == null) {
            return false;
        }
        TypeMirror elementReturnType = executableElement.getReturnType();
        Types types = compilationContext.info().getTypes();
        String methodSignature = attribute.getMethodSignature();
        if (methodSignature == null || methodSignature.isEmpty()) {
            String attributeReturnType = attribute.getType();
            if (attributeReturnType == null) {
                return false;
            }
            TypeElement attributeReturnTypeElement = ELTypeUtilities.getElementForType((CompilationContext)compilationContext, (String)attributeReturnType);
            if (attributeReturnTypeElement == null) {
                return false;
            }
            return executableElement.getParameters().isEmpty() && (TypeKind.VOID.equals((Object)elementReturnType.getKind()) && VOID_RETURN_TYPE.equals(attributeReturnType) || types.isAssignable(elementReturnType, attributeReturnTypeElement.asType()));
        }
        int atributeNameIndex = (methodSignature = methodSignature.trim()).indexOf(attributeName = attribute.getName());
        if (atributeNameIndex == -1) {
            LOGGER.log(Level.FINE, "Attribute not found in the method signature: element={0},attribute={1}", new Object[]{executableElement.getSimpleName(), attributeName});
            return false;
        }
        String attributeReturnType = methodSignature.substring(0, atributeNameIndex).trim();
        String attributeParametersStr = methodSignature.substring(atributeNameIndex + attributeName.length()).replaceAll("[()]", "").trim();
        ArrayList<String> attributeParameters = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(attributeParametersStr, ",");
        while (tokenizer.hasMoreTokens()) {
            String parameterClass = tokenizer.nextToken();
            if (parameterClass == null) continue;
            attributeParameters.add(parameterClass);
        }
        boolean signatureEquals = true;
        List<? extends VariableElement> elementParameters = executableElement.getParameters();
        if (elementParameters == null || elementParameters.size() != attributeParameters.size()) {
            return false;
        }
        for (int i = 0; i < elementParameters.size(); ++i) {
            VariableElement variableElementParameter = elementParameters.get(i);
            String attributeParameterClass = (String)attributeParameters.get(i);
            TypeElement attributeParameterClassTypeElement = ELTypeUtilities.getElementForType((CompilationContext)compilationContext, (String)attributeParameterClass);
            if (variableElementParameter == null || variableElementParameter.asType() == null || attributeParameterClassTypeElement == null || attributeParameterClassTypeElement.asType() == null) {
                return false;
            }
            if (!types.isSameType(variableElementParameter.asType(), attributeParameterClassTypeElement.asType())) {
                signatureEquals = false;
                break;
            }
            signatureEquals = true;
        }
        if (!signatureEquals) {
            return false;
        }
        if (TypeKind.VOID.equals((Object)elementReturnType.getKind()) && VOID_RETURN_TYPE.equals(attributeReturnType)) {
            return true;
        }
        TypeElement elementForReturnType = ELTypeUtilities.getElementForType((CompilationContext)compilationContext, (String)attributeReturnType);
        return elementForReturnType != null && types.isSameType(elementReturnType, elementForReturnType.asType());
    }

    public static Attribute getAttributeOnCaret(Source source, CodeCompletionContext completionContext) {
        if (source == null || completionContext == null) {
            return null;
        }
        final ParserResult parserResult = completionContext.getParserResult();
        if (!(parserResult instanceof ELParserResult)) {
            return null;
        }
        ELParserResult elParserResult = (ELParserResult)parserResult;
        final Parser.Result[] results = new Parser.Result[1];
        try {
            ParserManager.parse(Collections.singleton(parserResult.getSnapshot().getSource()), (UserTask)new UserTask(){

                public void run(ResultIterator resultIterator) throws Exception {
                    results[0] = resultIterator.getParserResult(parserResult.getSnapshot().getOriginalOffset(0) - 2);
                }
            });
        }
        catch (ParseException ex) {
            LOGGER.log(Level.WARNING, "Error parsing Source with mimeType=" + source.getMimeType(), ex);
            return null;
        }
        Parser.Result result = results[0];
        if (!(result instanceof HtmlParserResult)) {
            return null;
        }
        HtmlParserResult htmlParserResult = (HtmlParserResult)result;
        Snapshot htmlParserSnapshot = htmlParserResult.getSnapshot();
        int caretOffset = completionContext.getCaretOffset();
        ELElement elementAtCaret = elParserResult.getElementAt(caretOffset);
        if (elementAtCaret == null) {
            return null;
        }
        int elementAtCaretOriginalOffset = elementAtCaret.getSnapshot().getOriginalOffset(elementAtCaret.getEmbeddedOffset().getStart());
        int elementAtCaretEmbeddedOffset = htmlParserSnapshot.getEmbeddedOffset(elementAtCaretOriginalOffset);
        CharSequence htmlParserResultText = htmlParserSnapshot.getText();
        Element element = htmlParserResult.findByPhysicalRange(elementAtCaretEmbeddedOffset, true);
        if (!(element instanceof OpenTag)) {
            return null;
        }
        OpenTag openTag = (OpenTag)element;
        String namespacePrefix = openTag.namespacePrefix() == null ? null : openTag.namespacePrefix().toString();
        Map namespaces = htmlParserResult.getNamespaces();
        String namespace = null;
        if (namespaces != null && namespacePrefix != null && !namespacePrefix.isEmpty()) {
            for (Map.Entry entry : namespaces.entrySet()) {
                if (!namespacePrefix.equalsIgnoreCase((String)entry.getValue())) continue;
                namespace = (String)entry.getKey();
            }
        }
        if (namespace == null) {
            LOGGER.log(Level.FINE, "JspJsfELPlugin: No namespace found for prefix: {0}", namespacePrefix);
            return null;
        }
        String textToCaret = htmlParserResultText.subSequence(0, elementAtCaretEmbeddedOffset).toString();
        int spaceLastIndex = textToCaret.lastIndexOf(" ");
        String attributeName = textToCaret.substring(spaceLastIndex).replaceAll("[^A-Za-z0-9 ]", "").trim();
        JsfSupport jsfSupport = JsfSupportProvider.get((Source)source);
        if (jsfSupport == null) {
            return null;
        }
        Library library = jsfSupport.getLibrary(namespace);
        if (library == null) {
            return null;
        }
        String tagName = openTag.unqualifiedName().toString();
        LibraryComponent component = library.getComponent(tagName);
        if (component == null) {
            LOGGER.log(Level.FINE, "JspJsfELPlugin: Library component not found for tag name: {0}", tagName);
            return null;
        }
        Tag tag = component.getTag();
        if (tag == null) {
            LOGGER.log(Level.FINE, "JspJsfELPlugin: Tag not found for component: {0}", component.getName());
            return null;
        }
        Attribute attribute = tag.getAttribute(attributeName);
        return attribute;
    }

    private synchronized Collection<ImplicitObject> getImplicitObjects() {
        if (this.implicitObjects == null) {
            this.initImplicitObjects();
        }
        return this.implicitObjects;
    }

    private synchronized void initImplicitObjects() {
        this.implicitObjects = new ArrayList<ImplicitObject>(2);
        this.implicitObjects.add(new ViewObject());
        this.implicitObjects.add(new FacesContextObject());
    }

    public List<Function> getFunctions(FileObject file) {
        return Collections.emptyList();
    }

    private static class JsfImplicitObject
    implements ImplicitObject {
        private String name;
        private String clazz;
        private ImplicitObjectType type;

        public JsfImplicitObject(String name, String clazz, ImplicitObjectType type) {
            this.name = name;
            this.clazz = clazz;
            this.type = type;
        }

        public String getName() {
            return this.name;
        }

        public ImplicitObjectType getType() {
            return this.type;
        }

        public String getClazz() {
            return this.clazz;
        }
    }

    static class ViewObject
    extends JsfImplicitObject {
        public ViewObject() {
            super("view", "javax.faces.component.UIViewRoot", ImplicitObjectType.OBJECT_TYPE);
        }
    }

    static class FacesContextObject
    extends JsfImplicitObject {
        public FacesContextObject() {
            super("facesContext", "javax.faces.context.FacesContext", ImplicitObjectType.OBJECT_TYPE);
        }
    }
}

