/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.navigation;

import java.awt.EventQueue;
import java.util.Collection;
import org.netbeans.modules.web.jsf.navigation.Page;
import org.netbeans.modules.web.jsf.navigation.PageFlowController;
import org.netbeans.modules.web.jsf.navigation.PageFlowToolbarUtilities;
import org.netbeans.modules.web.jsf.navigation.PageFlowView;
import org.netbeans.modules.web.jsf.navigation.pagecontentmodel.PageContentModelProvider;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;

public class WebFolderListener
extends FileChangeAdapter {
    private final PageFlowController pfc;
    private final FileObject webFolder;
    private final Collection<? extends PageContentModelProvider> impls = PageFlowController.getPageContentModelProviders();
    private String oldFolderName;
    private String newFolderName;

    public WebFolderListener(PageFlowController pfc) {
        this.pfc = pfc;
        this.webFolder = pfc.getWebFolder();
    }

    private boolean isKnownFileEvent(FileObject potentialChild) {
        if (FileUtil.isParentOf((FileObject)this.webFolder, (FileObject)potentialChild)) {
            if (potentialChild.isFolder()) {
                return this.pfc.isKnownFolder(potentialChild);
            }
            return this.pfc.isKnownFile(potentialChild);
        }
        return false;
    }

    public void fileDataCreated(FileEvent fe) {
        if (this.pfc.getView() == null) {
            return;
        }
        if (!this.pfc.getView().isShowing()) {
            this.pfc.setFilesDirty();
            return;
        }
        final FileObject fileObj = fe.getFile();
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                WebFolderListener.this.fileCreatedEventHandler(fileObj);
            }
        });
    }

    public void fileDeleted(FileEvent fe) {
        if (this.pfc.getView() == null) {
            return;
        }
        if (!this.pfc.getView().isShowing()) {
            this.pfc.setFilesDirty();
            return;
        }
        final FileObject fileObj = fe.getFile();
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                WebFolderListener.this.fileDeletedEventHandler(fileObj);
            }
        });
    }

    public void fileRenamed(FileRenameEvent fe) {
        if (this.pfc.getView() == null) {
            return;
        }
        if (!this.pfc.getView().isShowing()) {
            this.pfc.setFilesDirty();
            return;
        }
        final FileObject fileObj = fe.getFile();
        final FileRenameEvent event = fe;
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                WebFolderListener.this.fileRenamedEventHandler(fileObj, event.getName(), event.getExt());
            }
        });
    }

    private void fileDeletedEventHandler(FileObject fileObj) {
        PageFlowView view = this.pfc.getView();
        if (!this.pfc.removeWebFile(fileObj)) {
            return;
        }
        String pageDisplayName = Page.getFolderDisplayName(this.webFolder, fileObj);
        Page oldNode = this.pfc.getPageName2Page(pageDisplayName);
        if (oldNode != null) {
            if (this.pfc.isPageInAnyFacesConfig(oldNode.getDisplayName())) {
                this.pfc.changeToAbstractNode(oldNode, pageDisplayName);
            } else {
                view.removeNodeWithEdges(oldNode);
                this.pfc.removePageName2Page(oldNode, true);
            }
            view.validateGraph();
        }
    }

    private void fileCreatedEventHandler(FileObject fileObj) {
        PageFlowView view = this.pfc.getView();
        if (!this.isKnownFileEvent(fileObj)) {
            for (PageContentModelProvider pageContentModelProvider : this.impls) {
                String pageDisplayName;
                Page relevantPage;
                FileObject jspFileObject = pageContentModelProvider.isNewPageContentModel(fileObj);
                if (jspFileObject == null || !this.isKnownFileEvent(jspFileObject) || (relevantPage = this.pfc.getPageName2Page(pageDisplayName = Page.getFolderDisplayName(this.webFolder, jspFileObject))) == null) continue;
                relevantPage.updateContentModel();
                view.resetNodeWidget(relevantPage, true);
                view.validateGraph();
            }
            return;
        }
        try {
            if (this.pfc.isKnownFile(fileObj)) {
                this.pfc.addWebFile(fileObj);
                DataObject dataObj = DataObject.find((FileObject)fileObj);
                Node node = dataObj.getNodeDelegate();
                Page pageNode = this.pfc.getPageName2Page(Page.getFolderDisplayName(this.webFolder, fileObj));
                if (pageNode != null) {
                    pageNode.replaceWrappedNode(node);
                    view.resetNodeWidget(pageNode, false);
                    view.validateGraph();
                } else if (this.pfc.isCurrentScope(PageFlowToolbarUtilities.Scope.SCOPE_PROJECT)) {
                    Page node2 = this.pfc.createPage(node);
                    view.createNode(node2, null, null);
                    view.validateGraph();
                }
            }
        }
        catch (DataObjectNotFoundException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void fileRenamedEventHandler(FileObject fileObj, String oldName, String extName) {
        if (!this.pfc.containsWebFile(fileObj) && !this.pfc.isKnownFolder(fileObj)) {
            return;
        }
        if (fileObj.isFolder()) {
            if (oldName.equals(this.oldFolderName) && fileObj.getName().equals(this.newFolderName)) {
                return;
            }
            this.oldFolderName = oldName;
            this.newFolderName = fileObj.getName();
            this.renameFolder(fileObj, this.oldFolderName, this.newFolderName);
        } else {
            String newDisplayName = Page.getFolderDisplayName(this.webFolder, fileObj);
            String path = fileObj.getPath().replace(fileObj.getNameExt(), "");
            String oldDisplayName = Page.getFolderDisplayName(this.webFolder, path, oldName + "." + extName);
            this.renameFile(fileObj, oldDisplayName, newDisplayName);
        }
        this.pfc.getView().validateGraph();
    }

    private void renameFolder(FileObject folderObject, String oldFolderName, String newFolderName) {
        FileObject[] fileObjs;
        for (FileObject file : fileObjs = folderObject.getChildren()) {
            if (file.isFolder()) {
                this.renameFolder(file, oldFolderName, newFolderName);
                continue;
            }
            String newDisplayName = Page.getFolderDisplayName(this.webFolder, file);
            String oldDisplayName = newDisplayName.replaceFirst(newFolderName, oldFolderName);
            this.renameFile(file, oldDisplayName, newDisplayName);
        }
    }

    private void renameFile(FileObject fileObj, String oldDisplayName, String newDisplayName) {
        PageFlowView view = this.pfc.getView();
        Page oldNode = this.pfc.getPageName2Page(oldDisplayName);
        Page abstractNode = this.pfc.getPageName2Page(newDisplayName);
        if (oldNode == null && abstractNode != null) {
            Node dataNode = this.getNodeDelegate(fileObj);
            abstractNode.replaceWrappedNode(dataNode);
            view.resetNodeWidget(abstractNode, true);
            view.validateGraph();
            return;
        }
        if (oldNode != null && oldNode.isRenaming()) {
            return;
        }
        Node newNodeDelegate = this.getNodeDelegate(fileObj);
        if (this.pfc.isCurrentScope(PageFlowToolbarUtilities.Scope.SCOPE_PROJECT) && oldNode == null) {
            return;
        }
        if (abstractNode != null) {
            if (abstractNode.isDataNode()) {
                System.err.println("So Called Abstract Node: " + abstractNode);
                Thread.dumpStack();
            }
            if (this.pfc.isPageInAnyFacesConfig(oldDisplayName)) {
                this.pfc.changeToAbstractNode(oldNode, oldDisplayName);
            } else if (oldNode != null) {
                view.removeNodeWithEdges(oldNode);
                this.pfc.removePageName2Page(oldNode, true);
            }
            abstractNode.replaceWrappedNode(newNodeDelegate);
            view.resetNodeWidget(abstractNode, true);
        } else if (oldNode != null) {
            if (this.pfc.isPageInAnyFacesConfig(oldDisplayName)) {
                this.pfc.changeToAbstractNode(oldNode, oldDisplayName);
                if (this.pfc.isCurrentScope(PageFlowToolbarUtilities.Scope.SCOPE_PROJECT)) {
                    Page newNode = this.pfc.createPage(newNodeDelegate);
                    view.createNode(newNode, null, null);
                }
            } else {
                view.resetNodeWidget(oldNode, false);
            }
        }
    }

    private Node getNodeDelegate(FileObject fileObj) {
        Node newNodeDelegate = null;
        try {
            newNodeDelegate = DataObject.find((FileObject)fileObj).getNodeDelegate();
        }
        catch (DataObjectNotFoundException donfe) {
            Exceptions.printStackTrace((Throwable)donfe);
        }
        return newNodeDelegate;
    }
}

