/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.indent.api.support;

import java.util.ArrayList;
import java.util.List;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.web.indent.api.support.AbstractIndenter;

public final class IndenterFormattingContext {
    private boolean firstIndenter = false;
    private boolean lastIndenter = false;
    private boolean initialized = false;
    private BaseDocument doc;
    private DocumentListener listener;
    private List<Change> changes;
    private List<List<AbstractIndenter.Line>> indentedLines;
    private IndenterFormattingContext delegate;

    public IndenterFormattingContext(BaseDocument doc) {
        this.doc = doc;
    }

    void initFirstIndenter() {
        assert (!this.initialized);
        if (this.isInitialized()) {
            return;
        }
        this.firstIndenter = true;
        this.initialized = true;
        this.changes = new ArrayList<Change>();
        this.listener = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                IndenterFormattingContext.this.changes.add(new Change(e.getOffset(), e.getLength()));
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                IndenterFormattingContext.this.changes.add(new Change(e.getOffset(), -e.getLength()));
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        };
        this.doc.addDocumentListener(this.listener);
        this.indentedLines = new ArrayList<List<AbstractIndenter.Line>>();
    }

    void setDelegate(IndenterFormattingContext delegate) {
        assert (!this.initialized);
        assert (delegate.isFirstIndenter());
        this.initialized = true;
        this.delegate = delegate;
    }

    List<Change> getAndClearChanges() {
        if (this.delegate != null) {
            return this.delegate.getAndClearChanges();
        }
        ArrayList<Change> result = new ArrayList<Change>(this.changes);
        this.changes.clear();
        return result;
    }

    public boolean isFirstIndenter() {
        return this.firstIndenter;
    }

    void setLastIndenter() {
        this.lastIndenter = true;
    }

    public boolean isLastIndenter() {
        return this.lastIndenter;
    }

    boolean isInitialized() {
        return this.initialized;
    }

    void disableListener() {
        if (this.delegate != null) {
            this.delegate.disableListener();
            return;
        }
        assert (this.listener != null);
        this.doc.removeDocumentListener(this.listener);
    }

    void enableListener() {
        if (this.delegate != null) {
            this.delegate.enableListener();
            return;
        }
        assert (this.listener != null);
        this.doc.addDocumentListener(this.listener);
    }

    void removeListener() {
        if (this.delegate != null) {
            this.delegate.removeListener();
            this.initialized = false;
            return;
        }
        assert (this.listener != null);
        this.doc.removeDocumentListener(this.listener);
        this.initialized = false;
        this.listener = null;
    }

    List<List<AbstractIndenter.Line>> getIndentationData() {
        if (this.delegate != null) {
            return this.delegate.getIndentationData();
        }
        return this.indentedLines;
    }

    static class Change {
        public int offset;
        public int change;

        public Change(int offset, int change) {
            this.offset = offset;
            this.change = change;
        }

        public String toString() {
            return "Change[" + this.offset + ":" + this.change + "]";
        }
    }
}

