/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.el.completion;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.swing.ImageIcon;
import org.netbeans.api.editor.completion.Completion;
import org.netbeans.modules.csl.api.Documentation;
import org.netbeans.modules.csl.api.ElementHandle;
import org.netbeans.modules.csl.api.ElementKind;
import org.netbeans.modules.csl.api.HtmlFormatter;
import org.netbeans.modules.csl.api.Modifier;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.spi.DefaultCompletionProposal;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.web.el.ResourceBundles;
import org.netbeans.modules.web.el.completion.ELElementHandle;
import org.netbeans.modules.web.el.spi.ResourceBundle;
import org.openide.filesystems.FileObject;
import org.openide.util.ImageUtilities;

final class ELResourceBundleCompletionItem
extends DefaultCompletionProposal {
    private static final String ICON_PATH = "org/netbeans/modules/web/el/completion/resources/propertiesLocale.gif";
    private static ScheduledExecutorService service = Executors.newSingleThreadScheduledExecutor();
    private final ResourceBundle bundle;
    private final ResourceBundles bundles;
    private final FileObject file;

    public ELResourceBundleCompletionItem(FileObject file, ResourceBundle bundle, ResourceBundles bundles) {
        this.bundle = bundle;
        this.bundles = bundles;
        this.file = file;
    }

    public String getName() {
        return this.bundle.getVar();
    }

    public String getRhsHtml(HtmlFormatter formatter) {
        return this.bundle.getBaseName();
    }

    public ElementKind getKind() {
        return ElementKind.OTHER;
    }

    public int getSortPrioOverride() {
        return 20;
    }

    public ElementHandle getElement() {
        return new ResourceBundleElementHandle();
    }

    public ImageIcon getIcon() {
        return ImageUtilities.loadImageIcon((String)ICON_PATH, (boolean)false);
    }

    public String getCustomInsertTemplate() {
        StringBuilder result = new StringBuilder();
        result.append(this.getInsertPrefix()).append(".").append("${cursor}");
        ELResourceBundleCompletionItem.scheduleShowingCompletion();
        return result.toString();
    }

    private static void scheduleShowingCompletion() {
        service.schedule(new Runnable(){

            @Override
            public void run() {
                Completion.get().showCompletion();
            }
        }, 250L, TimeUnit.MILLISECONDS);
    }

    private class ResourceBundleElementHandle
    extends ELElementHandle {
        private ResourceBundleElementHandle() {
        }

        @Override
        Documentation document(ParserResult info, Callable<Boolean> cancel) {
            StringBuilder buf = new StringBuilder();
            Map<String, String> entries = ELResourceBundleCompletionItem.this.bundles.getEntries(ELResourceBundleCompletionItem.this.bundle.getVar());
            for (Map.Entry<String, String> entry : entries.entrySet()) {
                buf.append(entry.getKey());
                buf.append('=');
                buf.append("<font color='#ce7b00'>");
                buf.append(entry.getValue());
                buf.append("</font>");
                buf.append("<br>");
            }
            return Documentation.create((String)buf.toString());
        }

        public FileObject getFileObject() {
            List<FileObject> files = ELResourceBundleCompletionItem.this.bundle.getFiles();
            if (!files.isEmpty()) {
                return files.get(0);
            }
            return ELResourceBundleCompletionItem.this.file;
        }

        public String getMimeType() {
            return null;
        }

        public String getName() {
            return ELResourceBundleCompletionItem.this.getName();
        }

        public String getIn() {
            return null;
        }

        public ElementKind getKind() {
            return ElementKind.OTHER;
        }

        public Set<Modifier> getModifiers() {
            return Collections.emptySet();
        }

        public boolean signatureEquals(ElementHandle handle) {
            return false;
        }

        public OffsetRange getOffsetRange(ParserResult result) {
            return OffsetRange.NONE;
        }
    }
}

