/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.debug.breakpoints;

import org.netbeans.api.debugger.Properties;
import org.netbeans.modules.web.debug.breakpoints.JspLineBreakpoint;

public class JspBreakpointsReader
implements Properties.Reader {
    public String[] getSupportedClassNames() {
        return new String[]{JspLineBreakpoint.class.getName()};
    }

    public Object read(String typeID, Properties properties) {
        JspLineBreakpoint b = null;
        if (typeID.equals(JspLineBreakpoint.class.getName())) {
            String url = properties.getString("url", null);
            if (url == null || url.trim().length() == 0) {
                return null;
            }
            b = JspLineBreakpoint.create(url, properties.getInt("lineNumber", 1));
            b.setCondition(properties.getString("condition", ""));
            b.setPrintText(properties.getString("printText", ""));
            b.setGroupName(properties.getString("groupName", ""));
            b.setSuspend(properties.getInt("suspend", 2));
            if (properties.getBoolean("enabled", true)) {
                b.enable();
            } else {
                b.disable();
            }
        }
        return b;
    }

    public void write(Object object, Properties properties) {
        if (object instanceof JspLineBreakpoint) {
            JspLineBreakpoint b = (JspLineBreakpoint)((Object)object);
            properties.setString("printText", b.getPrintText());
            properties.setString("groupName", b.getGroupName());
            properties.setInt("suspend", b.getSuspend());
            properties.setBoolean("enabled", b.isEnabled());
            properties.setString("url", b.getURL());
            properties.setInt("lineNumber", b.getLineNumber());
            properties.setString("condition", b.getCondition());
        }
    }
}

