/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.clientproject.remotefiles;

import java.awt.EventQueue;
import java.awt.Image;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.actions.Openable;
import org.netbeans.api.project.Project;
import org.netbeans.modules.web.clientproject.remotefiles.Bundle;
import org.netbeans.modules.web.clientproject.remotefiles.RemoteFiles;
import org.netbeans.modules.web.common.api.RemoteFileCache;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.RequestProcessor;
import org.openide.util.lookup.Lookups;

public class RemoteFilesNode
extends AbstractNode {
    private final Project project;

    public RemoteFilesNode(Project project, RemoteFiles remoteFiles) {
        super((Children)new RemoteFilesChildren(project, remoteFiles), Lookups.singleton((Object)project));
        this.project = project;
    }

    public Image getIcon(int type) {
        return ImageUtilities.loadImage((String)"org/netbeans/modules/web/clientproject/remotefiles/remotefiles.png");
    }

    public Image getOpenedIcon(int type) {
        return this.getIcon(type);
    }

    public String getDisplayName() {
        return Bundle.LBL_RemoteFiles();
    }

    private static final class RemoteFileOpenable
    implements Openable {
        private static final Logger LOGGER = Logger.getLogger(RemoteFileOpenable.class.getName());
        private static final RequestProcessor RP = new RequestProcessor(RemoteFileOpenable.class);
        private final RemoteFile remoteFile;

        public RemoteFileOpenable(RemoteFile remoteFile) {
            assert (remoteFile != null);
            this.remoteFile = remoteFile;
        }

        public void open() {
            RP.post(new Runnable(){

                @Override
                public void run() {
                    this.openInBackground();
                }
            });
        }

        void openInBackground() {
            assert (!EventQueue.isDispatchThread());
            try {
                FileObject fileObject = RemoteFileCache.getRemoteFile((URL)this.remoteFile.getUrl());
                assert (fileObject != null);
                DataObject dataObject = DataObject.find((FileObject)fileObject);
                EditorCookie editorCookie = (EditorCookie)dataObject.getLookup().lookup(EditorCookie.class);
                editorCookie.open();
            }
            catch (IOException ex) {
                LOGGER.log(Level.WARNING, null, ex);
            }
        }
    }

    public static class RemoteFile {
        private final URL url;
        private final String name;
        private final String urlAsString;

        public RemoteFile(URL url) {
            this.url = url;
            this.urlAsString = url.toExternalForm();
            int index = this.urlAsString.lastIndexOf(47);
            this.name = index != -1 ? this.urlAsString.substring(index + 1) : null;
        }

        public URL getUrl() {
            return this.url;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.urlAsString;
        }

        public int hashCode() {
            int hash = 3;
            hash = 67 * hash + (this.urlAsString != null ? this.urlAsString.hashCode() : 0);
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            RemoteFile other = (RemoteFile)obj;
            return !(this.urlAsString == null ? other.urlAsString != null : !this.urlAsString.equals(other.urlAsString));
        }
    }

    private static class RemoteFileFilterNode
    extends FilterNode {
        private final String desc;
        private final Node delegate;

        public RemoteFileFilterNode(Node original, RemoteFile remoteFile, Project p) {
            super(original, null, Lookups.fixed((Object[])new Object[]{p, new RemoteFileOpenable(remoteFile)}));
            this.desc = remoteFile.getDescription();
            this.delegate = original;
        }

        public String getShortDescription() {
            return this.desc;
        }

        public int hashCode() {
            int hash = 7;
            return hash * this.delegate.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            RemoteFileFilterNode other = (RemoteFileFilterNode)((Object)obj);
            return this.delegate == other.delegate || this.delegate != null && this.delegate.equals((Object)other.delegate);
        }

        public Action getPreferredAction() {
            Action firstAction;
            Action[] actions = super.getActions(false);
            if (actions.length > 0 && (firstAction = actions[0]) != null) {
                return firstAction;
            }
            return super.getPreferredAction();
        }
    }

    private static class RemoteFilesChildren
    extends Children.Keys<RemoteFile>
    implements ChangeListener {
        private final Project project;
        private final RemoteFiles remoteFiles;

        public RemoteFilesChildren(Project project, RemoteFiles remoteFiles) {
            this.project = project;
            this.remoteFiles = remoteFiles;
        }

        protected Node[] createNodes(RemoteFile key) {
            try {
                FileObject fo = RemoteFileCache.getRemoteFile((URL)key.getUrl());
                DataObject dobj = DataObject.find((FileObject)fo);
                return new Node[]{new RemoteFileFilterNode(dobj.getNodeDelegate().cloneNode(), key, this.project)};
            }
            catch (DataObjectNotFoundException ex) {
                return new Node[0];
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                return new Node[0];
            }
        }

        protected void addNotify() {
            super.addNotify();
            this.remoteFiles.addChangeListener(this);
            this.updateKeys();
        }

        protected void removeNotify() {
            super.removeNotify();
            this.remoteFiles.removeChangeListener(this);
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.updateKeys();
        }

        private void updateKeys() {
            ArrayList<RemoteFile> keys = new ArrayList<RemoteFile>();
            for (URL u : this.remoteFiles.getRemoteFiles()) {
                keys.add(new RemoteFile(u));
            }
            Collections.sort(keys, new Comparator<RemoteFile>(){

                @Override
                public int compare(RemoteFile o1, RemoteFile o2) {
                    String name1 = o1.getName().toLowerCase();
                    String name2 = o2.getName().toLowerCase();
                    boolean isJs1 = name1.endsWith(".js");
                    boolean isJs2 = name2.endsWith(".js");
                    if (isJs1 && !isJs2) {
                        return -1;
                    }
                    if (!isJs1 && isJs2) {
                        return 1;
                    }
                    return name1.compareTo(name2);
                }
            });
            this.setKeys(keys);
        }
    }
}

