/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tomcat5.util;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.security.AccessController;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.extexecution.input.InputProcessor;
import org.netbeans.api.extexecution.input.InputProcessors;
import org.netbeans.api.extexecution.input.InputReader;
import org.netbeans.api.extexecution.input.InputReaderTask;
import org.netbeans.api.extexecution.input.InputReaders;
import org.netbeans.api.extexecution.input.LineProcessor;
import org.netbeans.api.java.classpath.GlobalPathRegistry;
import org.netbeans.modules.j2ee.deployment.plugins.api.UISupport;
import org.netbeans.modules.tomcat5.deploy.TomcatManager;
import org.netbeans.modules.tomcat5.util.LogSupport;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputListener;
import org.openide.windows.OutputWriter;

class ServerLog {
    private final InputOutput io;
    private final OutputWriter writer;
    private final OutputWriter errorWriter;
    private final InputReaderTask inReader;
    private final InputReaderTask errReader;
    private final boolean autoFlush;
    private final boolean takeFocus;
    private final ServerLogSupport logSupport;
    private final TomcatManager tomcatManager;
    private final AtomicInteger runningTasks = new AtomicInteger(2);
    private ExecutorService service;

    public ServerLog(TomcatManager tomcatManager, String displayName, Reader in, Reader err, boolean autoFlush, boolean takeFocus) {
        this.inReader = InputReaderTask.newDrainingTask((InputReader)InputReaders.forReader((Reader)in), (InputProcessor)InputProcessors.bridge((LineProcessor)new AnalyzingLineProcessor()));
        this.errReader = InputReaderTask.newDrainingTask((InputReader)InputReaders.forReader((Reader)err), (InputProcessor)InputProcessors.bridge((LineProcessor)new AnalyzingLineProcessor()));
        this.autoFlush = autoFlush;
        this.takeFocus = takeFocus;
        this.tomcatManager = tomcatManager;
        this.io = UISupport.getServerIO((String)tomcatManager.getUri());
        try {
            this.io.getOut().reset();
        }
        catch (IOException e) {
            Logger.getLogger(ServerLog.class.getName()).log(Level.INFO, null, e);
        }
        this.writer = this.io.getOut();
        this.errorWriter = this.io.getErr();
        this.io.select();
        this.logSupport = new ServerLogSupport();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        ServerLog serverLog = this;
        synchronized (serverLog) {
            this.service = Executors.newFixedThreadPool(2);
            this.service.submit((Runnable)this.inReader);
            this.service.submit((Runnable)this.errReader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRunning() {
        ServerLog serverLog = this;
        synchronized (serverLog) {
            return !this.service.isShutdown();
        }
    }

    public void takeFocus() {
        this.io.select();
    }

    public void stop() {
        AccessController.doPrivileged(() -> {
            ServerLog serverLog = this;
            synchronized (serverLog) {
                this.service.shutdownNow();
            }
            return null;
        });
    }

    static class ServerLogSupport
    extends LogSupport {
        private String prevMessage;
        private GlobalPathRegistry globalPathRegistry = GlobalPathRegistry.getDefault();

        ServerLogSupport() {
        }

        public LogSupport.LineInfo analyzeLine(String logLine) {
            String path = null;
            int line = -1;
            String message = null;
            boolean error = false;
            boolean accessible = false;
            logLine = logLine.trim();
            int lineLenght = logLine.length();
            if (logLine.startsWith("/")) {
                error = true;
                int colonIdx = logLine.indexOf(":");
                if (colonIdx > -1) {
                    int nextColonIdx;
                    path = logLine.substring(0, colonIdx);
                    accessible = true;
                    if (lineLenght > colonIdx && (nextColonIdx = logLine.indexOf(":", colonIdx + 1)) > -1) {
                        String lineNum = logLine.substring(colonIdx + 1, nextColonIdx);
                        try {
                            line = Integer.valueOf(lineNum);
                        }
                        catch (NumberFormatException nfe) {
                            Logger.getLogger(ServerLog.class.getName()).log(Level.INFO, null, nfe);
                        }
                        if (lineLenght > nextColonIdx) {
                            message = logLine.substring(nextColonIdx + 1, lineLenght);
                        }
                    }
                }
            } else if (lineLenght > 3 && Character.isLetter(logLine.charAt(0)) && logLine.charAt(1) == ':' && logLine.charAt(2) == '\\') {
                error = true;
                int secondColonIdx = logLine.indexOf(":", 2);
                if (secondColonIdx > -1) {
                    int thirdColonIdx;
                    path = logLine.substring(0, secondColonIdx);
                    accessible = true;
                    if (lineLenght > secondColonIdx && (thirdColonIdx = logLine.indexOf(":", secondColonIdx + 1)) > -1) {
                        String lineNum = logLine.substring(secondColonIdx + 1, thirdColonIdx);
                        try {
                            line = Integer.valueOf(lineNum);
                        }
                        catch (NumberFormatException nfe) {
                            Logger.getLogger(ServerLog.class.getName()).log(Level.INFO, null, nfe);
                        }
                        if (lineLenght > thirdColonIdx) {
                            message = logLine.substring(thirdColonIdx + 1, lineLenght);
                        }
                    }
                }
            } else if (logLine.startsWith("at ") && lineLenght > 3) {
                String classWithMethod;
                int lastDotIdx;
                error = true;
                int parenthIdx = logLine.indexOf("(");
                if (parenthIdx > -1 && (lastDotIdx = (classWithMethod = logLine.substring(3, parenthIdx)).lastIndexOf(".")) > -1) {
                    int firstDolarIdx;
                    int lastColonIdx;
                    int lastParenthIdx = logLine.lastIndexOf(")");
                    String content = null;
                    if (lastParenthIdx > -1) {
                        content = logLine.substring(parenthIdx + 1, lastParenthIdx);
                    }
                    if (content != null && (lastColonIdx = content.lastIndexOf(":")) > -1) {
                        String lineNum = content.substring(lastColonIdx + 1);
                        try {
                            line = Integer.valueOf(lineNum);
                        }
                        catch (NumberFormatException nfe) {
                            Logger.getLogger(ServerLog.class.getName()).log(Level.INFO, null, nfe);
                        }
                        message = this.prevMessage;
                    }
                    String className = classWithMethod.substring(0, (firstDolarIdx = classWithMethod.indexOf("$")) > -1 ? firstDolarIdx : lastDotIdx);
                    path = className.replace('.', '/') + ".java";
                    accessible = this.globalPathRegistry.findResource(path) != null;
                }
            } else {
                this.prevMessage = logLine;
            }
            return new LogSupport.LineInfo(path, line, message, error, accessible);
        }
    }

    private class AnalyzingLineProcessor
    implements LineProcessor {
        private AnalyzingLineProcessor() {
        }

        public void processLine(String line) {
            LogSupport.LineInfo lineInfo = ServerLog.this.logSupport.analyzeLine(line);
            if (lineInfo.isError()) {
                if (lineInfo.isAccessible()) {
                    try {
                        ServerLog.this.errorWriter.println(line, (OutputListener)ServerLog.this.logSupport.getLink(lineInfo.message(), lineInfo.path(), lineInfo.line()));
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                } else {
                    ServerLog.this.errorWriter.println(line);
                }
            } else {
                ServerLog.this.writer.println(line);
                if (line.startsWith("SEVERE: WSSERVLET11: failed to parse runtime descriptor: java.lang.LinkageError:")) {
                    File jaxwsApi = InstalledFileLocator.getDefault().locate("modules/ext/jaxws22/api/jakarta.xml.ws-api.jar", null, false);
                    File jaxbApi = InstalledFileLocator.getDefault().locate("modules/ext/jaxb/api/jaxb-api.jar", null, false);
                    File endoresedDir = ServerLog.this.tomcatManager.getTomcatProperties().getJavaEndorsedDir();
                    if (jaxwsApi != null && jaxbApi != null) {
                        ServerLog.this.writer.println(NbBundle.getMessage(ServerLog.class, (String)"MSG_WSSERVLET11", (Object)jaxwsApi.getParent(), (Object)jaxbApi.getParent(), (Object)endoresedDir));
                    } else {
                        ServerLog.this.writer.println(NbBundle.getMessage(ServerLog.class, (String)"MSG_WSSERVLET11_NOJAR", (Object)endoresedDir));
                    }
                }
            }
            if (ServerLog.this.autoFlush) {
                ServerLog.this.writer.flush();
                ServerLog.this.errorWriter.flush();
            }
            if (ServerLog.this.takeFocus) {
                ServerLog.this.io.select();
            }
        }

        public void close() {
            int running = ServerLog.this.runningTasks.decrementAndGet();
            if (running == 0) {
                ServerLog.this.logSupport.detachAnnotation();
                ServerLog.this.writer.close();
                ServerLog.this.errorWriter.close();
            }
        }

        public void reset() {
        }
    }
}

