/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tomcat5.optional;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.Format;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.enterprise.deploy.shared.ActionType;
import javax.enterprise.deploy.shared.CommandType;
import javax.enterprise.deploy.shared.StateType;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.exceptions.OperationUnsupportedException;
import javax.enterprise.deploy.spi.status.ClientConfiguration;
import javax.enterprise.deploy.spi.status.DeploymentStatus;
import javax.enterprise.deploy.spi.status.ProgressListener;
import javax.enterprise.deploy.spi.status.ProgressObject;
import org.netbeans.api.extexecution.startup.StartupExtender;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.modules.j2ee.deployment.plugins.api.CommonServerBridge;
import org.netbeans.modules.j2ee.deployment.plugins.api.ServerDebugInfo;
import org.netbeans.modules.j2ee.deployment.plugins.spi.StartServer;
import org.netbeans.modules.j2ee.deployment.profiler.api.ProfilerSupport;
import org.netbeans.modules.tomcat5.deploy.TomcatManager;
import org.netbeans.modules.tomcat5.optional.DebugSupport;
import org.netbeans.modules.tomcat5.optional.MonitorSupport;
import org.netbeans.modules.tomcat5.progress.ProgressEventSupport;
import org.netbeans.modules.tomcat5.progress.Status;
import org.netbeans.modules.tomcat5.util.LogManager;
import org.netbeans.modules.tomcat5.util.TomcatProperties;
import org.netbeans.modules.tomcat5.util.Utils;
import org.openide.execution.NbProcessDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.EditableProperties;
import org.openide.util.Lookup;
import org.openide.util.MapFormat;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.lookup.Lookups;
import org.xml.sax.SAXException;

public final class StartTomcat
extends StartServer
implements ProgressObject {
    public static final String CATALINA_BAT = "catalina.bat";
    public static final String CATALINA_SH = "catalina.sh";
    public static final String CATALINA_50_BAT = "catalina.50.bat";
    public static final String CATALINA_50_SH = "catalina.50.sh";
    public static final String SETCLASSPATH_BAT = "setclasspath.bat";
    public static final String SETCLASSPATH_SH = "setclasspath.sh";
    public static final String TAG_CATALINA_HOME = "catalina_home";
    public static final String TAG_CATALINA_BASE = "catalina_base";
    public static final String TAG_JPDA = "jpda";
    public static final String TAG_JPDA_STARTUP = "jpda_startup";
    public static final String TAG_EXEC_CMD = "catalina";
    public static final String TAG_EXEC_STARTUP = "exec_startup";
    public static final String TAG_EXEC_SHUTDOWN = "exec_shutdown";
    public static final String TAG_SECURITY_OPT = "security_option";
    public static final String TAG_FORCE_OPT = "force_option";
    public static final String TAG_DEBUG_CMD = "catalina";
    private static final RequestProcessor SERVER_CONTROL_RP = new RequestProcessor("Tomcat Control", 5);
    private static final RequestProcessor SERVER_STREAMS_RP = new RequestProcessor("Tomcat Streams", 10);
    private static final int MODE_RUN = 0;
    private static final int MODE_DEBUG = 1;
    private static final int MODE_PROFILE = 2;
    private static final long TIMEOUT_DELAY = 180000L;
    private static final Pattern WINDOWS_ESCAPED_JAVA_OPTS = Pattern.compile("^set\\s\"JAVA_OPTS.*$");
    private static final Logger LOGGER = Logger.getLogger(StartTomcat.class.getName());
    private TomcatManager tm;
    private boolean javaOptsEscaped;
    private Date lastCheckedStart;
    private ProgressEventSupport pes;
    private int currentServerPort;
    private static Map isDebugModeUri = Collections.synchronizedMap(new HashMap(2, 1.0f));

    public StartTomcat(DeploymentManager manager) {
        assert (manager instanceof TomcatManager) : "Illegal DeploymentManager instance: " + manager.getClass().getName();
        this.tm = (TomcatManager)manager;
        this.tm.setStartTomcat(this);
        this.pes = new ProgressEventSupport((Object)this);
        this.currentServerPort = this.tm.getServerPort();
    }

    public boolean supportsStartDeploymentManager() {
        return true;
    }

    public boolean supportsStartProfiling(Target target) {
        return true;
    }

    public ProgressObject startDeploymentManager() {
        LOGGER.log(Level.FINE, "StartTomcat.startDeploymentManager called on " + this.tm);
        this.pes.fireHandleProgressEvent(null, new Status(ActionType.EXECUTE, CommandType.START, "", StateType.RUNNING));
        SERVER_CONTROL_RP.post((Runnable)new StartRunnable(0, CommandType.START), 0, 5);
        isDebugModeUri.remove(this.tm.getUri());
        return this;
    }

    public boolean isAlsoTargetServer(Target target) {
        return true;
    }

    public boolean needsStartForConfigure() {
        return false;
    }

    public boolean needsStartForTargetList() {
        return false;
    }

    public boolean needsStartForAdminConfig() {
        return false;
    }

    public boolean needsRestart(Target target) {
        return this.tm.getNeedsRestart();
    }

    public boolean isRunning() {
        return this.tm.isRunning(true);
    }

    public boolean isDebuggable(Target target) {
        if (!isDebugModeUri.containsKey(this.tm.getUri())) {
            return false;
        }
        if (!this.isRunning()) {
            isDebugModeUri.remove(this.tm.getUri());
            return false;
        }
        return true;
    }

    public ProgressObject stopDeploymentManager() {
        LOGGER.log(Level.FINE, "StartTomcat.stopDeploymentManager called on " + this.tm);
        this.pes.fireHandleProgressEvent(null, new Status(ActionType.EXECUTE, CommandType.STOP, "", StateType.RUNNING));
        SERVER_CONTROL_RP.post((Runnable)new StartRunnable(0, CommandType.STOP), 0, 5);
        isDebugModeUri.remove(this.tm.getUri());
        return this;
    }

    public ProgressObject startDebugging(Target target) {
        LOGGER.log(Level.FINE, "StartTomcat.startDebugging called on " + this.tm);
        this.pes.fireHandleProgressEvent(null, new Status(ActionType.EXECUTE, CommandType.START, "", StateType.RUNNING));
        SERVER_CONTROL_RP.post((Runnable)new StartRunnable(1, CommandType.START), 0, 5);
        return this;
    }

    public ProgressObject startProfiling(Target target) {
        LOGGER.log(Level.FINE, "StartTomcat.startProfiling called on " + this.tm);
        this.pes.fireHandleProgressEvent(null, new Status(ActionType.EXECUTE, CommandType.START, "", StateType.RUNNING));
        SERVER_CONTROL_RP.post((Runnable)new StartRunnable(2, CommandType.START), 0, 5);
        return this;
    }

    public ServerDebugInfo getDebugInfo(Target target) {
        TomcatProperties tp = this.tm.getTomcatProperties();
        ServerDebugInfo sdi = tp.getDebugType().toLowerCase().indexOf("socket") != -1 ? new ServerDebugInfo("localhost", tp.getDebugPort()) : new ServerDebugInfo("localhost", tp.getSharedMem());
        return sdi;
    }

    private boolean isStopped() {
        Process proc = this.tm.getTomcatProcess();
        if (proc != null) {
            try {
                proc.exitValue();
                return true;
            }
            catch (IllegalThreadStateException e) {
                return false;
            }
        }
        int timeout = this.tm.getTomcatProperties().getRunningCheckTimeout();
        return !Utils.pingTomcat(this.tm.getServerPort(), timeout, this.tm.getServerHeader(), this.tm.getPlainUri());
    }

    public ProgressObject startServer(Target target) {
        return null;
    }

    public boolean supportsStartDebugging(Target target) {
        return true;
    }

    public ClientConfiguration getClientConfiguration(TargetModuleID targetModuleID) {
        return null;
    }

    public DeploymentStatus getDeploymentStatus() {
        return this.pes.getDeploymentStatus();
    }

    public TargetModuleID[] getResultTargetModuleIDs() {
        return new TargetModuleID[0];
    }

    public boolean isCancelSupported() {
        return false;
    }

    public void cancel() throws OperationUnsupportedException {
        throw new OperationUnsupportedException("");
    }

    public boolean isStopSupported() {
        return false;
    }

    public void stop() throws OperationUnsupportedException {
        throw new OperationUnsupportedException("");
    }

    public void addProgressListener(ProgressListener pl) {
        this.pes.addProgressListener(pl);
    }

    public void removeProgressListener(ProgressListener pl) {
        this.pes.removeProgressListener(pl);
    }

    public String toString() {
        return "StartTomcat [" + this.tm + "]";
    }

    public int getCurrentServerPort() {
        return this.currentServerPort;
    }

    private static NbProcessDescriptor defaultExecDesc(String command, String argCommand, String option) {
        return new NbProcessDescriptor("{" + command + "}", "{" + argCommand + "} {" + option + "}", NbBundle.getMessage(StartTomcat.class, (String)"MSG_TomcatExecutionCommand"));
    }

    private static NbProcessDescriptor defaultExecDesc(String command, String argCommand) {
        return new NbProcessDescriptor("{" + command + "}", "{" + argCommand + "}", NbBundle.getMessage(StartTomcat.class, (String)"MSG_TomcatExecutionCommand"));
    }

    private static NbProcessDescriptor defaultDebugStartDesc(String command, String jpdaCommand, String option) {
        return new NbProcessDescriptor("{" + command + "}", "{jpda} {" + jpdaCommand + "} {" + option + "}", NbBundle.getMessage(StartTomcat.class, (String)"MSG_TomcatExecutionCommand"));
    }

    private static NbProcessDescriptor defaultDebugStartDesc(String command, String jpdaCommand) {
        return new NbProcessDescriptor("{" + command + "}", "{jpda} {" + jpdaCommand + "}", NbBundle.getMessage(StartTomcat.class, (String)"MSG_TomcatExecutionCommand"));
    }

    private String getJavaHome(JavaPlatform platform) {
        FileObject fo = (FileObject)platform.getInstallFolders().iterator().next();
        return FileUtil.toFile((FileObject)fo).getAbsolutePath();
    }

    private File getStartupScript() {
        TomcatProperties tp = this.tm.getTomcatProperties();
        if (tp.getCustomScript()) {
            return new File(tp.getScriptPath());
        }
        String startupScript = Utilities.isWindows() ? CATALINA_BAT : CATALINA_SH;
        return new File(tp.getCatalinaHome(), "/bin/" + startupScript);
    }

    private JavaPlatform getJavaPlatform() {
        JavaPlatform platform = this.tm.getTomcatProperties().getJavaPlatform();
        if (platform.getInstallFolders().size() <= 0) {
            LOGGER.log(Level.INFO, "The Java Platform used by Tomcat is broken; using the default one");
            return JavaPlatform.getDefault();
        }
        return platform;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isJavaOptsEscaped() {
        if (Utilities.isUnix()) {
            return false;
        }
        FileObject start = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)this.getStartupScript()));
        if (start == null) {
            return false;
        }
        StartTomcat startTomcat = this;
        synchronized (startTomcat) {
            if (this.lastCheckedStart != null && !start.lastModified().after(this.lastCheckedStart)) {
                return this.javaOptsEscaped;
            }
            this.javaOptsEscaped = false;
            this.lastCheckedStart = start.lastModified();
            try {
                for (String line : start.asLines("UTF-8")) {
                    if (!WINDOWS_ESCAPED_JAVA_OPTS.matcher(line).matches()) continue;
                    this.javaOptsEscaped = true;
                    break;
                }
            }
            catch (IOException ex) {
                LOGGER.log(Level.INFO, null, ex);
            }
            return this.javaOptsEscaped;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void patchCatalinaProperties(File catalinaBase, boolean endorsedEnabled) {
        File catalinaProp = new File(catalinaBase, "conf/catalina.properties");
        if (!catalinaProp.exists()) {
            return;
        }
        EditableProperties props = new EditableProperties(false);
        try {
            block18: {
                try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(catalinaProp));){
                    props.load((InputStream)is);
                    String COMMON_LOADER = "common.loader";
                    String commonLoader = props.getProperty(COMMON_LOADER);
                    if (commonLoader == null) break block18;
                    String COMMON_ENDORSED = "${catalina.home}/common/endorsed/*.jar";
                    int idx = commonLoader.indexOf(COMMON_ENDORSED);
                    if (endorsedEnabled) {
                        if (idx == -1) {
                            String COMMON_LIB = "${catalina.home}/" + this.tm.libFolder() + "/*.jar";
                            int commonLibIdx = commonLoader.indexOf(COMMON_LIB);
                            StringBuffer sb = new StringBuffer(commonLibIdx == -1 ? commonLoader : commonLoader.substring(0, commonLibIdx));
                            if (commonLibIdx != -1) {
                                sb.append(COMMON_ENDORSED).append(',').append(commonLoader.substring(commonLibIdx));
                            } else {
                                if (commonLoader.trim().length() != 0) {
                                    sb.append(',');
                                }
                                sb.append(COMMON_ENDORSED);
                            }
                            props.setProperty(COMMON_LOADER, sb.toString());
                            break block18;
                        }
                        return;
                    }
                    if (idx != -1) {
                        int trailingCommaIdx;
                        String strBefore = commonLoader.substring(0, idx);
                        int commaIdx = strBefore.lastIndexOf(44);
                        StringBuffer sb = new StringBuffer(commonLoader.substring(0, commaIdx == -1 ? idx : commaIdx));
                        String strAfter = commonLoader.substring(idx + COMMON_ENDORSED.length());
                        if (commaIdx == -1 && (trailingCommaIdx = strAfter.indexOf(44)) != -1) {
                            strAfter = strAfter.substring(trailingCommaIdx + 1);
                        }
                        sb.append(strAfter);
                        props.setProperty(COMMON_LOADER, sb.toString());
                        break block18;
                    }
                    return;
                }
            }
            try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(catalinaProp));){
                props.store((OutputStream)out);
            }
        }
        catch (FileNotFoundException fnfe) {
            LOGGER.log(Level.INFO, null, fnfe);
        }
        catch (IOException ioe) {
            LOGGER.log(Level.INFO, null, ioe);
        }
    }

    private static class TomcatFormat
    extends MapFormat {
        private static final long serialVersionUID = 992972967554321415L;

        public TomcatFormat(File startupScript, File homeDir) {
            super(new HashMap());
            Map map = this.getMap();
            String scriptPath = startupScript.getAbsolutePath();
            map.put("catalina", scriptPath);
            map.put(StartTomcat.TAG_EXEC_STARTUP, "run");
            map.put(StartTomcat.TAG_EXEC_SHUTDOWN, "stop");
            map.put("catalina", scriptPath);
            map.put(StartTomcat.TAG_JPDA, StartTomcat.TAG_JPDA);
            map.put(StartTomcat.TAG_JPDA_STARTUP, "run");
            map.put(StartTomcat.TAG_SECURITY_OPT, "-security");
            map.put(StartTomcat.TAG_FORCE_OPT, "-force");
            map.put(StartTomcat.TAG_CATALINA_HOME, homeDir.getAbsolutePath());
        }
    }

    private static class StreamConsumer
    implements Runnable {
        private BufferedInputStream in;

        public StreamConsumer(InputStream is) {
            this.in = new BufferedInputStream(is);
        }

        @Override
        public void run() {
            try {
                int n;
                byte[] buffer = new byte[1024];
                while ((n = this.in.read(buffer)) >= 0) {
                    LOGGER.log(Level.FINE, new String(buffer, 0, n));
                }
            }
            catch (IOException ioe) {
                LOGGER.log(Level.FINE, null, ioe);
            }
            finally {
                try {
                    this.in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private class StartRunnable
    implements Runnable {
        private int mode;
        private CommandType command = CommandType.START;

        public StartRunnable(int mode, CommandType command) {
            this.mode = mode;
            this.command = command;
        }

        @Override
        public synchronized void run() {
            NbProcessDescriptor pd;
            TomcatProperties tp = StartTomcat.this.tm.getTomcatProperties();
            File homeDir = tp.getCatalinaHome();
            if (homeDir == null || !homeDir.exists()) {
                this.fireCmdExecProgressEvent(this.command == CommandType.START ? "MSG_NoHomeDirStart" : "MSG_NoHomeDirStop", StateType.FAILED);
                return;
            }
            File baseDir = tp.getCatalinaBase();
            if (baseDir == null) {
                baseDir = homeDir;
            } else {
                String[] files;
                if (baseDir != null && ((files = baseDir.list()) == null || files.length == 0)) {
                    baseDir = StartTomcat.this.tm.createBaseDir(baseDir, homeDir);
                }
                if (baseDir == null) {
                    this.fireCmdExecProgressEvent(this.command == CommandType.START ? "MSG_NoBaseDirStart" : "MSG_NoBaseDirStop", StateType.FAILED);
                    return;
                }
            }
            File startupScript = StartTomcat.this.getStartupScript();
            if (!startupScript.exists()) {
                String MSG = NbBundle.getMessage(StartTomcat.class, (String)(this.command == CommandType.START ? "MSG_StartFailedNoStartScript" : "MSG_StopFailedNoStartScript"), (Object)startupScript.getAbsolutePath());
                StartTomcat.this.pes.fireHandleProgressEvent(null, new Status(ActionType.EXECUTE, this.command, MSG, StateType.FAILED));
                return;
            }
            if (this.command == CommandType.START) {
                try {
                    MonitorSupport.synchronizeMonitorWithFlag(StartTomcat.this.tm, true);
                }
                catch (IOException e) {
                    if (MonitorSupport.getMonitorFlag(StartTomcat.this.tm)) {
                        MonitorSupport.setMonitorFlag(StartTomcat.this.tm, false);
                        this.fireCmdExecProgressEvent(!StartTomcat.this.tm.isTomcat50() && !StartTomcat.this.tm.isTomcat55() ? "MSG_enableMonitorSupportErr60" : "MSG_enableMonitorSupportErr", StateType.FAILED);
                    } else {
                        this.fireCmdExecProgressEvent("MSG_disableMonitorSupportErr", StateType.FAILED);
                    }
                    LOGGER.log(Level.INFO, null, e);
                    return;
                }
                catch (SAXException e) {
                    LOGGER.log(Level.INFO, null, e);
                }
                try {
                    DebugSupport.allowDebugging(StartTomcat.this.tm);
                }
                catch (IOException e) {
                    LOGGER.log(Level.INFO, null, e);
                }
                catch (SAXException e) {
                    LOGGER.log(Level.INFO, null, e);
                }
            }
            StartTomcat.this.currentServerPort = StartTomcat.this.tm.getServerPort();
            int shutdownPort = StartTomcat.this.tm.getShutdownPort();
            if (this.command == CommandType.START) {
                if (!Utils.isPortFree(StartTomcat.this.currentServerPort)) {
                    this.fireCmdExecProgressEvent("MSG_StartFailedServerPortInUse", String.valueOf(StartTomcat.this.currentServerPort), StateType.FAILED);
                    return;
                }
                if (!Utils.isPortFree(shutdownPort)) {
                    this.fireCmdExecProgressEvent("MSG_StartFailedShutdownPortInUse", String.valueOf(shutdownPort), StateType.FAILED);
                    return;
                }
            }
            String javaOpts = tp.getJavaOpts();
            StringBuilder sb = new StringBuilder(javaOpts);
            if (tp.getProxyEnabled()) {
                String[] PROXY_PROPS = new String[]{"http.proxyHost", "http.proxyPort", "http.nonProxyHosts", "https.proxyHost", "https.proxyPort"};
                boolean isWindows = Utilities.isWindows();
                for (String prop : PROXY_PROPS) {
                    String value;
                    if (javaOpts.contains(prop) || (value = System.getProperty(prop)) == null) continue;
                    if ("http.nonProxyHosts".equals(prop)) {
                        if (isWindows) {
                            boolean javaOptsEscaped = StartTomcat.this.isJavaOptsEscaped();
                            value = javaOptsEscaped ? value.replaceAll("\\|", "^|") : "\"" + value + "\"";
                        } else if (StartTomcat.this.tm.isAboveTomcat70()) {
                            value = "\"" + value + "\"";
                        }
                    }
                    sb.append(" -D").append(prop).append("=").append(value);
                }
            }
            if (this.command == CommandType.START) {
                for (StartupExtender args : StartupExtender.getExtenders((Lookup)Lookups.singleton((Object)CommonServerBridge.getCommonInstance((String)StartTomcat.this.tm.getUri())), (StartupExtender.StartMode)this.getMode(this.mode))) {
                    for (String singleArg : args.getArguments()) {
                        sb.append(' ').append(singleArg);
                    }
                }
            }
            javaOpts = sb.toString();
            JavaPlatform platform = StartTomcat.this.getJavaPlatform();
            String jdkVersion = platform.getSpecification().getVersion().toString();
            if (StartTomcat.this.tm.isBundledTomcat()) {
                StartTomcat.this.patchCatalinaProperties(tp.getCatalinaDir(), "1.4".equals(jdkVersion));
            }
            if (this.mode == 1 && this.command == CommandType.START) {
                pd = null;
                pd = tp.getSecManager() ? StartTomcat.defaultDebugStartDesc("catalina", StartTomcat.TAG_JPDA_STARTUP, StartTomcat.TAG_SECURITY_OPT) : StartTomcat.defaultDebugStartDesc("catalina", StartTomcat.TAG_JPDA_STARTUP);
                try {
                    String address;
                    String transport;
                    this.fireCmdExecProgressEvent("MSG_startProcess", StateType.RUNNING);
                    Process p = null;
                    if (tp.getDebugType().toLowerCase().indexOf("socket") != -1) {
                        transport = "dt_socket";
                        address = Integer.toString(tp.getDebugPort());
                    } else {
                        transport = "dt_shmem";
                        address = tp.getSharedMem();
                    }
                    LOGGER.log(Level.FINE, "transport: " + transport);
                    LOGGER.log(Level.FINE, "address: " + address);
                    p = pd.exec((Format)((Object)new TomcatFormat(startupScript, homeDir)), new String[]{"JAVA_HOME=" + StartTomcat.this.getJavaHome(platform), "JRE_HOME=", "JAVA_OPTS=" + javaOpts, "JPDA_TRANSPORT=" + transport, "JPDA_ADDRESS=" + address, "CATALINA_HOME=" + homeDir.getAbsolutePath(), "CATALINA_BASE=" + baseDir.getAbsolutePath(), "NB_TOMCAT_JDK=" + jdkVersion, "NB_EXEC_TOMCAT_START_PROCESS_UUID=" + StartTomcat.this.tm.getUri()}, true, new File(homeDir, "bin"));
                    StartTomcat.this.tm.setTomcatProcess(p);
                    this.openLogs();
                }
                catch (IOException ioe) {
                    LOGGER.log(Level.FINE, null, ioe);
                    this.fireCmdExecProgressEvent(this.command == CommandType.START ? "MSG_StartFailedIOE" : "MSG_StopFailedIOE", startupScript.getAbsolutePath(), StateType.FAILED);
                    return;
                }
            }
            pd = null;
            pd = this.command == CommandType.START ? (tp.getSecManager() ? StartTomcat.defaultExecDesc("catalina", StartTomcat.TAG_EXEC_STARTUP, StartTomcat.TAG_SECURITY_OPT) : StartTomcat.defaultExecDesc("catalina", StartTomcat.TAG_EXEC_STARTUP)) : (tp.getForceStop() && Utilities.isUnix() ? StartTomcat.defaultExecDesc("catalina", StartTomcat.TAG_EXEC_SHUTDOWN, StartTomcat.TAG_FORCE_OPT) : StartTomcat.defaultExecDesc("catalina", StartTomcat.TAG_EXEC_SHUTDOWN));
            try {
                this.fireCmdExecProgressEvent(this.command == CommandType.START ? "MSG_startProcess" : "MSG_stopProcess", StateType.RUNNING);
                Process p = pd.exec((Format)((Object)new TomcatFormat(startupScript, homeDir)), new String[]{"JAVA_HOME=" + StartTomcat.this.getJavaHome(platform), "JRE_HOME=", "JAVA_OPTS=" + javaOpts, "CATALINA_HOME=" + homeDir.getAbsolutePath(), "CATALINA_BASE=" + baseDir.getAbsolutePath(), "NB_TOMCAT_JDK=" + jdkVersion, "NB_EXEC_TOMCAT_START_PROCESS_UUID=" + StartTomcat.this.tm.getUri()}, true, new File(homeDir, "bin"));
                if (this.command == CommandType.START) {
                    StartTomcat.this.tm.setTomcatProcess(p);
                    this.openLogs();
                } else {
                    SERVER_STREAMS_RP.post((Runnable)new StreamConsumer(p.getInputStream()), 0, 1);
                    SERVER_STREAMS_RP;
                    RequestProcessor.getDefault().post((Runnable)new StreamConsumer(p.getErrorStream()), 0, 1);
                }
            }
            catch (IOException ioe) {
                LOGGER.log(Level.FINE, null, ioe);
                this.fireCmdExecProgressEvent(this.command == CommandType.START ? "MSG_StartFailedIOE" : "MSG_StopFailedIOE", startupScript.getAbsolutePath(), StateType.FAILED);
                return;
            }
            this.fireCmdExecProgressEvent("MSG_waiting", StateType.RUNNING);
            if (this.hasCommandSucceeded()) {
                if (this.command == CommandType.START) {
                    StartTomcat.this.tm.setNeedsRestart(false);
                    if (this.mode == 1) {
                        isDebugModeUri.put(StartTomcat.this.tm.getUri(), new Object());
                    }
                }
                this.fireCmdExecProgressEvent(this.command == CommandType.START ? "MSG_Started" : "MSG_Stopped", StateType.COMPLETED);
            } else {
                this.fireCmdExecProgressEvent(this.command == CommandType.START ? "MSG_StartFailed" : "MSG_StopFailed", StateType.FAILED);
            }
        }

        private StartupExtender.StartMode getMode(int mode) {
            switch (mode) {
                case 2: {
                    return StartupExtender.StartMode.PROFILE;
                }
                case 1: {
                    return StartupExtender.StartMode.DEBUG;
                }
            }
            return StartupExtender.StartMode.NORMAL;
        }

        private void openLogs() {
            LogManager logManager = StartTomcat.this.tm.logManager();
            if (logManager.hasJuliLog()) {
                logManager.openJuliLog();
            }
            logManager.closeServerLog();
            logManager.openServerLog();
        }

        private void fireCmdExecProgressEvent(String resName, StateType stateType) {
            String msg = NbBundle.getMessage(StartTomcat.class, (String)resName);
            StartTomcat.this.pes.fireHandleProgressEvent(null, new Status(ActionType.EXECUTE, this.command, msg, stateType));
        }

        private void fireCmdExecProgressEvent(String resName, Object arg1, StateType stateType) {
            String msg = NbBundle.getMessage(StartTomcat.class, (String)resName, (Object)arg1);
            StartTomcat.this.pes.fireHandleProgressEvent(null, new Status(ActionType.EXECUTE, this.command, msg, stateType));
        }

        private boolean hasCommandSucceeded() {
            long timeout = System.currentTimeMillis() + 180000L;
            while (true) {
                boolean isRunning = StartTomcat.this.isRunning();
                if (this.command == CommandType.START) {
                    if (isRunning) {
                        return true;
                    }
                    if (StartTomcat.this.isStopped()) {
                        return false;
                    }
                    if (this.mode == 2) {
                        int state = ProfilerSupport.getState();
                        if (state == 2 || state == 3 || state == 4) {
                            return true;
                        }
                        if (state == 0) {
                            return false;
                        }
                    }
                }
                if (this.command == CommandType.STOP && StartTomcat.this.isStopped()) {
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    return true;
                }
                if (System.currentTimeMillis() > timeout) {
                    return false;
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }
    }
}

