/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.commons;

import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ResourceBundle;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import org.netbeans.modules.bugtracking.commons.AttachmentsPanel;
import org.netbeans.modules.bugtracking.commons.LinkButton;
import org.netbeans.modules.bugtracking.commons.UIUtils;
import org.openide.filesystems.FileChooserBuilder;
import org.openide.filesystems.FileUtil;
import org.openide.util.ChangeSupport;
import org.openide.util.NbBundle;

public class AttachmentPanel
extends JPanel
implements DocumentListener,
ActionListener {
    static final String PROP_DELETED = "attachmentDeleted";
    private final AttachmentsPanel.NBBugzillaCallback nbCallback;
    private final ChangeSupport supp;
    final JButton browseButton = new JButton();
    private LinkButton deleteButton;
    private JTextField descriptionField;
    private JLabel descriptionLabel;
    final JTextField fileField = new JTextField();
    final JComboBox fileTypeCombo = new JComboBox();
    private JLabel fileTypeLabel;
    final JCheckBox patchChoice = new JCheckBox();
    final JLabel patchLabel = new JLabel();
    final LinkButton viewButton = new LinkButton();

    public AttachmentPanel(AttachmentsPanel.NBBugzillaCallback nbCallback) {
        this.nbCallback = nbCallback;
        this.supp = new ChangeSupport((Object)this);
        this.initComponents();
        this.setBackground(UIUtils.getSectionPanelBackground());
        this.initFileTypeCombo();
        this.attachListeners();
    }

    private void initFileTypeCombo() {
        DefaultComboBoxModel<FileType> model = new DefaultComboBoxModel<FileType>();
        ResourceBundle bundle = NbBundle.getBundle(AttachmentPanel.class);
        model.addElement(new FileType(null, bundle.getString("AttachmentPanel.fileType.automatic")));
        model.addElement(new FileType("text/plain", bundle.getString("AttachmentPanel.fileType.textPlain")));
        model.addElement(new FileType("text/html", bundle.getString("AttachmentPanel.fileType.textHTML")));
        model.addElement(new FileType("application/xml", bundle.getString("AttachmentPanel.fileType.applicationXML")));
        model.addElement(new FileType("image/gif", bundle.getString("AttachmentPanel.fileType.imageGIF")));
        model.addElement(new FileType("image/jpeg", bundle.getString("AttachmentPanel.fileType.imageJPEG")));
        model.addElement(new FileType("image/png", bundle.getString("AttachmentPanel.fileType.imagePNG")));
        model.addElement(new FileType("application/octet-stream", bundle.getString("AttachmentPanel.fileType.binary")));
        this.fileTypeCombo.setModel(model);
    }

    void setAttachment(File f, String description, String conntentType, boolean isPatch) {
        this.descriptionField.setText(description);
        this.fileField.setText(f.getAbsolutePath());
        this.patchChoice.setSelected(isPatch);
        int c = this.fileTypeCombo.getItemCount();
        if (conntentType != null) {
            for (int i = 0; i < c; ++i) {
                String ct;
                Object o = this.fileTypeCombo.getItemAt(i);
                if (!(o instanceof FileType) || (ct = ((FileType)o).contentType) == null || !ct.equals(conntentType)) continue;
                this.fileTypeCombo.setSelectedItem(o);
                break;
            }
        }
    }

    public File getFile() {
        File file = null;
        if (!this.isDeleted()) {
            file = new File(this.fileField.getText());
        }
        return file;
    }

    public String getDescription() {
        return this.descriptionField.getText();
    }

    public String getContentType() {
        String contentType = null;
        Object value = this.fileTypeCombo.getSelectedItem();
        contentType = value instanceof FileType ? ((FileType)value).getContentType() : value.toString();
        return contentType;
    }

    public boolean isPatch() {
        return this.patchChoice.isSelected();
    }

    public boolean isDeleted() {
        return !this.isVisible();
    }

    private void initComponents() {
        this.deleteButton = new LinkButton();
        this.descriptionLabel = new JLabel();
        this.descriptionField = new JTextField();
        this.fileTypeLabel = new JLabel();
        this.fileField.setColumns(30);
        this.browseButton.setText(NbBundle.getMessage(AttachmentPanel.class, (String)"AttachmentPanel.browseButton.text"));
        this.browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AttachmentPanel.this.browseButtonActionPerformed(evt);
            }
        });
        this.deleteButton.setText(NbBundle.getMessage(AttachmentPanel.class, (String)"AttachmentPanel.deleteButton.text"));
        this.deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AttachmentPanel.this.deleteButtonActionPerformed(evt);
            }
        });
        this.descriptionLabel.setLabelFor(this.descriptionField);
        this.descriptionLabel.setText(NbBundle.getMessage(AttachmentPanel.class, (String)"AttachmentPanel.descriptionLabel.text"));
        this.fileTypeLabel.setLabelFor(this.fileTypeCombo);
        this.fileTypeLabel.setText(NbBundle.getMessage(AttachmentPanel.class, (String)"AttachmentPanel.fileTypeLabel.text"));
        this.fileTypeCombo.setEditable(true);
        this.patchLabel.setLabelFor(this.patchChoice);
        this.patchLabel.setText(NbBundle.getMessage(AttachmentPanel.class, (String)"AttachmentPanel.patchLabel.text"));
        this.patchChoice.setBorder(null);
        this.patchChoice.setMargin(new Insets(0, 0, 0, 0));
        this.patchChoice.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AttachmentPanel.this.patchChoiceActionPerformed(evt);
            }
        });
        this.viewButton.setText(NbBundle.getMessage(AttachmentPanel.class, (String)"AttachmentPanel.viewButton.text"));
        this.viewButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AttachmentPanel.this.viewButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.fileField, -1, 228, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.browseButton)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.fileTypeLabel).addComponent(this.descriptionLabel).addComponent(this.patchLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.fileTypeCombo, -2, -1, -2).addComponent(this.descriptionField).addComponent(this.patchChoice)))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.viewButton, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.deleteButton, -2, -1, -2).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.fileField, -2, -1, -2).addComponent(this.browseButton).addComponent(this.deleteButton, -2, -1, -2).addComponent(this.viewButton, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.descriptionLabel).addComponent(this.descriptionField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.fileTypeLabel).addComponent(this.fileTypeCombo, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.patchLabel).addComponent(this.patchChoice)).addContainerGap(-1, Short.MAX_VALUE)));
        this.fileField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(AttachmentPanel.class, (String)"AttachmentPanel.fileField.AccessibleContext.accessibleName"));
        this.fileField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AttachmentPanel.class, (String)"AttachmentPanel.fileField.AccessibleContext.accessibleDescription"));
        this.browseButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AttachmentPanel.class, (String)"AttachmentPanel.browseButton.AccessibleContext.accessibleDescription"));
        this.deleteButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AttachmentPanel.class, (String)"AttachmentPanel.deleteButton.AccessibleContext.accessibleDescription"));
        this.descriptionField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AttachmentPanel.class, (String)"AttachmentPanel.descriptionField.AccessibleContext.accessibleDescription"));
        this.fileTypeCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AttachmentPanel.class, (String)"AttachmentPanel.fileTypeCombo.AccessibleContext.accessibleDescription"));
        this.patchChoice.getAccessibleContext().setAccessibleName(NbBundle.getMessage(AttachmentPanel.class, (String)"AttachmentPanel.patchChoice.AccessibleContext.accessibleName"));
        this.patchChoice.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AttachmentPanel.class, (String)"AttachmentPanel.patchChoice.AccessibleContext.accessibleDescription"));
    }

    private void deleteButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.firePropertyChange(PROP_DELETED, null, null);
    }

    private void browseButtonActionPerformed(ActionEvent evt) {
        File attachment = new FileChooserBuilder(AttachmentPanel.class).showOpenDialog();
        if (attachment != null) {
            attachment = FileUtil.normalizeFile((File)attachment);
            this.fileField.setText(attachment.getAbsolutePath());
        }
    }

    private void patchChoiceActionPerformed(ActionEvent evt) {
        this.fileTypeCombo.setEnabled(!this.patchChoice.isSelected());
        if (this.patchChoice.isSelected()) {
            this.fileTypeCombo.setSelectedIndex(1);
        }
    }

    private void viewButtonActionPerformed(ActionEvent evt) {
        this.nbCallback.showLogFile();
    }

    void addChangeListener(ChangeListener changeListener) {
        this.supp.addChangeListener(changeListener);
    }

    private void attachListeners() {
        this.fileField.getDocument().addDocumentListener(this);
        this.descriptionField.getDocument().addDocumentListener(this);
        this.fileTypeCombo.addActionListener(this);
        this.patchChoice.addActionListener(this);
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.fieldUpdated(e.getDocument());
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.fieldUpdated(e.getDocument());
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.fileTypeCombo || e.getSource() == this.patchChoice) {
            this.supp.fireChange();
        }
    }

    private void fieldUpdated(Document document) {
        if (document == this.fileField.getDocument() || document == this.descriptionField.getDocument()) {
            this.supp.fireChange();
        }
    }

    static class FileType {
        private String contentType;
        private String displayName;

        FileType(String contentType, String displayName) {
            this.contentType = contentType;
            this.displayName = displayName;
        }

        public String getContentType() {
            return this.contentType;
        }

        public String toString() {
            return this.displayName + (this.contentType == null ? "" : " (" + this.contentType + ')');
        }
    }
}

