/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.team.commons.treelist;

import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.ListSelectionModel;
import javax.swing.ToolTipManager;
import javax.swing.plaf.ListUI;
import org.netbeans.modules.team.commons.ColorManager;
import org.netbeans.modules.team.commons.treelist.RendererPanel;
import org.netbeans.modules.team.commons.treelist.TreeListModel;
import org.netbeans.modules.team.commons.treelist.TreeListNode;
import org.netbeans.modules.team.commons.treelist.TreeListUI;
import org.openide.util.Utilities;

public class TreeList
extends JList {
    static final int INSETS_TOP = 2;
    static final int INSETS_BOTTOM = 2;
    static final int INSETS_LEFT = 4;
    static final int INSETS_RIGHT = 4;
    private static final String ACTION_EXPAND = "expandSet";
    private static final String ACTION_COLLAPSE = "collapseSet";
    private static final String ACTION_DEFAULT = "invokeDefaultAction";
    private static final String ACTION_SHOW_POPUP = "showPopup";
    private Action expandAction;
    private Action collapseAction;
    private Action defaultAction;
    private Action showPopupAction;
    private final TreeListRenderer renderer = new TreeListRenderer();
    static final int ROW_HEIGHT = Math.max(16, Math.max(RendererPanel.getExpandedIcon().getIconHeight(), new JLabel((String)"X").getPreferredSize().height));

    public TreeList(TreeListModel model) {
        super(model);
        this.setSelectionMode(2);
        this.setFixedCellHeight(ROW_HEIGHT + 2 + 2 + 2);
        this.setCellRenderer(this.renderer);
        this.setBackground(ColorManager.getDefault().getDefaultBackground());
        ToolTipManager.sharedInstance().registerComponent(this);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() != 2 || e.isPopupTrigger() || e.isConsumed()) {
                    return;
                }
                int index = TreeList.this.locationToIndex(e.getPoint());
                if (index < 0 || index >= TreeList.this.getModel().getSize()) {
                    return;
                }
                Object value = TreeList.this.getModel().getElementAt(index);
                if (value instanceof TreeListNode) {
                    TreeListNode node = (TreeListNode)value;
                    if (null != node && !node.isExpandable()) {
                        Action al = node.getDefaultAction();
                        if (null != al) {
                            al.actionPerformed(new ActionEvent(e.getSource(), e.getID(), e.paramString()));
                        }
                    } else if (null != node && node.isExpandable()) {
                        if (!node.isLoaded()) {
                            return;
                        }
                        node.setExpanded(!node.isExpanded());
                    }
                }
            }
        });
    }

    @Override
    public void setUI(ListUI ui) {
        super.setUI(new TreeListUI());
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.initKeysAndActions();
    }

    private void initKeysAndActions() {
        this.unregisterKeyboardAction(KeyStroke.getKeyStroke(39, 0));
        this.unregisterKeyboardAction(KeyStroke.getKeyStroke(37, 0));
        this.unregisterKeyboardAction(KeyStroke.getKeyStroke(10, 0));
        this.unregisterKeyboardAction(KeyStroke.getKeyStroke(121, 64));
        this.expandAction = new ExpandAction();
        this.collapseAction = new CollapseAction();
        this.defaultAction = new DefaultAction();
        this.showPopupAction = new ShowPopupAction();
        InputMap imp = this.getInputMap();
        InputMap impAncestor = this.getInputMap(1);
        ActionMap am = this.getActionMap();
        imp.put(KeyStroke.getKeyStroke(39, 0), ACTION_EXPAND);
        imp.put(KeyStroke.getKeyStroke(37, 0), ACTION_COLLAPSE);
        imp.put(KeyStroke.getKeyStroke(10, 0), ACTION_DEFAULT);
        imp.put(KeyStroke.getKeyStroke(121, 64), ACTION_SHOW_POPUP);
        impAncestor.remove(KeyStroke.getKeyStroke(39, 0));
        impAncestor.remove(KeyStroke.getKeyStroke(37, 0));
        impAncestor.remove(KeyStroke.getKeyStroke(10, 0));
        impAncestor.remove(KeyStroke.getKeyStroke(121, 64));
        am.put(ACTION_EXPAND, this.expandAction);
        am.put(ACTION_COLLAPSE, this.collapseAction);
        am.put(ACTION_DEFAULT, this.defaultAction);
        am.put(ACTION_SHOW_POPUP, this.showPopupAction);
    }

    private TreeListNode getSelectedTreeListNode() {
        Object sel = super.getSelectedValue();
        if (sel instanceof TreeListNode) {
            return (TreeListNode)sel;
        }
        return null;
    }

    void showPopupMenuAt(int rowIndex, Point location) {
        Action[] actions;
        TreeListNode node = (TreeListNode)this.getModel().getElementAt(rowIndex);
        boolean popupForSelected = false;
        if (this.getSelectionMode() != 0) {
            popupForSelected = this.isPopupForSelected(node);
        }
        if (!popupForSelected) {
            this.setSelectedIndex(rowIndex);
        }
        if (null == (actions = node.getPopupActions()) || actions.length == 0) {
            return;
        }
        JPopupMenu popup = Utilities.actionsToPopup((Action[])actions, (Component)this);
        popup.show(this, location.x, location.y);
    }

    private boolean isPopupForSelected(TreeListNode node) {
        List selectedValues = this.getSelectedValuesList();
        for (Object selectedNode : selectedValues) {
            if (selectedNode == null || !selectedNode.equals(node)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        if (event != null) {
            Rectangle cellBounds;
            Point p = event.getPoint();
            int index = this.locationToIndex(p);
            ListCellRenderer r = this.getCellRenderer();
            if (index != -1 && r != null && (cellBounds = this.getCellBounds(index, index)) != null && cellBounds.contains(p.x, p.y)) {
                ListSelectionModel lsm = this.getSelectionModel();
                Component rComponent = r.getListCellRendererComponent(this, this.getModel().getElementAt(index), index, lsm.isSelectedIndex(index), this.hasFocus() && lsm.getLeadSelectionIndex() == index);
                if (rComponent instanceof JComponent) {
                    rComponent.setBounds(cellBounds);
                    rComponent.doLayout();
                    p.translate(-cellBounds.x, -cellBounds.y);
                    MouseEvent newEvent = new MouseEvent(rComponent, event.getID(), event.getWhen(), event.getModifiers(), p.x, p.y, event.getClickCount(), event.isPopupTrigger());
                    String tip = ((JComponent)rComponent).getToolTipText(newEvent);
                    if (tip != null) {
                        return tip;
                    }
                }
            }
        }
        return super.getToolTipText();
    }

    private class DefaultAction
    extends AbstractAction {
        public DefaultAction() {
            super(TreeList.ACTION_DEFAULT);
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            Action al;
            TreeListNode node = TreeList.this.getSelectedTreeListNode();
            if (null != node && null != (al = node.getDefaultAction())) {
                al.actionPerformed(ae);
            }
        }

        @Override
        public boolean isEnabled() {
            TreeListNode node = TreeList.this.getSelectedTreeListNode();
            return null != node && null != node.getDefaultAction();
        }
    }

    private class ShowPopupAction
    extends AbstractAction {
        public ShowPopupAction() {
            super(TreeList.ACTION_SHOW_POPUP);
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            TreeListNode node = TreeList.this.getSelectedTreeListNode();
            TreeList tl = (TreeList)ae.getSource();
            JPopupMenu menu = Utilities.actionsToPopup((Action[])node.getPopupActions(), (Component)tl);
            Point p = tl.getUI().indexToLocation(tl, tl.getSelectedIndex());
            menu.show(tl, p.x + 22, p.y);
        }

        @Override
        public boolean isEnabled() {
            TreeListNode node = TreeList.this.getSelectedTreeListNode();
            return null != node && null != node.getPopupActions();
        }
    }

    private class CollapseAction
    extends AbstractAction {
        public CollapseAction() {
            super(TreeList.ACTION_COLLAPSE);
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            TreeListNode node = TreeList.this.getSelectedTreeListNode();
            if (null != node && node.isExpandable() && node.isExpanded()) {
                node.setExpanded(false);
            } else if (node != null && node.getParent() != null) {
                node.getParent().setExpanded(false);
                TreeList.this.setSelectedValue(node.getParent(), true);
            }
        }

        @Override
        public boolean isEnabled() {
            TreeListNode node = TreeList.this.getSelectedTreeListNode();
            return null != node;
        }
    }

    private class ExpandAction
    extends AbstractAction {
        public ExpandAction() {
            super(TreeList.ACTION_EXPAND);
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            TreeListNode node = TreeList.this.getSelectedTreeListNode();
            if (null != node && node.isExpandable()) {
                node.setExpanded(true);
            }
        }

        @Override
        public boolean isEnabled() {
            TreeListNode node = TreeList.this.getSelectedTreeListNode();
            return null != node && node.isExpandable();
        }
    }

    private static class TreeListRenderer
    implements ListCellRenderer {
        private TreeListRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (!(value instanceof TreeListNode)) {
                return new JLabel();
            }
            TreeListNode node = (TreeListNode)value;
            int rowHeight = list.getFixedCellHeight();
            int rowWidth = list.getVisibleRect().width;
            int dropIndex = -1;
            JList.DropLocation dropLocation = list.getDropLocation();
            if (dropLocation != null && !dropLocation.isInsert()) {
                dropIndex = dropLocation.getIndex();
            }
            boolean isDropTarget = dropIndex == index;
            isSelected = isSelected || isDropTarget;
            Color background = isSelected ? list.getSelectionBackground() : list.getBackground();
            Color foreground = isSelected ? list.getSelectionForeground() : list.getForeground();
            return node.getRenderer(foreground, background, isSelected, cellHasFocus, rowHeight, rowWidth);
        }
    }
}

