/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.client.cli.commands;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.regex.Pattern;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.client.cli.SvnCommand;

public class VersionCommand
extends SvnCommand {
    private List<String> output = new ArrayList<String>();
    private boolean unsupportedVersion = false;
    private boolean supportedMetadataFormat = false;
    static final Version VERSION_15 = Version.parse("1.5");
    static final Version VERSION_16 = Version.parse("1.6");

    @Override
    protected int getCommand() {
        return 0;
    }

    @Override
    public void prepareCommand(SvnCommand.Arguments arguments) throws IOException {
        arguments.add("--version");
    }

    @Override
    protected void config(File configDir, String username, String password, SvnCommand.Arguments arguments) {
        arguments.addConfigDir(configDir);
    }

    @Override
    public void outputText(String lineString) {
        if (lineString == null || lineString.trim().equals("")) {
            return;
        }
        this.output.add(lineString);
        super.outputText(lineString);
    }

    public boolean checkForErrors() {
        Integer exitCode = this.getExitCode();
        if (exitCode == null || !exitCode.equals(0)) {
            return false;
        }
        boolean outputProduced = false;
        for (String string : this.output) {
            if ((string = string.trim()).length() == 0) continue;
            outputProduced = true;
            int pos = string.indexOf(" version ");
            if (pos <= -1) continue;
            String vString = string.substring(pos + 9);
            Subversion.LOG.log(Level.INFO, "Commandline client version: {0}", vString);
            Version version = Version.parse(vString);
            if (version.lowerThan(VERSION_15)) {
                this.unsupportedVersion = true;
                return false;
            }
            if (!version.sameMinor(VERSION_15) && !version.sameMinor(VERSION_16)) continue;
            this.supportedMetadataFormat = true;
        }
        return outputProduced;
    }

    public boolean isUnsupportedVersion() {
        return this.unsupportedVersion;
    }

    public boolean isMetadataFormatSupported() {
        return this.supportedMetadataFormat;
    }

    public String getOutput() {
        StringBuffer sb = new StringBuffer();
        for (String string : this.output) {
            sb.append(string);
            sb.append('\n');
        }
        return sb.toString();
    }

    public static class Version
    implements Comparable<Version> {
        final int[] parts;
        final String remainder;

        private Version(int[] parts, String remainder) {
            this.parts = parts;
            this.remainder = remainder;
        }

        public static Version parse(String version) throws NumberFormatException, IllegalArgumentException {
            return Version.parse(version, " ");
        }

        public static Version parse(String version, String remainderDelimiter) throws NumberFormatException, IllegalArgumentException {
            Version.assertNotNullArg(version, "Version parameter must not be null");
            Version.assertNotNullArg(remainderDelimiter, "reminderDelimiter parameter must not be null");
            String[] versionMajorParts = version.split(Pattern.quote(remainderDelimiter), 2);
            String[] stringParts = versionMajorParts[0].split("\\.");
            int[] parts = new int[stringParts.length];
            for (int i = 0; i < stringParts.length; ++i) {
                parts[i] = Integer.parseInt(stringParts[i]);
            }
            return new Version(parts, versionMajorParts.length > 1 ? versionMajorParts[1] : "");
        }

        private static void assertNotNullArg(Object value, String errMessage) throws IllegalArgumentException {
            if (value == null) {
                throw new IllegalArgumentException(errMessage);
            }
        }

        @Override
        public int compareTo(Version t) {
            if (t == null) {
                return 1;
            }
            for (int i = 0; i < this.parts.length; ++i) {
                if (t.parts.length < i) {
                    return 1;
                }
                int a = this.parts[i];
                int b = t.parts[i];
                if (a < b) {
                    return -1;
                }
                if (a <= b) continue;
                return 1;
            }
            return t.parts.length > this.parts.length ? -1 : 0;
        }

        public boolean lowerThan(Version that) {
            return this.compareTo(that) < 0;
        }

        public boolean sameMinor(Version that) {
            return that != null && this.trim(2).compareTo(that.trim(2)) == 0;
        }

        private Version trim(int level) {
            int[] newParts = new int[level];
            System.arraycopy(this.parts, 0, newParts, 0, Math.min(level, this.parts.length));
            return new Version(newParts, this.remainder);
        }

        public boolean greaterThan(Version that) {
            return this.compareTo(that) > 0;
        }
    }
}

