/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spring.beans.model.impl;

import java.net.URL;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.ElementUtilities;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.AnnotationModelHelper;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.PersistentObject;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.parser.AnnotationParser;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.parser.ParseResult;
import org.netbeans.modules.spring.api.beans.SpringAnnotations;
import org.netbeans.modules.spring.api.beans.model.Location;
import org.netbeans.modules.spring.api.beans.model.SpringBean;
import org.netbeans.modules.spring.api.beans.model.SpringBeanProperty;
import org.netbeans.modules.spring.beans.model.impl.Refreshable;
import org.netbeans.modules.spring.beans.model.impl.SpringAnnotatedBeanLocation;
import org.openide.filesystems.FileObject;

public class SpringBeanImpl
extends PersistentObject
implements SpringBean,
Refreshable {
    private String id;
    private List<String> names = new LinkedList<String>();
    private String className;
    private String parent;
    private String factoryBean;
    private String factoryMethod;
    private Set<SpringBeanProperty> properties;
    private Location location;

    protected SpringBeanImpl(AnnotationModelHelper helper, TypeElement typeElement) {
        super(helper, typeElement);
        boolean valid = this.refresh(typeElement);
        assert (valid);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public List<String> getNames() {
        return this.names;
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    @Override
    public String getParent() {
        return this.parent;
    }

    @Override
    public String getFactoryBean() {
        return this.factoryBean;
    }

    @Override
    public String getFactoryMethod() {
        return this.factoryMethod;
    }

    @Override
    public Set<SpringBeanProperty> getProperties() {
        return this.properties;
    }

    @Override
    public Location getLocation() {
        return this.location;
    }

    @Override
    public final boolean refresh(TypeElement type) {
        Map types = this.getHelper().getAnnotationsByType(this.getHelper().getCompilationController().getElements().getAllAnnotationMirrors(type));
        AnnotationMirror annotationMirror = SpringBeanImpl.getAnnotationMirror(types);
        if (annotationMirror == null) {
            return false;
        }
        AnnotationParser parser = AnnotationParser.create((AnnotationModelHelper)this.getHelper());
        parser.expectString("value", null);
        ParseResult parseResult = parser.parse(annotationMirror);
        this.className = ElementUtilities.getBinaryName((TypeElement)type);
        this.names.clear();
        if (parseResult.get("value", String.class) == null) {
            this.names.add(SpringBeanImpl.getConvertedClassName(this.className));
        } else {
            this.names.add((String)parseResult.get("value", String.class));
        }
        this.refreshLocation(this.className);
        return true;
    }

    private void refreshLocation(String fqn) {
        String cpBase = fqn.replace('.', '/');
        ClassPath sourceCP = this.getHelper().getClasspathInfo().getClassPath(ClasspathInfo.PathKind.SOURCE);
        FileObject classFO = sourceCP.findResource(cpBase + ".java");
        if (classFO == null) {
            ClassPath compileCP = this.getHelper().getClasspathInfo().getClassPath(ClasspathInfo.PathKind.COMPILE);
            classFO = SpringBeanImpl.searchForFile(compileCP, cpBase);
        }
        if (classFO != null) {
            this.location = new SpringAnnotatedBeanLocation(classFO);
        }
    }

    private static FileObject searchForFile(ClassPath cp, String cpBase) {
        FileObject file = SpringBeanImpl.getFileFromClasspath(cp, cpBase + ".java");
        if (file == null) {
            return SpringBeanImpl.getFileFromClasspath(cp, cpBase + ".class");
        }
        return file;
    }

    private static FileObject getFileFromClasspath(ClassPath cp, String classRelativePath) {
        for (ClassPath.Entry entry : cp.entries()) {
            FileObject[] roots;
            if (entry.isValid()) {
                roots = new FileObject[]{entry.getRoot()};
            } else {
                SourceForBinaryQuery.Result res = SourceForBinaryQuery.findSourceRoots((URL)entry.getURL());
                roots = res.getRoots();
            }
            for (FileObject root : roots) {
                FileObject metaInf = root.getFileObject(classRelativePath);
                if (metaInf == null) continue;
                return metaInf;
            }
        }
        return null;
    }

    private static AnnotationMirror getAnnotationMirror(Map<String, ? extends AnnotationMirror> types) {
        Iterator<String> it = SpringAnnotations.SPRING_COMPONENTS.iterator();
        while (it.hasNext()) {
            AnnotationMirror annotationMirror = types.get(it.next());
            if (annotationMirror == null) continue;
            return annotationMirror;
        }
        return null;
    }

    private static String getConvertedClassName(String className) {
        String result = className.substring(className.lastIndexOf(".") + 1);
        if (result.length() > 1) {
            StringBuilder builder = new StringBuilder();
            builder.append(Character.toLowerCase(result.charAt(0)));
            builder.append(result.substring(1));
            result = builder.toString();
        }
        return result;
    }
}

