/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spring.beans.completion;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.spring.beans.completion.CompletionContext;
import org.netbeans.modules.spring.beans.completion.SpringCompletionResult;
import org.netbeans.modules.spring.beans.completion.SpringXMLConfigCompletionItem;
import org.openide.util.Exceptions;

public abstract class Completor {
    private volatile List<SpringXMLConfigCompletionItem> cache = new ArrayList<SpringXMLConfigCompletionItem>();
    private volatile int anchorOffset = -1;
    private final int invocationOffset;
    private volatile boolean hasAdditionalItems = false;
    private volatile boolean cancelled = false;

    protected Completor(int invocationOffset) {
        this.invocationOffset = invocationOffset;
    }

    public final SpringCompletionResult complete(CompletionContext context) {
        try {
            this.anchorOffset = this.initAnchorOffset(context);
            this.compute(context);
            return SpringCompletionResult.create(this.cache, this.anchorOffset, this.hasAdditionalItems, this.getAdditionalItemsText());
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return SpringCompletionResult.NONE;
        }
    }

    protected abstract int initAnchorOffset(CompletionContext var1);

    protected abstract void compute(CompletionContext var1) throws IOException;

    public boolean canFilter(CompletionContext context) {
        return false;
    }

    public final SpringCompletionResult filter(CompletionContext context) {
        return SpringCompletionResult.create(this.doFilter(context), this.anchorOffset, this.hasAdditionalItems, this.getAdditionalItemsText());
    }

    protected List<SpringXMLConfigCompletionItem> doFilter(CompletionContext context) {
        throw new UnsupportedOperationException("No default implementation");
    }

    protected final void addCacheItem(SpringXMLConfigCompletionItem item) {
        this.cache.add(item);
    }

    protected List<SpringXMLConfigCompletionItem> getCacheItems() {
        return this.cache;
    }

    protected final int getAnchorOffset() {
        return this.anchorOffset;
    }

    protected final boolean isCancelled() {
        return this.cancelled;
    }

    protected final void cancel() {
        this.cancelled = true;
    }

    protected final int getInvocationOffset() {
        return this.invocationOffset;
    }

    protected String getAdditionalItemsText() {
        return "";
    }

    protected void setAdditionalItems(boolean additionalItems) {
        this.hasAdditionalItems = additionalItems;
    }
}

