/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.concurrent.Future;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.ProjectGroup;
import org.netbeans.api.project.ui.ProjectGroupChangeListener;
import org.netbeans.modules.project.ui.OpenProjectList;
import org.netbeans.modules.project.ui.groups.Group;
import org.netbeans.modules.project.uiapi.BaseUtilities;
import org.netbeans.modules.project.uiapi.OpenProjectsTrampoline;

public final class OpenProjectsTrampolineImpl
implements OpenProjectsTrampoline,
PropertyChangeListener {
    private PropertyChangeSupport pchSupport;
    private boolean listenersRegistered;

    public Project[] getOpenProjectsAPI() {
        return OpenProjectList.getDefault().getOpenProjects();
    }

    public void openAPI(Project[] projects, boolean openRequiredProjects, boolean showProgress) {
        OpenProjectList.getDefault().open(projects, openRequiredProjects, showProgress);
    }

    public void closeAPI(Project[] projects) {
        OpenProjectList.getDefault().close(projects, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChangeListenerAPI(PropertyChangeListener listener, Object source) {
        boolean shouldRegisterListener;
        OpenProjectsTrampolineImpl openProjectsTrampolineImpl = this;
        synchronized (openProjectsTrampolineImpl) {
            shouldRegisterListener = !this.listenersRegistered;
            if (shouldRegisterListener) {
                this.listenersRegistered = true;
                this.pchSupport = new PropertyChangeSupport(source);
            }
        }
        if (shouldRegisterListener) {
            OpenProjectList.getDefault().addPropertyChangeListener(this);
        }
        assert (this.pchSupport != null);
        this.pchSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListenerAPI(PropertyChangeListener listener) {
        if (this.pchSupport != null) {
            this.pchSupport.removePropertyChangeListener(listener);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName().equals("OpenProjects")) {
            this.pchSupport.firePropertyChange("openProjects", e.getOldValue(), e.getNewValue());
        }
        if (e.getPropertyName().equals("willOpenProjects")) {
            this.pchSupport.firePropertyChange("willOpenProjects", e.getOldValue(), e.getNewValue());
        }
        if (e.getPropertyName().equals("MainProject")) {
            this.pchSupport.firePropertyChange("MainProject", e.getOldValue(), e.getNewValue());
        }
    }

    public Project getMainProject() {
        return OpenProjectList.getDefault().getMainProject();
    }

    public void setMainProject(Project project) {
        OpenProjectList.getDefault().setMainProject(project);
    }

    public Future<Project[]> openProjectsAPI() {
        return OpenProjectList.getDefault().openProjectsAPI();
    }

    public void addProjectGroupChangeListenerAPI(ProjectGroupChangeListener listener) {
        OpenProjectList.getDefault().addProjectGroupChangeListener(listener);
    }

    public void removeProjectGroupChangeListenerAPI(ProjectGroupChangeListener listener) {
        OpenProjectList.getDefault().removeProjectGroupChangeListener(listener);
    }

    public ProjectGroup getActiveProjectGroupAPI() {
        Group gr = Group.getActiveGroup();
        if (gr != null) {
            return BaseUtilities.ACCESSOR.createGroup(gr.getName(), gr.prefs());
        }
        return null;
    }
}

