/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.v2.features;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.SwingUtilities;
import org.netbeans.lib.profiler.ProfilerClient;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.common.Profiler;
import org.netbeans.lib.profiler.common.ProfilingSettings;
import org.netbeans.lib.profiler.ui.components.ProfilerToolbar;
import org.netbeans.lib.profiler.ui.swing.PopupButton;
import org.netbeans.lib.profiler.ui.swing.SmallButton;
import org.netbeans.modules.profiler.ResultsListener;
import org.netbeans.modules.profiler.ResultsManager;
import org.netbeans.modules.profiler.api.ProfilerDialogs;
import org.netbeans.modules.profiler.api.ProfilerIDESettings;
import org.netbeans.modules.profiler.api.ProjectUtilities;
import org.netbeans.modules.profiler.api.icons.Icons;
import org.netbeans.modules.profiler.api.java.SourceClassInfo;
import org.netbeans.modules.profiler.api.java.SourceMethodInfo;
import org.netbeans.modules.profiler.v2.ProfilerFeature;
import org.netbeans.modules.profiler.v2.ProfilerSession;
import org.netbeans.modules.profiler.v2.features.Bundle;
import org.netbeans.modules.profiler.v2.features.FeatureMode;
import org.netbeans.modules.profiler.v2.features.MethodsFeatureModes;
import org.netbeans.modules.profiler.v2.features.MethodsFeatureUI;
import org.netbeans.modules.profiler.v2.impl.WeakProcessor;
import org.netbeans.modules.profiler.v2.ui.SettingsPanel;
import org.netbeans.modules.profiler.v2.ui.TitledMenuSeparator;
import org.openide.util.Lookup;

final class MethodsFeature
extends ProfilerFeature.Basic {
    private final WeakProcessor processor;
    private FeatureMode currentMode;
    private FeatureMode appliedMode;
    private MethodsFeatureModes.AllClassesMode allClassesMode;
    private MethodsFeatureModes.ProjectClassesMode projectClassesMode;
    private MethodsFeatureModes.SelectedClassesMode selectedClassesMode;
    private MethodsFeatureModes.SelectedMethodsMode selectedMethodsMode;
    private MethodsFeatureModes.CustomClassesMode definedClassesMode;
    private static final String MODE_FLAG = "MODE_FLAG";
    private static final String SETTINGS_FLAG = "SETTINGS_FLAG";
    private JPanel settingsUI;
    private JButton modeButton;
    private JPanel settingsContainer;
    private JButton applyButton;
    private MethodsFeatureUI ui;
    private Runnable refresher;
    private volatile boolean running;
    private MethodsResetter resetter;

    private MethodsFeature(ProfilerSession session) {
        super(Icons.getIcon((String)"ProfilerIcons.Cpu"), Bundle.MethodsFeature_name(), Bundle.MethodsFeature_description(), 12, session);
        assert (!SwingUtilities.isEventDispatchThread());
        Lookup.Provider project = session.getProject();
        String projectName = project == null ? "External Process" : ProjectUtilities.getDisplayName((Lookup.Provider)project);
        this.processor = new WeakProcessor("MethodsFeature Processor for " + projectName);
        this.initModes();
    }

    @Override
    public boolean supportsConfiguration(Lookup configuration) {
        return configuration.lookup(SourceMethodInfo.class) != null || configuration.lookup(SourceClassInfo.class) != null || configuration.lookup(ClientUtils.SourceCodeSelection.class) != null;
    }

    @Override
    public void configure(Lookup configuration) {
        ClientUtils.SourceCodeSelection sel;
        SourceClassInfo classInfo;
        SourceMethodInfo methodInfo = (SourceMethodInfo)configuration.lookup(SourceMethodInfo.class);
        if (methodInfo != null) {
            this.selectMethodForProfiling(methodInfo);
        }
        if ((classInfo = (SourceClassInfo)configuration.lookup(SourceClassInfo.class)) != null) {
            this.selectClassForProfiling(classInfo);
        }
        if ((sel = (ClientUtils.SourceCodeSelection)configuration.lookup(ClientUtils.SourceCodeSelection.class)) != null) {
            this.selectForProfiling(sel);
        }
    }

    private void selectMethodForProfiling(SourceMethodInfo methodInfo) {
        this.selectForProfiling(new ClientUtils.SourceCodeSelection(methodInfo.getClassName(), methodInfo.getName(), methodInfo.getSignature()));
    }

    private void selectClassForProfiling(SourceClassInfo classInfo) {
        this.selectForProfiling(new ClientUtils.SourceCodeSelection(classInfo.getQualifiedName(), "*", null));
    }

    private void selectForProfiling(ClientUtils.SourceCodeSelection sel) {
        if ("*".equals(sel.getMethodName())) {
            this.selectedClassesMode.getSelection().add(sel);
        } else {
            this.selectedMethodsMode.getSelection().add(sel);
        }
    }

    private void initModes() {
        this.allClassesMode = new MethodsFeatureModes.AllClassesMode(){

            @Override
            String readFlag(String flag, String defaultValue) {
                return MethodsFeature.this.readFlag(this.getID() + "_" + flag, defaultValue);
            }

            @Override
            void storeFlag(String flag, String value) {
                MethodsFeature.this.storeFlag(this.getID() + "_" + flag, value);
            }

            @Override
            void settingsChanged() {
                MethodsFeature.this.settingsChanged();
            }
        };
        this.allClassesMode.initialize();
        if (this.getSession().getProject() != null) {
            this.projectClassesMode = new MethodsFeatureModes.ProjectClassesMode(){

                @Override
                String readFlag(String flag, String defaultValue) {
                    return MethodsFeature.this.readFlag(this.getID() + "_" + flag, defaultValue);
                }

                @Override
                void storeFlag(String flag, String value) {
                    MethodsFeature.this.storeFlag(this.getID() + "_" + flag, value);
                }

                @Override
                void settingsChanged() {
                    MethodsFeature.this.settingsChanged();
                }

                @Override
                Lookup.Provider getProject() {
                    return MethodsFeature.this.getSession().getProject();
                }
            };
        }
        if (this.projectClassesMode != null) {
            this.projectClassesMode.initialize();
        }
        this.selectedClassesMode = new MethodsFeatureModes.SelectedClassesMode(){

            @Override
            String readFlag(String flag, String defaultValue) {
                return MethodsFeature.this.readFlag(this.getID() + "_" + flag, defaultValue);
            }

            @Override
            void storeFlag(String flag, String value) {
                MethodsFeature.this.storeFlag(this.getID() + "_" + flag, value);
            }

            @Override
            ProfilerSession getSession() {
                return MethodsFeature.this.getSession();
            }

            @Override
            void selectForProfiling(Collection<SourceClassInfo> classInfos) {
                for (SourceClassInfo classInfo : classInfos) {
                    MethodsFeature.this.selectClassForProfiling(classInfo);
                }
            }

            @Override
            void settingsChanged() {
                MethodsFeature.this.settingsChanged();
            }

            @Override
            void selectionChanging() {
                MethodsFeature.this.setMode(this);
                MethodsFeature.this.getSettingsUI().setVisible(true);
            }

            @Override
            void selectionChanged() {
                MethodsFeature.this.selectionChanged();
            }
        };
        this.selectedClassesMode.initialize();
        this.selectedMethodsMode = new MethodsFeatureModes.SelectedMethodsMode(){

            @Override
            String readFlag(String flag, String defaultValue) {
                return MethodsFeature.this.readFlag(this.getID() + "_" + flag, defaultValue);
            }

            @Override
            void storeFlag(String flag, String value) {
                MethodsFeature.this.storeFlag(this.getID() + "_" + flag, value);
            }

            @Override
            ProfilerSession getSession() {
                return MethodsFeature.this.getSession();
            }

            @Override
            void selectForProfiling(Collection<SourceMethodInfo> methodInfos) {
                for (SourceMethodInfo methodInfo : methodInfos) {
                    MethodsFeature.this.selectMethodForProfiling(methodInfo);
                }
            }

            @Override
            void settingsChanged() {
                MethodsFeature.this.settingsChanged();
            }

            @Override
            void selectionChanging() {
                MethodsFeature.this.setMode(this);
                MethodsFeature.this.getSettingsUI().setVisible(true);
            }

            @Override
            void selectionChanged() {
                MethodsFeature.this.selectionChanged();
                if (MethodsFeature.this.ui != null && MethodsFeature.this.ui.hasResultsUI()) {
                    MethodsFeature.this.ui.getResultsUI().repaint();
                }
            }
        };
        this.selectedMethodsMode.initialize();
        if (ProfilerIDESettings.getInstance().getEnableExpertSettings()) {
            this.definedClassesMode = new MethodsFeatureModes.CustomClassesMode(){

                @Override
                String readFlag(String flag, String defaultValue) {
                    return MethodsFeature.this.readFlag(this.getID() + "_" + flag, defaultValue);
                }

                @Override
                void storeFlag(String flag, String value) {
                    MethodsFeature.this.storeFlag(this.getID() + "_" + flag, value);
                }

                @Override
                void settingsChanged() {
                    MethodsFeature.this.settingsChanged();
                }
            };
        }
        if (this.definedClassesMode != null) {
            this.definedClassesMode.initialize();
        }
        String _currentMode = this.readFlag(MODE_FLAG, this.allClassesMode.getID());
        this.currentMode = this.projectClassesMode != null && _currentMode.equals(this.projectClassesMode.getID()) ? this.projectClassesMode : (_currentMode.equals(this.selectedClassesMode.getID()) ? this.selectedClassesMode : (_currentMode.equals(this.selectedMethodsMode.getID()) ? this.selectedMethodsMode : (this.definedClassesMode != null && _currentMode.equals(this.definedClassesMode.getID()) ? this.definedClassesMode : this.allClassesMode)));
        this.appliedMode = this.currentMode;
    }

    private void saveMode() {
        this.storeFlag(MODE_FLAG, this.currentMode.getID());
    }

    private void setMode(FeatureMode newMode) {
        if (this.currentMode == newMode) {
            return;
        }
        this.currentMode = newMode;
        this.modeChanged();
    }

    private void confirmMode() {
        this.appliedMode = this.currentMode;
    }

    private void modeChanged() {
        this.updateModeName();
        this.updateModeUI();
        this.configurationChanged();
        this.saveMode();
    }

    @Override
    public boolean supportsSettings(ProfilingSettings psettings) {
        return !ProfilingSettings.isMemorySettings((ProfilingSettings)psettings) && !ProfilingSettings.isJDBCSettings((ProfilingSettings)psettings);
    }

    @Override
    public void configureSettings(ProfilingSettings psettings) {
        this.currentMode.configureSettings(psettings);
    }

    @Override
    public boolean currentSettingsValid() {
        return this.currentMode.currentSettingsValid();
    }

    private void submitChanges() {
        this.confirmMode();
        this.confirmSettings();
        this.fireChange();
    }

    private boolean pendingChanges() {
        if (this.appliedMode != this.currentMode) {
            return true;
        }
        return this.currentMode.pendingChanges();
    }

    private void configurationChanged() {
        assert (this.isActivated());
        ProfilerSession session = this.getSession();
        if (!session.inProgress()) {
            this.submitChanges();
        } else {
            this.updateApplyButton(session.getState());
        }
    }

    private void confirmSettings() {
        this.currentMode.confirmSettings();
    }

    private void confirmAllSettings() {
        if (this.allClassesMode != null) {
            this.allClassesMode.confirmSettings();
        }
        if (this.projectClassesMode != null) {
            this.projectClassesMode.confirmSettings();
        }
        if (this.selectedClassesMode != null) {
            this.selectedClassesMode.confirmSettings();
        }
        if (this.selectedMethodsMode != null) {
            this.selectedMethodsMode.confirmSettings();
        }
        if (this.definedClassesMode != null) {
            this.definedClassesMode.confirmSettings();
        }
    }

    private void settingsChanged() {
        this.configurationChanged();
    }

    private void selectionChanged() {
        this.configurationChanged();
    }

    @Override
    public JPanel getSettingsUI() {
        if (this.settingsUI == null) {
            this.settingsUI = new JPanel(new GridBagLayout()){

                @Override
                public void setVisible(boolean visible) {
                    if (visible && this.getComponentCount() == 0) {
                        MethodsFeature.this.populateSettingsUI();
                    }
                    super.setVisible(visible);
                    MethodsFeature.this.storeFlag(MethodsFeature.SETTINGS_FLAG, visible ? Boolean.TRUE.toString() : null);
                }

                @Override
                public Dimension getPreferredSize() {
                    if (this.getComponentCount() == 0) {
                        return new Dimension();
                    }
                    return super.getPreferredSize();
                }
            };
            String _vis = this.readFlag(SETTINGS_FLAG, null);
            boolean vis = _vis == null ? false : Boolean.parseBoolean(_vis);
            this.settingsUI.setVisible(vis || this.currentMode != this.allClassesMode);
        }
        return this.settingsUI;
    }

    private void populateSettingsUI() {
        this.settingsUI.setOpaque(false);
        this.settingsUI.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        SettingsPanel profilePanel = new SettingsPanel();
        profilePanel.add(new JLabel(Bundle.ObjectsFeature_profileMode()));
        profilePanel.add(Box.createHorizontalStrut(5));
        this.modeButton = new PopupButton(this.currentMode.getName()){

            protected void populatePopup(JPopupMenu popup) {
                popup.add(new TitledMenuSeparator(Bundle.ObjectsFeature_samplingModes()));
                popup.add(new JRadioButtonMenuItem(MethodsFeature.this.allClassesMode.getName(), MethodsFeature.this.currentMode == MethodsFeature.this.allClassesMode){

                    @Override
                    protected void fireActionPerformed(ActionEvent e) {
                        MethodsFeature.this.setMode(MethodsFeature.this.allClassesMode);
                    }
                });
                if (MethodsFeature.this.projectClassesMode != null) {
                    popup.add(new JRadioButtonMenuItem(MethodsFeature.this.projectClassesMode.getName(), MethodsFeature.this.currentMode == MethodsFeature.this.projectClassesMode){

                        @Override
                        protected void fireActionPerformed(ActionEvent e) {
                            MethodsFeature.this.setMode(MethodsFeature.this.projectClassesMode);
                        }
                    });
                }
                popup.add(new TitledMenuSeparator(Bundle.ObjectsFeature_instrModes()));
                popup.add(new JRadioButtonMenuItem(MethodsFeature.this.selectedClassesMode.getName(), MethodsFeature.this.currentMode == MethodsFeature.this.selectedClassesMode){

                    @Override
                    protected void fireActionPerformed(ActionEvent e) {
                        MethodsFeature.this.setMode(MethodsFeature.this.selectedClassesMode);
                    }
                });
                popup.add(new JRadioButtonMenuItem(MethodsFeature.this.selectedMethodsMode.getName(), MethodsFeature.this.currentMode == MethodsFeature.this.selectedMethodsMode){

                    @Override
                    protected void fireActionPerformed(ActionEvent e) {
                        MethodsFeature.this.setMode(MethodsFeature.this.selectedMethodsMode);
                    }
                });
                if (MethodsFeature.this.definedClassesMode != null) {
                    popup.add(new JRadioButtonMenuItem(MethodsFeature.this.definedClassesMode.getName(), MethodsFeature.this.currentMode == MethodsFeature.this.definedClassesMode){

                        @Override
                        protected void fireActionPerformed(ActionEvent e) {
                            MethodsFeature.this.setMode(MethodsFeature.this.definedClassesMode);
                        }
                    });
                }
            }
        };
        profilePanel.add(this.modeButton);
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 0;
        c.insets = new Insets(0, 0, 0, 0);
        c.anchor = 18;
        this.settingsUI.add((Component)profilePanel, c);
        this.settingsContainer = new JPanel(new BorderLayout());
        this.settingsContainer.setOpaque(false);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 3;
        c.insets = new Insets(0, 10, 0, 0);
        c.anchor = 18;
        this.settingsUI.add((Component)this.settingsContainer, c);
        SettingsPanel buttonsPanel = new SettingsPanel();
        final Component space = Box.createHorizontalStrut(10);
        buttonsPanel.add(space);
        this.applyButton = new SmallButton(Bundle.ObjectsFeature_applyButton()){

            protected void fireActionPerformed(ActionEvent e) {
                MethodsFeature.this.stopResults();
                MethodsFeature.this.resetResults();
                MethodsFeature.this.submitChanges();
                MethodsFeature.this.unpauseResults();
            }

            public void setVisible(boolean visible) {
                super.setVisible(visible);
                space.setVisible(visible);
            }
        };
        buttonsPanel.add(this.applyButton);
        c = new GridBagConstraints();
        c.gridx = 2;
        c.gridy = 0;
        c.fill = 0;
        c.insets = new Insets(0, 0, 0, 0);
        c.anchor = 12;
        this.settingsUI.add((Component)buttonsPanel, c);
        this.updateModeUI();
        this.updateApplyButton(this.getSession().getState());
    }

    private void updateModeName() {
        if (this.modeButton != null) {
            this.modeButton.setText(this.currentMode.getName());
        }
    }

    private void updateModeUI() {
        if (this.settingsContainer != null) {
            this.settingsContainer.removeAll();
            JComponent modeUI = this.currentMode.getUI();
            if (modeUI != null) {
                this.settingsContainer.add(modeUI);
            }
            this.settingsContainer.doLayout();
            this.settingsContainer.repaint();
        }
    }

    private void updateApplyButton(int state) {
        if (this.applyButton != null) {
            boolean visible = state != 1;
            this.applyButton.setVisible(visible);
            if (visible) {
                this.applyButton.setEnabled(this.currentSettingsValid() && this.pendingChanges());
            }
        }
    }

    @Override
    public JPanel getResultsUI() {
        return this.getUI().getResultsUI();
    }

    @Override
    public ProfilerToolbar getToolbar() {
        return this.getUI().getToolbar();
    }

    private MethodsFeatureUI getUI() {
        if (this.ui == null) {
            this.ui = new MethodsFeatureUI(){

                @Override
                Set<ClientUtils.SourceCodeSelection> getClassesSelection() {
                    return MethodsFeature.this.selectedClassesMode.getSelection();
                }

                @Override
                Set<ClientUtils.SourceCodeSelection> getMethodsSelection() {
                    return MethodsFeature.this.selectedMethodsMode.getSelection();
                }

                @Override
                void selectForProfiling(ClientUtils.SourceCodeSelection value) {
                    MethodsFeature.this.selectForProfiling(value);
                }

                @Override
                Lookup.Provider getProject() {
                    return MethodsFeature.this.getSession().getProject();
                }

                @Override
                ProfilerClient getProfilerClient() {
                    Profiler profiler = MethodsFeature.this.getSession().getProfiler();
                    return profiler.getTargetAppRunner().getProfilerClient();
                }

                @Override
                int getSessionState() {
                    return MethodsFeature.this.getSessionState();
                }

                @Override
                void refreshResults() {
                    MethodsFeature.this.refreshResults();
                }
            };
        }
        return this.ui;
    }

    private void startResults() {
        if (this.running) {
            return;
        }
        this.running = true;
        this.refresher = new Runnable(){

            @Override
            public void run() {
                if (MethodsFeature.this.running) {
                    MethodsFeature.this.refreshView();
                    MethodsFeature.this.refreshResults(1500);
                }
            }
        };
        this.refreshResults(1000);
    }

    private void refreshView() {
        if (this.ui != null && ResultsManager.getDefault().resultsAvailable() || this.getSession().getProfilingSettings().getCPUProfilingType() == 2) {
            try {
                this.ui.refreshData();
            }
            catch (ClientUtils.TargetAppOrVMTerminated ex) {
                this.stopResults();
            }
        }
    }

    private void refreshResults() {
        if (this.running) {
            this.processor.post(new Runnable(){

                @Override
                public void run() {
                    if (MethodsFeature.this.ui != null) {
                        MethodsFeature.this.ui.setForceRefresh();
                    }
                    MethodsFeature.this.refreshView();
                }
            });
        }
    }

    private void refreshResults(int delay) {
        if (this.running && this.refresher != null) {
            this.processor.post(this.refresher, delay);
        }
    }

    private void resetResults() {
        if (this.ui != null) {
            this.ui.resetData();
        }
    }

    private void stopResults() {
        if (this.refresher != null) {
            this.running = false;
            this.refresher = null;
        }
    }

    private void unpauseResults() {
        if (this.ui != null) {
            this.ui.resetPause();
        }
    }

    @Override
    public void notifyActivated() {
        this.resetResults();
        this.resetter = (MethodsResetter)Lookup.getDefault().lookup(MethodsResetter.class);
        this.resetter.controller = this;
        if (this.getSession().inProgress() && !this.currentMode.currentSettingsValid()) {
            final String oldMode = this.currentMode.getName();
            final String newMode = this.allClassesMode.getName();
            this.setMode(this.allClassesMode);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ProfilerDialogs.displayInfo((String)Bundle.MethodsFeature_modeReset(oldMode, newMode));
                }
            });
        }
    }

    @Override
    public void notifyDeactivated() {
        this.resetResults();
        if (this.resetter != null) {
            this.resetter.controller = null;
            this.resetter = null;
        }
        if (this.ui != null) {
            this.ui.cleanup();
            this.ui = null;
        }
        this.settingsUI = null;
    }

    @Override
    protected void profilingStateChanged(int oldState, int newState) {
        if (newState == 1 || newState == 128) {
            this.stopResults();
            this.confirmAllSettings();
        } else if (this.isActivated() && newState == 4) {
            this.startResults();
        } else if (newState == 2) {
            this.resetResults();
            this.unpauseResults();
        }
        if (this.ui != null) {
            this.ui.sessionStateChanged(this.getSessionState());
        }
        this.updateApplyButton(newState);
    }

    public static final class MethodsResetter
    implements ResultsListener {
        private MethodsFeature controller;

        @Override
        public void resultsAvailable() {
        }

        @Override
        public void resultsReset() {
            if (this.controller != null && this.controller.ui != null) {
                this.controller.ui.resetData();
            }
        }
    }

    public static final class Provider
    extends ProfilerFeature.Provider {
        @Override
        public ProfilerFeature getFeature(ProfilerSession session) {
            return new MethodsFeature(session);
        }
    }
}

