/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.twig.editor.actions;

import java.awt.event.ActionEvent;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseAction;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.csl.api.CslActions;
import org.netbeans.modules.php.twig.editor.lexer.TwigLexerUtils;
import org.netbeans.modules.php.twig.editor.lexer.TwigTopTokenId;
import org.netbeans.modules.php.twig.editor.ui.options.TwigOptions;

public class ToggleBlockCommentAction
extends BaseAction {
    static final long serialVersionUID = -1L;
    private static final Logger LOGGER = Logger.getLogger(ToggleBlockCommentAction.class.getName());
    private static final String FORCE_COMMENT = "force-comment";
    private static final String FORCE_UNCOMMENT = "force-uncomment";

    public ToggleBlockCommentAction() {
        super("toggle-comment");
    }

    public void actionPerformed(ActionEvent evt, JTextComponent target) {
        final AtomicBoolean processedHere = new AtomicBoolean(false);
        if (target != null) {
            if (!(target.isEditable() && target.isEnabled() && target.getDocument() instanceof BaseDocument)) {
                target.getToolkit().beep();
                return;
            }
            final Positions positions = Positions.create(target);
            final BaseDocument doc = (BaseDocument)target.getDocument();
            doc.runAtomic(new Runnable(){

                @Override
                public void run() {
                    ToggleBlockCommentAction.this.performCustomAction(doc, positions, processedHere);
                }
            });
            if (!processedHere.get()) {
                this.performDefaultAction(evt, target);
            }
        }
    }

    private void performCustomAction(BaseDocument baseDocument, Positions positions, AtomicBoolean processedHere) {
        ToggleCommentType toggleCommentType = TwigOptions.getInstance().getToggleCommentType();
        try {
            toggleCommentType.comment(baseDocument, positions, processedHere);
        }
        catch (BadLocationException ex) {
            LOGGER.log(Level.WARNING, null, ex);
        }
    }

    private void performDefaultAction(ActionEvent evt, JTextComponent target) {
        BaseAction action = (BaseAction)CslActions.createToggleBlockCommentAction();
        if (this.getValue(FORCE_COMMENT) != null) {
            action.putValue(FORCE_COMMENT, this.getValue(FORCE_COMMENT));
        }
        if (this.getValue(FORCE_UNCOMMENT) != null) {
            action.putValue(FORCE_UNCOMMENT, this.getValue(FORCE_UNCOMMENT));
        }
        action.actionPerformed(evt, target);
    }

    private static final class Positions {
        private final int start;
        private final int end;
        private final boolean isSelection;

        public static Positions create(JTextComponent target) {
            boolean isSelection = Utilities.isSelectionShowing((JTextComponent)target);
            int start = isSelection ? target.getSelectionStart() : target.getCaretPosition();
            int end = isSelection ? target.getSelectionEnd() : target.getCaretPosition();
            return new Positions(start, end, isSelection);
        }

        private Positions(int start, int end, boolean isSelection) {
            this.start = start;
            this.end = end;
            this.isSelection = isSelection;
        }

        public int getStart() {
            return this.start;
        }

        public int getEnd() {
            return this.end;
        }

        public void comment(BaseDocument baseDocument) throws BadLocationException {
            int offsetCommentEnd;
            int offsetCommentStart;
            if (this.isSelection) {
                offsetCommentStart = this.getStart();
                offsetCommentEnd = this.getEnd();
            } else {
                offsetCommentStart = Utilities.getRowStart((BaseDocument)baseDocument, (int)this.getStart());
                offsetCommentEnd = Utilities.getRowEnd((BaseDocument)baseDocument, (int)this.getEnd());
            }
            baseDocument.insertString(offsetCommentStart, "{#", null);
            baseDocument.insertString(offsetCommentEnd + "{#".length(), "#}", null);
        }
    }

    public static abstract class ToggleCommentType
    extends Enum<ToggleCommentType> {
        public static final /* enum */ ToggleCommentType AS_TWIG_EVERYWHERE = new ToggleCommentType(){

            @Override
            void comment(BaseDocument baseDocument, Positions positions, AtomicBoolean processedHere) throws BadLocationException {
                TokenSequence<? extends TwigTopTokenId> ts = TwigLexerUtils.getTwigTokenSequence((Document)baseDocument, positions.getStart());
                Token token = null;
                if (ts != null) {
                    ts.move(positions.getStart());
                    ts.moveNext();
                    token = ts.token();
                    if (token != null && positions.getStart() == ts.offset() && !ToggleCommentType.isInComment((TwigTopTokenId)token.id())) {
                        ts.movePrevious();
                        token = ts.token();
                    }
                }
                if (token != null && ToggleCommentType.isInComment((TwigTopTokenId)token.id())) {
                    this.uncommentToken(ts, baseDocument);
                } else {
                    positions.comment(baseDocument);
                }
                processedHere.set(true);
            }
        };
        public static final /* enum */ ToggleCommentType LANGUAGE_SENSITIVE = new ToggleCommentType(){

            @Override
            void comment(BaseDocument baseDocument, Positions positions, AtomicBoolean processedHere) throws BadLocationException {
                TokenSequence<? extends TwigTopTokenId> ts = TwigLexerUtils.getTwigTokenSequence((Document)baseDocument, positions.getStart());
                if (ts == null) {
                    processedHere.set(false);
                    return;
                }
                ts.move(positions.getStart());
                ts.moveNext();
                Token token = ts.token();
                if (token != null && positions.getStart() == ts.offset() && token.id() == TwigTopTokenId.T_HTML) {
                    ts.movePrevious();
                    token = ts.token();
                }
                if (token != null && token.id() == TwigTopTokenId.T_HTML) {
                    processedHere.set(false);
                    return;
                }
                if (token != null && ToggleCommentType.isInComment((TwigTopTokenId)token.id())) {
                    this.uncommentToken(ts, baseDocument);
                } else {
                    TokenInsertWrapper startTokenWraper = ToggleCommentType.findBackward((TokenSequence<? extends TwigTopTokenId>)ts, Arrays.asList(TwigTopTokenId.T_TWIG_BLOCK_START, TwigTopTokenId.T_TWIG_VAR_START));
                    TokenInsertWrapper endTokenWrapper = ToggleCommentType.findForward((TokenSequence<? extends TwigTopTokenId>)ts, Arrays.asList(TwigTopTokenId.T_TWIG_BLOCK_END, TwigTopTokenId.T_TWIG_VAR_END));
                    endTokenWrapper.insertAfter(baseDocument);
                    startTokenWraper.insertBefore(baseDocument);
                }
                processedHere.set(true);
            }
        };
        private static final /* synthetic */ ToggleCommentType[] $VALUES;

        public static ToggleCommentType[] values() {
            return (ToggleCommentType[])$VALUES.clone();
        }

        public static ToggleCommentType valueOf(String name) {
            return Enum.valueOf(ToggleCommentType.class, name);
        }

        abstract void comment(BaseDocument var1, Positions var2, AtomicBoolean var3) throws BadLocationException;

        protected void uncommentToken(TokenSequence<? extends TwigTopTokenId> ts, BaseDocument baseDocument) throws BadLocationException {
            int start = ts.offset();
            int end = ts.offset() + ts.token().text().length() - "{#".length() - "#}".length();
            baseDocument.remove(start, "{#".length());
            baseDocument.remove(end, "#}".length());
        }

        private static boolean isInComment(TwigTopTokenId tokenId) {
            return tokenId == TwigTopTokenId.T_TWIG_COMMENT;
        }

        private static TokenInsertWrapper findBackward(TokenSequence<? extends TwigTopTokenId> ts, List<TwigTopTokenId> tokenIds) {
            assert (ts != null);
            assert (tokenIds != null);
            TokenInsertWrapper result = TokenInsertWrapper.NONE;
            if (ts.moveNext() || ts.movePrevious()) {
                int originalOffset = ts.offset();
                while (ts.movePrevious()) {
                    Token token = ts.token();
                    if (token == null || !tokenIds.contains(token.id())) continue;
                    result = new TokenInsertWrapperImpl(token, ts.offset());
                    break;
                }
                ts.move(originalOffset);
            }
            return result;
        }

        private static TokenInsertWrapper findForward(TokenSequence<? extends TwigTopTokenId> ts, List<TwigTopTokenId> tokenIds) {
            assert (ts != null);
            assert (tokenIds != null);
            TokenInsertWrapper result = TokenInsertWrapper.NONE;
            ts.moveNext();
            ts.movePrevious();
            int originalOffset = ts.offset();
            Token token = ts.token();
            if (token != null && tokenIds.contains(token.id())) {
                result = new TokenInsertWrapperImpl(token, ts.offset());
            } else {
                while (ts.moveNext()) {
                    token = ts.token();
                    if (token == null || !tokenIds.contains(token.id())) continue;
                    result = new TokenInsertWrapperImpl(token, ts.offset());
                    break;
                }
            }
            ts.move(originalOffset);
            return result;
        }

        private static /* synthetic */ ToggleCommentType[] $values() {
            return new ToggleCommentType[]{AS_TWIG_EVERYWHERE, LANGUAGE_SENSITIVE};
        }

        static {
            $VALUES = ToggleCommentType.$values();
        }
    }

    private static final class TokenInsertWrapperImpl
    implements TokenInsertWrapper {
        private final Token<? extends TwigTopTokenId> token;
        private final int offset;

        private TokenInsertWrapperImpl(Token<? extends TwigTopTokenId> token, int offset) {
            this.token = token;
            this.offset = offset;
        }

        @Override
        public void insertBefore(BaseDocument baseDocument) throws BadLocationException {
            baseDocument.insertString(this.offset, "{#", null);
        }

        @Override
        public void insertAfter(BaseDocument baseDocument) throws BadLocationException {
            baseDocument.insertString(this.offset + this.token.text().length(), "#}", null);
        }
    }

    private static interface TokenInsertWrapper {
        public static final TokenInsertWrapper NONE = new TokenInsertWrapper(){

            @Override
            public void insertBefore(BaseDocument baseDocument) throws BadLocationException {
            }

            @Override
            public void insertAfter(BaseDocument baseDocument) throws BadLocationException {
            }
        };

        public void insertBefore(BaseDocument var1) throws BadLocationException;

        public void insertAfter(BaseDocument var1) throws BadLocationException;
    }
}

