/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.twig.editor.ui.options;

import java.util.EventListener;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.openide.util.WeakListeners;

public final class OptionsUtils {
    private static final AtomicBoolean INITED = new AtomicBoolean(false);
    public static final String AUTO_COMPLETION_SMART_QUOTES = "twigAutoCompletionSmartQuotes";
    public static final String AUTO_COMPLETION_SMART_DELIMITERS = "twigAutoCompletionSmartDelimiters";
    private static Boolean autoCompletionSmartQuotes = null;
    private static Boolean autoCompletionSmartDelimiters = null;
    public static final boolean AUTO_COMPLETION_SMART_QUOTES_DEFAULT = true;
    public static final boolean AUTO_COMPLETION_SMART_DELIMITERS_DEFAULT = true;
    private static Preferences PREFERENCES;
    private static final PreferenceChangeListener PREFERENCES_TRACKER;

    private OptionsUtils() {
    }

    public static boolean autoCompletionSmartQuotes() {
        OptionsUtils.lazyInit();
        assert (autoCompletionSmartQuotes != null);
        return autoCompletionSmartQuotes;
    }

    public static boolean autoCompletionSmartDelimiters() {
        OptionsUtils.lazyInit();
        assert (autoCompletionSmartDelimiters != null);
        return autoCompletionSmartDelimiters;
    }

    private static void lazyInit() {
        if (INITED.compareAndSet(false, true)) {
            PREFERENCES = (Preferences)MimeLookup.getLookup((String)"text/x-twig").lookup(Preferences.class);
            PREFERENCES.addPreferenceChangeListener((PreferenceChangeListener)WeakListeners.create(PreferenceChangeListener.class, (EventListener)PREFERENCES_TRACKER, (Object)PREFERENCES));
            PREFERENCES_TRACKER.preferenceChange(null);
        }
    }

    static {
        PREFERENCES_TRACKER = new PreferenceChangeListener(){

            @Override
            public void preferenceChange(PreferenceChangeEvent evt) {
                String settingName;
                String string = settingName = evt == null ? null : evt.getKey();
                if (settingName == null || OptionsUtils.AUTO_COMPLETION_SMART_QUOTES.equals(settingName)) {
                    autoCompletionSmartQuotes = PREFERENCES.getBoolean(OptionsUtils.AUTO_COMPLETION_SMART_QUOTES, true);
                }
                if (settingName == null || OptionsUtils.AUTO_COMPLETION_SMART_DELIMITERS.equals(settingName)) {
                    autoCompletionSmartDelimiters = PREFERENCES.getBoolean(OptionsUtils.AUTO_COMPLETION_SMART_DELIMITERS, true);
                }
            }
        };
    }
}

