/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.smarty.ui.options;

import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.php.smarty.SmartyFramework;
import org.netbeans.modules.php.smarty.ui.options.SmartyOptions;
import org.openide.awt.HtmlBrowser;
import org.openide.awt.Mnemonics;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class SmartyOptionsPanel
extends JPanel {
    private static final long serialVersionUID = -1384644114740L;
    private final transient ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private static final int MAX_SCANNING_DEPTH = 3;
    private static final String LINK_QUICK_START = "http://www.smarty.net/quick_install";
    private boolean firstOpening = true;
    private JRadioButton asSmartyRadioButton;
    private JLabel closeDelimiterLabel;
    private JTextField closeDelimiterTextField;
    private JLabel editorSettingsLabel;
    private JLabel errorLabel;
    private JLabel installationInfoLabel;
    private JSeparator jSeparator1;
    private JLabel learnMoreLabel;
    private JLabel openDelimiterLabel;
    private JTextField openDelimiterTextField;
    private JRadioButton perContextRadioButton;
    private JComboBox smartyVersionComboBox;
    private JLabel smartyVersionLabel;
    private ButtonGroup toggleCommentButtonGroup;
    private JLabel toggleCommentLable;

    public SmartyOptionsPanel() {
        this.initComponents();
        this.initSmartyVersionsComboBox();
        this.errorLabel.setText(" ");
        this.setSmartyVersion(SmartyOptions.getInstance().getSmartyVersion());
        this.setOpenDelimiter(SmartyOptions.getInstance().getDefaultOpenDelimiter());
        this.setCloseDelimiter(SmartyOptions.getInstance().getDefaultCloseDelimiter());
        this.setToggleCommentOption(SmartyOptions.getInstance().getToggleCommentOption());
        this.smartyVersionComboBox.addActionListener(new SmartyActionListener());
        this.openDelimiterTextField.getDocument().addDocumentListener(new SmartyDocumentListener());
        this.closeDelimiterTextField.getDocument().addDocumentListener(new SmartyDocumentListener());
    }

    public String getCloseDelimiter() {
        return this.closeDelimiterTextField.getText();
    }

    public final void setCloseDelimiter(String closeDelimiter) {
        this.closeDelimiterTextField.setText(closeDelimiter);
    }

    public String getOpenDelimiter() {
        return this.openDelimiterTextField.getText();
    }

    public final void setOpenDelimiter(String openDelimiter) {
        this.openDelimiterTextField.setText(openDelimiter);
    }

    public final void setSmartyVersion(SmartyFramework.Version version) {
        this.smartyVersionComboBox.setSelectedItem((Object)version);
    }

    public SmartyFramework.Version getSmartyVersion() {
        return (SmartyFramework.Version)((Object)this.smartyVersionComboBox.getSelectedItem());
    }

    private void setToggleCommentOption(SmartyFramework.ToggleCommentOption toggleCommentOption) {
        if (toggleCommentOption == SmartyFramework.ToggleCommentOption.SMARTY) {
            this.asSmartyRadioButton.setSelected(true);
        } else {
            this.perContextRadioButton.setSelected(true);
        }
    }

    private SmartyFramework.ToggleCommentOption getToggleCommentOption() {
        if (this.asSmartyRadioButton.isSelected()) {
            return SmartyFramework.ToggleCommentOption.SMARTY;
        }
        return SmartyFramework.ToggleCommentOption.CONTEXT;
    }

    public void setError(String message) {
        this.errorLabel.setText(" ");
        this.errorLabel.setForeground(UIManager.getColor("nb.errorForeground"));
        this.errorLabel.setText(message);
    }

    public void setWarning(String message) {
        this.errorLabel.setText(" ");
        this.errorLabel.setForeground(UIManager.getColor("nb.warningForeground"));
        this.errorLabel.setText(message);
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeSupport.removeChangeListener(listener);
    }

    void fireChange() {
        this.changeSupport.fireChange();
    }

    protected void update() {
        if (this.firstOpening || !this.changed()) {
            this.firstOpening = false;
            this.setSmartyVersion(this.getOptions().getSmartyVersion());
            this.setOpenDelimiter(this.getOptions().getDefaultOpenDelimiter());
            this.setCloseDelimiter(this.getOptions().getDefaultCloseDelimiter());
            this.setToggleCommentOption(this.getOptions().getToggleCommentOption());
        }
    }

    protected void applyChanges() {
        this.getOptions().setSmartyVersion(this.getSmartyVersion());
        this.getOptions().setDefaultOpenDelimiter(this.getOpenDelimiter());
        this.getOptions().setDefaultCloseDelimiter(this.getCloseDelimiter());
        this.getOptions().setToggleCommentOption(this.getToggleCommentOption());
    }

    protected void cancel() {
        if (this.changed()) {
            this.setSmartyVersion(this.getOptions().getSmartyVersion());
            this.setOpenDelimiter(this.getOptions().getDefaultOpenDelimiter());
            this.setCloseDelimiter(this.getOptions().getDefaultCloseDelimiter());
            this.setToggleCommentOption(this.getOptions().getToggleCommentOption());
        }
    }

    protected boolean valid() {
        if (this.getOpenDelimiter().equals("") || this.getCloseDelimiter().equals("")) {
            this.setError(NbBundle.getMessage(SmartyOptionsPanel.class, (String)"WRN_EmptyDelimiterFields"));
            return false;
        }
        this.setWarning(" ");
        return true;
    }

    protected boolean changed() {
        return !this.getOptions().getSmartyVersion().equals((Object)this.getSmartyVersion()) || !this.getOptions().getDefaultOpenDelimiter().equals(this.getOpenDelimiter().trim()) || !this.getOptions().getDefaultCloseDelimiter().equals(this.getCloseDelimiter().trim()) || !this.getOptions().getToggleCommentOption().equals((Object)this.getToggleCommentOption());
    }

    private SmartyOptions getOptions() {
        return SmartyOptions.getInstance();
    }

    private void initComponents() {
        this.toggleCommentButtonGroup = new ButtonGroup();
        this.errorLabel = new JLabel();
        this.learnMoreLabel = new JLabel();
        this.installationInfoLabel = new JLabel();
        this.editorSettingsLabel = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.smartyVersionLabel = new JLabel();
        this.smartyVersionComboBox = new JComboBox();
        this.openDelimiterLabel = new JLabel();
        this.openDelimiterTextField = new JTextField();
        this.closeDelimiterLabel = new JLabel();
        this.closeDelimiterTextField = new JTextField();
        this.toggleCommentLable = new JLabel();
        this.asSmartyRadioButton = new JRadioButton();
        this.perContextRadioButton = new JRadioButton();
        Mnemonics.setLocalizedText((JLabel)this.errorLabel, (String)NbBundle.getMessage(SmartyOptionsPanel.class, (String)"SmartyOptionsPanel.errorLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.learnMoreLabel, (String)NbBundle.getMessage(SmartyOptionsPanel.class, (String)"SmartyOptionsPanel.learnMoreLabel.text"));
        this.learnMoreLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                SmartyOptionsPanel.this.learnMoreLabelMouseEntered(evt);
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                SmartyOptionsPanel.this.learnMoreLabelMousePressed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.installationInfoLabel, (String)NbBundle.getMessage(SmartyOptionsPanel.class, (String)"SmartyOptionsPanel.installationInfoLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.editorSettingsLabel, (String)NbBundle.getMessage(SmartyOptionsPanel.class, (String)"LBL_OptionsEditorPanel"));
        this.smartyVersionLabel.setDisplayedMnemonic('v');
        this.smartyVersionLabel.setLabelFor(this.smartyVersionComboBox);
        Mnemonics.setLocalizedText((JLabel)this.smartyVersionLabel, (String)NbBundle.getMessage(SmartyOptionsPanel.class, (String)"SmartyOptionsPanel.smartyVersionLabel.text"));
        this.openDelimiterLabel.setDisplayedMnemonic('O');
        this.openDelimiterLabel.setLabelFor(this.openDelimiterTextField);
        Mnemonics.setLocalizedText((JLabel)this.openDelimiterLabel, (String)NbBundle.getMessage(SmartyOptionsPanel.class, (String)"SmartyOptionsPanel.openDelimiterLabel.text"));
        this.closeDelimiterLabel.setDisplayedMnemonic('C');
        this.closeDelimiterLabel.setLabelFor(this.closeDelimiterTextField);
        Mnemonics.setLocalizedText((JLabel)this.closeDelimiterLabel, (String)NbBundle.getMessage(SmartyOptionsPanel.class, (String)"SmartyOptionsPanel.closeDelimiterLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.toggleCommentLable, (String)NbBundle.getMessage(SmartyOptionsPanel.class, (String)"SmartyOptionsPanel.toggleCommentLable.text"));
        this.toggleCommentButtonGroup.add(this.asSmartyRadioButton);
        this.asSmartyRadioButton.setMnemonic('a');
        this.asSmartyRadioButton.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.asSmartyRadioButton, (String)NbBundle.getMessage(SmartyOptionsPanel.class, (String)"SmartyOptionsPanel.asSmartyRadioButton.text"));
        this.toggleCommentButtonGroup.add(this.perContextRadioButton);
        this.perContextRadioButton.setMnemonic('l');
        Mnemonics.setLocalizedText((AbstractButton)this.perContextRadioButton, (String)NbBundle.getMessage(SmartyOptionsPanel.class, (String)"SmartyOptionsPanel.perContextRadioButton.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.editorSettingsLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator1)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.errorLabel).addComponent(this.learnMoreLabel, -2, -1, -2).addComponent(this.installationInfoLabel).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.openDelimiterLabel).addComponent(this.smartyVersionLabel).addComponent(this.toggleCommentLable)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.asSmartyRadioButton).addGap(18, 18, 18).addComponent(this.perContextRadioButton, -2, 178, -2)).addGroup(layout.createSequentialGroup().addGap(12, 12, 12).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.smartyVersionComboBox, 0, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.openDelimiterTextField, -2, 50, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.closeDelimiterLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.closeDelimiterTextField, -2, 50, -2))))))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.editorSettingsLabel).addComponent(this.jSeparator1, -2, 10, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.smartyVersionLabel).addComponent(this.smartyVersionComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.openDelimiterLabel).addComponent(this.openDelimiterTextField, -2, -1, -2).addComponent(this.closeDelimiterLabel).addComponent(this.closeDelimiterTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.toggleCommentLable).addComponent(this.asSmartyRadioButton).addComponent(this.perContextRadioButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 248, Short.MAX_VALUE).addComponent(this.installationInfoLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.learnMoreLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.errorLabel)));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SmartyOptionsPanel.class, (String)"SmartyOptionsPanel.AccessibleContext.accessibleDescription"));
    }

    private void learnMoreLabelMouseEntered(MouseEvent evt) {
        evt.getComponent().setCursor(Cursor.getPredefinedCursor(12));
    }

    private void learnMoreLabelMousePressed(MouseEvent evt) {
        try {
            URL url = new URL(LINK_QUICK_START);
            HtmlBrowser.URLDisplayer.getDefault().showURL(url);
        }
        catch (MalformedURLException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void initSmartyVersionsComboBox() {
        for (SmartyFramework.Version version : SmartyFramework.Version.values()) {
            this.smartyVersionComboBox.addItem(version);
        }
    }

    private final class SmartyActionListener
    implements ActionListener {
        private SmartyActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SmartyOptionsPanel.this.fireChange();
        }
    }

    private final class SmartyDocumentListener
    implements DocumentListener {
        private SmartyDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.processUpdate();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.processUpdate();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.processUpdate();
        }

        private void processUpdate() {
            SmartyOptionsPanel.this.fireChange();
        }
    }
}

