/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.wizards;

import java.util.Collections;
import java.util.Set;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import org.netbeans.api.annotations.common.SuppressWarnings;
import org.netbeans.modules.php.project.connections.transfer.TransferFile;
import org.netbeans.modules.php.project.connections.ui.transfer.TransferFilesChooser;
import org.netbeans.modules.php.project.connections.ui.transfer.TransferFilesChooserPanel;
import org.netbeans.modules.php.project.ui.wizards.RemoteConfirmationPanel;
import org.openide.WizardDescriptor;
import org.openide.util.ChangeSupport;
import org.openide.util.NbBundle;

@SuppressWarnings(value={"SE_BAD_FIELD_STORE"})
public final class RemoteConfirmationPanelVisual
extends JPanel {
    private static final long serialVersionUID = 3753241413078222434L;
    private static final int STEP_INDEX = 2;
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private final TransferFilesChooserPanel.TransferFilesChangeListener transferFilesChangeListener;
    private volatile TransferFilesChooserPanel transferPanel;
    private State state = null;
    private JLabel downloadInfoLabel;
    private JPanel filesPanel;
    private JLabel statusLabel;
    private JLabel uploadInfoLabel;

    public RemoteConfirmationPanelVisual(RemoteConfirmationPanel wizardPanel, WizardDescriptor descriptor) {
        assert (SwingUtilities.isEventDispatchThread()) : "Must be run in EDT";
        assert (wizardPanel != null);
        assert (descriptor != null);
        this.setName(wizardPanel.getSteps()[2]);
        this.putClientProperty("WizardPanel_contentSelectedIndex", 2);
        this.putClientProperty("WizardPanel_contentData", wizardPanel.getSteps());
        this.initComponents();
        this.setFetchingFiles();
        this.uploadInfoLabel.setText(NbBundle.getMessage(RemoteConfirmationPanelVisual.class, (String)"TXT_UploadInfo"));
        this.transferFilesChangeListener = new TransferFilesChooserPanel.TransferFilesChangeListener(){

            @Override
            public void selectedFilesChanged() {
                RemoteConfirmationPanelVisual.this.changeSupport.fireChange();
            }

            @Override
            public void filterChanged() {
            }
        };
    }

    public void addRemoteConfirmationListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    public void removeRemoteConfirmationListener(ChangeListener listener) {
        this.changeSupport.removeChangeListener(listener);
    }

    public void setRemoteFiles(Set<TransferFile> remoteFiles) {
        assert (SwingUtilities.isEventDispatchThread()) : "Must be run in EDT";
        assert (remoteFiles != null);
        this.state = State.FILES;
        this.transferPanel = TransferFilesChooser.forDownload(remoteFiles).getEmbeddablePanel();
        this.transferPanel.addChangeListener(this.transferFilesChangeListener);
        this.filesPanel.removeAll();
        this.filesPanel.add(this.transferPanel);
        this.statusLabel.setText(NbBundle.getMessage(RemoteConfirmationPanelVisual.class, (String)"LBL_Confirmation"));
        this.setState(true);
    }

    public void setNoFiles(String reason) {
        assert (SwingUtilities.isEventDispatchThread()) : "Must be run in EDT";
        this.state = State.NO_FILES;
        this.resetTransferFilter();
        this.statusLabel.setText(NbBundle.getMessage(RemoteConfirmationPanelVisual.class, (String)"LBL_NoFiles", (Object)reason));
        this.setState(false);
    }

    public void setFetchingFiles() {
        assert (SwingUtilities.isEventDispatchThread()) : "Must be run in EDT";
        this.state = State.FETCHING;
        this.resetTransferFilter();
        this.statusLabel.setText(NbBundle.getMessage(RemoteConfirmationPanelVisual.class, (String)"LBL_FetchingRemoteFiles"));
        this.setState(false);
    }

    public Set<TransferFile> getRemoteFiles() {
        if (this.transferPanel == null) {
            return Collections.emptySet();
        }
        return this.transferPanel.getSelectedFiles();
    }

    State getState() {
        assert (SwingUtilities.isEventDispatchThread()) : "Must be run in EDT";
        return this.state;
    }

    private void setState(boolean enabled) {
        this.downloadInfoLabel.setVisible(enabled);
        this.uploadInfoLabel.setVisible(enabled);
        this.filesPanel.setVisible(enabled);
    }

    private void resetTransferFilter() {
        if (this.transferPanel != null) {
            this.transferPanel.removeChangeListener(this.transferFilesChangeListener);
        }
        this.transferPanel = null;
    }

    private void initComponents() {
        this.statusLabel = new JLabel();
        this.downloadInfoLabel = new JLabel();
        this.uploadInfoLabel = new JLabel();
        this.filesPanel = new JPanel();
        this.setFocusTraversalPolicy(null);
        this.statusLabel.setFont(this.statusLabel.getFont().deriveFont(this.statusLabel.getFont().getStyle() | 1));
        this.statusLabel.setText("DUMMY");
        this.downloadInfoLabel.setText(NbBundle.getMessage(RemoteConfirmationPanelVisual.class, (String)"RemoteConfirmationPanelVisual.downloadInfoLabel.text"));
        this.uploadInfoLabel.setText("DUMMY");
        this.filesPanel.setLayout(new BoxLayout(this.filesPanel, 2));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.statusLabel).addComponent(this.downloadInfoLabel, -2, -1, -2).addComponent(this.uploadInfoLabel)).addContainerGap(-1, Short.MAX_VALUE)).addComponent(this.filesPanel, -1, 437, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.statusLabel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.downloadInfoLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.filesPanel, -1, 201, Short.MAX_VALUE).addGap(18, 18, 18).addComponent(this.uploadInfoLabel)));
        this.downloadInfoLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RemoteConfirmationPanelVisual.class, (String)"RemoteConfirmationPanelVisual.downloadInfoLabel.AccessibleContext.accessibleName"));
        this.downloadInfoLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RemoteConfirmationPanelVisual.class, (String)"RemoteConfirmationPanelVisual.downloadInfoLabel.AccessibleContext.accessibleDescription"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RemoteConfirmationPanelVisual.class, (String)"RemoteConfirmationPanelVisual.AccessibleContext.accessibleName"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RemoteConfirmationPanelVisual.class, (String)"RemoteConfirmationPanelVisual.AccessibleContext.accessibleDescription"));
    }

    static enum State {
        FETCHING,
        NO_FILES,
        FILES;

    }
}

