/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.actions.support;

import javax.swing.JEditorPane;
import javax.swing.text.Document;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.php.api.editor.EditorSupport;
import org.netbeans.modules.php.api.editor.PhpBaseElement;
import org.netbeans.modules.php.api.editor.PhpType;
import org.netbeans.modules.php.api.phpmodule.PhpModule;
import org.netbeans.modules.php.project.PhpProject;
import org.netbeans.modules.php.project.ui.actions.support.CommandUtils;
import org.netbeans.modules.php.project.util.PhpProjectUtils;
import org.netbeans.modules.php.spi.testing.PhpTestingProvider;
import org.netbeans.spi.project.SingleMethod;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;
import org.openide.text.NbDocument;
import org.openide.util.Lookup;
import org.openide.util.Mutex;

public final class TestSingleMethodSupport {
    private TestSingleMethodSupport() {
    }

    public static boolean isTestClass(Node activatedNode) {
        FileObject fileObject = CommandUtils.getFileObject(activatedNode);
        if (fileObject == null) {
            return false;
        }
        PhpProject project = PhpProjectUtils.getPhpProject(fileObject);
        if (project == null) {
            return false;
        }
        return CommandUtils.isUnderTests(project, fileObject, false);
    }

    public static boolean canHandle(Node activatedNode) {
        FileObject fileObject = CommandUtils.getFileObject(activatedNode);
        if (fileObject == null) {
            return false;
        }
        PhpProject project = PhpProjectUtils.getPhpProject(fileObject);
        if (project == null) {
            return false;
        }
        final EditorCookie editorCookie = (EditorCookie)activatedNode.getLookup().lookup(EditorCookie.class);
        if (editorCookie == null) {
            return false;
        }
        JEditorPane pane = (JEditorPane)Mutex.EVENT.readAccess((Mutex.Action)new Mutex.Action<JEditorPane>(){

            public JEditorPane run() {
                return NbDocument.findRecentEditorPane((EditorCookie)editorCookie);
            }
        });
        if (pane == null) {
            return false;
        }
        return TestSingleMethodSupport.getTestMethod(pane.getDocument(), pane.getCaret().getDot()) != null;
    }

    public static SingleMethod getTestMethod(Document doc, int caret) {
        FileObject fileObject = NbEditorUtilities.getFileObject((Document)doc);
        assert (fileObject != null);
        EditorSupport editorSupport = (EditorSupport)Lookup.getDefault().lookup(EditorSupport.class);
        assert (editorSupport != null);
        PhpBaseElement element = editorSupport.getElement(fileObject, caret);
        if (!(element instanceof PhpType.Method)) {
            return null;
        }
        PhpType.Method method = (PhpType.Method)element;
        PhpProject project = PhpProjectUtils.getPhpProject(fileObject);
        assert (project != null);
        PhpModule phpModule = project.getPhpModule();
        for (PhpTestingProvider testingProvider : project.getTestingProviders()) {
            if (!testingProvider.isTestFile(phpModule, fileObject) || !testingProvider.isTestCase(phpModule, method)) continue;
            return new SingleMethod(fileObject, CommandUtils.encodeMethod(method.getPhpType().getFullyQualifiedName(), method.getName()));
        }
        return null;
    }
}

