/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.phpunit;

import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.modules.php.api.editor.PhpType;
import org.netbeans.modules.php.api.phpmodule.PhpModule;
import org.netbeans.modules.php.phpunit.Bundle;
import org.netbeans.modules.php.phpunit.commands.PhpUnit;
import org.netbeans.modules.php.phpunit.coverage.CoverageProvider;
import org.netbeans.modules.php.phpunit.create.TestCreator;
import org.netbeans.modules.php.phpunit.locate.PhpUnitTestLocator;
import org.netbeans.modules.php.phpunit.preferences.PhpUnitPreferences;
import org.netbeans.modules.php.phpunit.run.TestRunner;
import org.netbeans.modules.php.phpunit.ui.customizer.PhpUnitCustomizer;
import org.netbeans.modules.php.spi.testing.PhpTestingProvider;
import org.netbeans.modules.php.spi.testing.create.CreateTestsResult;
import org.netbeans.modules.php.spi.testing.locate.Locations;
import org.netbeans.modules.php.spi.testing.locate.TestLocator;
import org.netbeans.modules.php.spi.testing.run.TestRunException;
import org.netbeans.modules.php.spi.testing.run.TestRunInfo;
import org.netbeans.modules.php.spi.testing.run.TestSession;
import org.netbeans.spi.project.ui.support.ProjectCustomizer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public final class PhpUnitTestingProvider
implements PhpTestingProvider {
    public static final String IDENTIFIER = "PhpUnit";
    private static final Logger LOGGER = Logger.getLogger(PhpUnitTestingProvider.class.getName());
    private static final PhpUnitTestingProvider INSTANCE = new PhpUnitTestingProvider();

    public static PhpUnitTestingProvider getInstance() {
        return INSTANCE;
    }

    public String getIdentifier() {
        return IDENTIFIER;
    }

    public String getDisplayName() {
        return Bundle.PhpUnitTestingProvider_name();
    }

    public boolean isTestFile(PhpModule phpModule, FileObject fileObj) {
        if (!PhpUnit.isTestFile(fileObj.getNameExt())) {
            return false;
        }
        for (FileObject testDirectory : phpModule.getTestDirectories()) {
            if (!FileUtil.isParentOf((FileObject)testDirectory, (FileObject)fileObj)) continue;
            return true;
        }
        if (!PhpUnitPreferences.getRunAllTestFiles(phpModule)) {
            return false;
        }
        FileObject sourceDirectory = phpModule.getSourceDirectory();
        return sourceDirectory != null && FileUtil.isParentOf((FileObject)sourceDirectory, (FileObject)fileObj);
    }

    public boolean isTestCase(PhpModule phpModule, PhpType.Method method) {
        if (!PhpUnit.isTestClass(method.getPhpType().getName())) {
            return false;
        }
        return PhpUnit.isTestMethod(method.getName());
    }

    public CreateTestsResult createTests(PhpModule phpModule, List<FileObject> files, Map<String, Object> configurationPanelProperties) {
        return new TestCreator(phpModule).createTests(files);
    }

    public void runTests(PhpModule phpModule, TestRunInfo runInfo, TestSession testSession) throws TestRunException {
        new TestRunner(phpModule).runTests(runInfo, testSession);
        if (runInfo.isCoverageEnabled()) {
            CoverageProvider coverageProvider = new CoverageProvider();
            if (!coverageProvider.loggerFileExists()) {
                LOGGER.log(Level.INFO, "Coverage log {0} not found for project {1}", new Object[]{PhpUnit.COVERAGE_LOG, phpModule.getDisplayName()});
                testSession.printMessage(Bundle.PhpUnitTestingProvider_coverage_log_error_1(), true);
                testSession.printMessage(Bundle.PhpUnitTestingProvider_coverage_log_error_2(), true);
                testSession.printMessage("", false);
                testSession.setCoverage(null);
            } else {
                testSession.setCoverage(coverageProvider.getCoverage());
            }
        }
    }

    public TestLocator getTestLocator(PhpModule phpModule) {
        return new PhpUnitTestLocator(phpModule);
    }

    public boolean isCoverageSupported(PhpModule phpModule) {
        return true;
    }

    public Locations.Line parseFileFromOutput(String line) {
        Pattern[] patterns;
        for (Pattern pattern : patterns = new Pattern[]{PhpUnit.OUT_LINE_PATTERN, PhpUnit.ERR_LINE_PATTERN}) {
            File file;
            Matcher matcher = pattern.matcher(line);
            if (!matcher.matches() || !(file = new File(matcher.group(1))).isFile()) continue;
            FileObject fo = FileUtil.toFileObject((File)file);
            assert (fo != null);
            return new Locations.Line(fo, Integer.parseInt(matcher.group(2)));
        }
        return null;
    }

    public ProjectCustomizer.CompositeCategoryProvider createCustomizer(PhpModule phpModule) {
        return new PhpUnitCustomizer(phpModule);
    }
}

