/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.latte.completion;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.csl.api.CodeCompletionContext;
import org.netbeans.modules.csl.api.CodeCompletionHandler;
import org.netbeans.modules.csl.api.CodeCompletionHandler2;
import org.netbeans.modules.csl.api.CodeCompletionResult;
import org.netbeans.modules.csl.api.CompletionProposal;
import org.netbeans.modules.csl.api.Documentation;
import org.netbeans.modules.csl.api.ElementHandle;
import org.netbeans.modules.csl.api.ParameterInfo;
import org.netbeans.modules.csl.spi.DefaultCompletionResult;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.php.latte.completion.LatteCompletionContext;
import org.netbeans.modules.php.latte.completion.LatteCompletionContextFinder;
import org.netbeans.modules.php.latte.completion.LatteCompletionProposal;
import org.netbeans.modules.php.latte.completion.LatteElement;
import org.netbeans.modules.php.latte.lexer.LatteMarkupTokenId;
import org.netbeans.modules.php.latte.lexer.LatteTopTokenId;
import org.netbeans.modules.php.latte.parser.LatteParserResult;
import org.netbeans.modules.php.latte.utils.LatteLexerUtils;

public class LatteCompletionHandler
implements CodeCompletionHandler2 {
    private static final Collection<Character> AUTOPOPUP_STOP_CHARS = new TreeSet<Character>(Arrays.asList(Character.valueOf('='), Character.valueOf(';'), Character.valueOf('+'), Character.valueOf('-'), Character.valueOf('*'), Character.valueOf('%'), Character.valueOf('('), Character.valueOf(')'), Character.valueOf('['), Character.valueOf(']'), Character.valueOf('{'), Character.valueOf('}'), Character.valueOf('?'), Character.valueOf(' '), Character.valueOf('\t'), Character.valueOf('\n')));
    private static final Logger LOGGER = Logger.getLogger(LatteCompletionHandler.class.getName());
    private static URL documentationUrl = null;
    static final Set<LatteElement> MACROS;
    static final Set<LatteElement> END_MACROS;
    static final Set<LatteElement> HELPERS;
    static final Set<LatteElement> KEYWORDS;
    static final Set<LatteElement> ITERATOR_FIELD_ITEMS;
    static final Set<LatteElement> ITERATOR_METHOD_ITEMS;
    static final Set<LatteElement> DEFAULT_VARIABLES;

    public CodeCompletionResult complete(CodeCompletionContext context) {
        ArrayList<CompletionProposal> completionProposals = new ArrayList<CompletionProposal>();
        ParserResult parserResult = context.getParserResult();
        if (parserResult instanceof LatteParserResult) {
            LatteParserResult latteParserResult = (LatteParserResult)parserResult;
            LatteCompletionProposal.CompletionRequest request = new LatteCompletionProposal.CompletionRequest();
            int caretOffset = context.getCaretOffset();
            request.prefix = context.getPrefix();
            String properPrefix = this.getPrefix(latteParserResult, caretOffset, true);
            request.anchorOffset = caretOffset - (properPrefix == null ? 0 : properPrefix.length());
            request.parserResult = latteParserResult;
            LatteCompletionContext completionContext = LatteCompletionContextFinder.find(request.parserResult, caretOffset);
            completionContext.complete(completionProposals, request);
        }
        return new DefaultCompletionResult(completionProposals, false);
    }

    public Documentation documentElement(ParserResult info, ElementHandle element, Callable<Boolean> cancel) {
        Documentation result = null;
        if (element instanceof LatteElement) {
            result = Documentation.create((String)((LatteElement)element).getDocumentationText(), (URL)documentationUrl);
        }
        return result;
    }

    public String document(ParserResult info, ElementHandle element) {
        return null;
    }

    public ElementHandle resolveLink(String link, ElementHandle originalHandle) {
        return null;
    }

    public String getPrefix(ParserResult info, int caretOffset, boolean upToOffset) {
        return PrefixResolver.create(info, caretOffset, upToOffset).resolve();
    }

    public CodeCompletionHandler.QueryType getAutoQuery(JTextComponent component, String typedText) {
        CodeCompletionHandler.QueryType result = CodeCompletionHandler.QueryType.ALL_COMPLETION;
        if (typedText.length() == 0) {
            result = CodeCompletionHandler.QueryType.NONE;
        } else {
            char lastChar = typedText.charAt(typedText.length() - 1);
            if (AUTOPOPUP_STOP_CHARS.contains(Character.valueOf(lastChar))) {
                result = CodeCompletionHandler.QueryType.STOP;
            } else {
                int offset;
                Document document = component.getDocument();
                TokenSequence<? extends LatteMarkupTokenId> ts = LatteLexerUtils.getLatteMarkupTokenSequence(document, offset = component.getCaretPosition());
                if (ts == null) {
                    result = CodeCompletionHandler.QueryType.STOP;
                }
            }
        }
        return result;
    }

    public String resolveTemplateVariable(String variable, ParserResult info, int caretOffset, String name, Map parameters) {
        return null;
    }

    public Set<String> getApplicableTemplates(Document doc, int selectionBegin, int selectionEnd) {
        return null;
    }

    public ParameterInfo parameters(ParserResult info, int caretOffset, CompletionProposal proposal) {
        return ParameterInfo.NONE;
    }

    static {
        try {
            documentationUrl = new URL("http://doc.nette.org/");
        }
        catch (MalformedURLException ex) {
            LOGGER.log(Level.FINE, null, ex);
        }
        MACROS = new HashSet<LatteElement>();
        MACROS.add(LatteElement.MacroFactory.create("link", "Presenter:action", "link ${Presenter}:${action}"));
        MACROS.add(LatteElement.MacroFactory.create("plink", "Presenter:action", "plink ${Presenter}:${action}"));
        MACROS.add(LatteElement.MacroFactory.create("continueIf", "true", "continueIf ${true}"));
        MACROS.add(LatteElement.MacroFactory.create("breakIf", "true", "breakif ${true}"));
        MACROS.add(LatteElement.MacroFactory.create("if", "true", "if ${true}"));
        MACROS.add(LatteElement.MacroFactory.create("else"));
        MACROS.add(LatteElement.MacroFactory.create("elseif", "true", "elseif ${true}"));
        MACROS.add(LatteElement.MacroFactory.create("ifset", "$var", "ifset ${var}"));
        MACROS.add(LatteElement.MacroFactory.create("ifset", "#block", "ifset #${block}"));
        MACROS.add(LatteElement.MacroFactory.create("elseifset", "$var", "elseifset ${var}"));
        MACROS.add(LatteElement.MacroFactory.create("ifCurrent", "Presenter:action", "ifCurrent ${Presenter}:${action}"));
        MACROS.add(LatteElement.MacroFactory.create("for", "init; cond; exec", "for ${init}; ${cond}; ${exec}"));
        MACROS.add(LatteElement.MacroFactory.create("foreach", "$array as $item", "foreach ${array} as ${item}"));
        MACROS.add(LatteElement.MacroFactory.create("while", "true", "while ${true}"));
        MACROS.add(LatteElement.MacroFactory.create("include", "'file.latte'", "include '${file.latte}'"));
        MACROS.add(LatteElement.MacroFactory.create("include", "#block", "include #{block}"));
        MACROS.add(LatteElement.MacroFactory.create("extends", "'file.latte'", "extends '${file.latte}'"));
        MACROS.add(LatteElement.MacroFactory.create("layout", "'file.latte'", "layout '${file.latte}'"));
        MACROS.add(LatteElement.MacroFactory.create("control", "name", "control ${name}"));
        MACROS.add(LatteElement.MacroFactory.create("cache", "$key", "cache ${key}"));
        MACROS.add(LatteElement.MacroFactory.create("snippet", "$name", "snippet ${name}"));
        MACROS.add(LatteElement.MacroFactory.create("block", "#name", "block #${name}"));
        MACROS.add(LatteElement.MacroFactory.create("define", "#name", "define #${name}"));
        MACROS.add(LatteElement.MacroFactory.create("includeblock", "'file.latte'", "includeblock '${file.latte}'"));
        MACROS.add(LatteElement.MacroFactory.create("contentType", "$type", "contentType ${type}"));
        MACROS.add(LatteElement.MacroFactory.create("status", "$code", "status ${code}"));
        MACROS.add(LatteElement.MacroFactory.create("capture", "$var", "capture ${var}"));
        MACROS.add(LatteElement.MacroFactory.create("assign"));
        MACROS.add(LatteElement.MacroFactory.create("default", "$name = $value", "default ${name} = ${value}"));
        MACROS.add(LatteElement.MacroFactory.create("var", "$name = $value", "var ${name} = ${value}"));
        MACROS.add(LatteElement.MacroFactory.create("dump", "$var", "dump ${var}"));
        MACROS.add(LatteElement.MacroFactory.create("syntax", "mode", "syntax ${mode}"));
        MACROS.add(LatteElement.MacroFactory.create("use", "Class", "use ${Class}"));
        MACROS.add(LatteElement.MacroFactory.create("form", "$name", "form ${name}"));
        MACROS.add(LatteElement.MacroFactory.create("label", "$name", "label ${name}"));
        MACROS.add(LatteElement.MacroFactory.create("input", "$name", "input ${name}"));
        MACROS.add(LatteElement.MacroFactory.create("debugbreak", "$cond", "debugbreak ${cond}"));
        MACROS.add(LatteElement.MacroFactory.create("l"));
        MACROS.add(LatteElement.MacroFactory.create("r"));
        MACROS.add(LatteElement.MacroFactory.create("first"));
        MACROS.add(LatteElement.MacroFactory.create("last"));
        MACROS.add(LatteElement.MacroFactory.create("sep"));
        MACROS.add(LatteElement.MacroFactory.create("_"));
        MACROS.add(LatteElement.MacroFactory.create("!"));
        MACROS.add(LatteElement.MacroFactory.create("!_"));
        MACROS.add(LatteElement.MacroFactory.create("="));
        MACROS.add(LatteElement.MacroFactory.create("#"));
        END_MACROS = new HashSet<LatteElement>();
        END_MACROS.add(LatteElement.MacroFactory.createEnd("if"));
        END_MACROS.add(LatteElement.MacroFactory.createEnd("ifset"));
        END_MACROS.add(LatteElement.MacroFactory.createEnd("ifCurrent"));
        END_MACROS.add(LatteElement.MacroFactory.createEnd("for"));
        END_MACROS.add(LatteElement.MacroFactory.createEnd("foreach"));
        END_MACROS.add(LatteElement.MacroFactory.createEnd("while"));
        END_MACROS.add(LatteElement.MacroFactory.createEnd("first"));
        END_MACROS.add(LatteElement.MacroFactory.createEnd("last"));
        END_MACROS.add(LatteElement.MacroFactory.createEnd("sep"));
        END_MACROS.add(LatteElement.MacroFactory.createEnd("capture"));
        END_MACROS.add(LatteElement.MacroFactory.createEnd("cache"));
        END_MACROS.add(LatteElement.MacroFactory.createEnd("syntax"));
        END_MACROS.add(LatteElement.MacroFactory.createEnd("_"));
        END_MACROS.add(LatteElement.MacroFactory.createEnd("block"));
        END_MACROS.add(LatteElement.MacroFactory.createEnd("form"));
        END_MACROS.add(LatteElement.MacroFactory.createEnd("label"));
        END_MACROS.add(LatteElement.MacroFactory.createEnd("snippet"));
        END_MACROS.add(LatteElement.MacroFactory.createEnd("define"));
        HELPERS = new HashSet<LatteElement>();
        HELPERS.add(LatteElement.HelperFactory.create("truncate", Arrays.asList(new LatteElement.HelperParameter("length"), new LatteElement.HelperParameter("append", "'\u2026'"))));
        HELPERS.add(LatteElement.HelperFactory.create("substr", Arrays.asList(new LatteElement.HelperParameter("offset"), new LatteElement.HelperParameter("length", "stringLength"))));
        HELPERS.add(LatteElement.HelperFactory.create("trim", Arrays.asList(new LatteElement.HelperParameter("charlist", "' \\t\\n\\r\\0\\x0B\\xC2\\xA0'"))));
        HELPERS.add(LatteElement.HelperFactory.create("striptags"));
        HELPERS.add(LatteElement.HelperFactory.create("strip"));
        HELPERS.add(LatteElement.HelperFactory.create("webalize", Arrays.asList(new LatteElement.HelperParameter("charlist", "NULL"), new LatteElement.HelperParameter("lower", "true"))));
        HELPERS.add(LatteElement.HelperFactory.create("toAscii"));
        HELPERS.add(LatteElement.HelperFactory.create("indent", Arrays.asList(new LatteElement.HelperParameter("level", "1"), new LatteElement.HelperParameter("char", "'\\t'"))));
        HELPERS.add(LatteElement.HelperFactory.create("replace", Arrays.asList(new LatteElement.HelperParameter("search"), new LatteElement.HelperParameter("replace", "''"))));
        HELPERS.add(LatteElement.HelperFactory.create("replaceRE", Arrays.asList(new LatteElement.HelperParameter("pattern"), new LatteElement.HelperParameter("replace", "''"))));
        HELPERS.add(LatteElement.HelperFactory.create("padLeft", Arrays.asList(new LatteElement.HelperParameter("length"), new LatteElement.HelperParameter("pad", "' '"))));
        HELPERS.add(LatteElement.HelperFactory.create("padRight", Arrays.asList(new LatteElement.HelperParameter("length"), new LatteElement.HelperParameter("pad", "' '"))));
        HELPERS.add(LatteElement.HelperFactory.create("repeat", Arrays.asList(new LatteElement.HelperParameter("count"))));
        HELPERS.add(LatteElement.HelperFactory.create("implode", Arrays.asList(new LatteElement.HelperParameter("glue", "''"))));
        HELPERS.add(LatteElement.HelperFactory.create("nl2br"));
        HELPERS.add(LatteElement.HelperFactory.create("lower"));
        HELPERS.add(LatteElement.HelperFactory.create("upper"));
        HELPERS.add(LatteElement.HelperFactory.create("firstUpper"));
        HELPERS.add(LatteElement.HelperFactory.create("capitalize"));
        HELPERS.add(LatteElement.HelperFactory.create("date", Arrays.asList(new LatteElement.HelperParameter("'format'"))));
        HELPERS.add(LatteElement.HelperFactory.create("number", Arrays.asList(new LatteElement.HelperParameter("decimals", "0"), new LatteElement.HelperParameter("decPoint", "'.'"))));
        HELPERS.add(LatteElement.HelperFactory.create("bytes", Arrays.asList(new LatteElement.HelperParameter("precision", "2"))));
        HELPERS.add(LatteElement.HelperFactory.create("dataStream", Arrays.asList(new LatteElement.HelperParameter("mimetype", "NULL"))));
        HELPERS.add(LatteElement.HelperFactory.create("url"));
        HELPERS.add(LatteElement.HelperFactory.create("length"));
        HELPERS.add(LatteElement.HelperFactory.create("null"));
        KEYWORDS = new HashSet<LatteElement>();
        KEYWORDS.add(LatteElement.KeywordFactory.create("true"));
        KEYWORDS.add(LatteElement.KeywordFactory.create("false"));
        KEYWORDS.add(LatteElement.KeywordFactory.create("null"));
        KEYWORDS.add(LatteElement.KeywordFactory.create("and"));
        KEYWORDS.add(LatteElement.KeywordFactory.create("or"));
        KEYWORDS.add(LatteElement.KeywordFactory.create("xor"));
        KEYWORDS.add(LatteElement.KeywordFactory.create("clone"));
        KEYWORDS.add(LatteElement.KeywordFactory.create("new"));
        KEYWORDS.add(LatteElement.KeywordFactory.create("instanceof"));
        KEYWORDS.add(LatteElement.KeywordFactory.create("return"));
        KEYWORDS.add(LatteElement.KeywordFactory.create("continue"));
        KEYWORDS.add(LatteElement.KeywordFactory.create("break"));
        ITERATOR_FIELD_ITEMS = new HashSet<LatteElement>();
        ITERATOR_FIELD_ITEMS.add(LatteElement.IteratorItemFactory.create("first"));
        ITERATOR_FIELD_ITEMS.add(LatteElement.IteratorItemFactory.create("last"));
        ITERATOR_FIELD_ITEMS.add(LatteElement.IteratorItemFactory.create("counter"));
        ITERATOR_FIELD_ITEMS.add(LatteElement.IteratorItemFactory.create("odd"));
        ITERATOR_FIELD_ITEMS.add(LatteElement.IteratorItemFactory.create("even"));
        ITERATOR_METHOD_ITEMS = new HashSet<LatteElement>();
        ITERATOR_METHOD_ITEMS.add(LatteElement.IteratorItemFactory.create("isFirst()"));
        ITERATOR_METHOD_ITEMS.add(LatteElement.IteratorItemFactory.create("isLast()"));
        ITERATOR_METHOD_ITEMS.add(LatteElement.IteratorItemFactory.create("getCounter()"));
        ITERATOR_METHOD_ITEMS.add(LatteElement.IteratorItemFactory.create("isOdd()"));
        ITERATOR_METHOD_ITEMS.add(LatteElement.IteratorItemFactory.create("isEven()"));
        DEFAULT_VARIABLES = new HashSet<LatteElement>();
        DEFAULT_VARIABLES.add(LatteElement.VariableFactory.create("$control"));
        DEFAULT_VARIABLES.add(LatteElement.VariableFactory.create("$presenter"));
        DEFAULT_VARIABLES.add(LatteElement.VariableFactory.create("$user"));
        DEFAULT_VARIABLES.add(LatteElement.VariableFactory.create("$netteHttpResponse"));
        DEFAULT_VARIABLES.add(LatteElement.VariableFactory.create("$netteCacheStorage"));
        DEFAULT_VARIABLES.add(LatteElement.VariableFactory.create("$baseUri"));
        DEFAULT_VARIABLES.add(LatteElement.VariableFactory.create("$basePath"));
        DEFAULT_VARIABLES.add(LatteElement.VariableFactory.create("$flashes"));
    }

    private static final class PrefixResolver {
        private static final String VARIABLE_PREFIX = "$";
        private final ParserResult info;
        private final int offset;
        private final boolean upToOffset;
        private String result = "";

        static PrefixResolver create(ParserResult info, int offset, boolean upToOffset) {
            return new PrefixResolver(info, offset, upToOffset);
        }

        private PrefixResolver(ParserResult info, int offset, boolean upToOffset) {
            this.info = info;
            this.offset = offset;
            this.upToOffset = upToOffset;
        }

        String resolve() {
            TokenHierarchy th = this.info.getSnapshot().getTokenHierarchy();
            if (th != null) {
                this.processHierarchy(th);
            }
            return this.result;
        }

        private void processHierarchy(TokenHierarchy<?> th) {
            TokenSequence tts = th.tokenSequence(LatteTopTokenId.language());
            if (tts != null) {
                this.processTopSequence((TokenSequence<LatteTopTokenId>)tts);
            }
        }

        private void processTopSequence(TokenSequence<LatteTopTokenId> tts) {
            tts.move(this.offset);
            if (tts.moveNext() || tts.movePrevious()) {
                TokenSequence embedded = tts.embedded(LatteMarkupTokenId.language());
                if (embedded == null && tts.movePrevious()) {
                    embedded = tts.embedded(LatteMarkupTokenId.language());
                }
                this.processSequence((TokenSequence<LatteMarkupTokenId>)embedded);
            }
        }

        private void processSequence(TokenSequence<LatteMarkupTokenId> ts) {
            if (ts != null) {
                this.processValidSequence(ts);
            }
        }

        private void processValidSequence(TokenSequence<LatteMarkupTokenId> ts) {
            ts.move(this.offset);
            if (ts.moveNext() || ts.movePrevious()) {
                this.processToken(ts);
            }
        }

        private void processToken(TokenSequence<LatteMarkupTokenId> ts) {
            Token token;
            if (ts.offset() == this.offset) {
                ts.movePrevious();
            }
            if ((token = ts.token()) != null) {
                this.processSelectedToken(ts);
            }
        }

        private void processSelectedToken(TokenSequence<LatteMarkupTokenId> ts) {
            if (PrefixResolver.isValidTokenId((Token<LatteMarkupTokenId>)ts.token())) {
                this.createResult(ts);
            }
        }

        private void createResult(TokenSequence<LatteMarkupTokenId> ts) {
            if (this.upToOffset) {
                String text = ts.token().text().toString();
                int endIndex = this.offset - ts.offset();
                if (endIndex <= text.length()) {
                    this.result = text.substring(0, endIndex);
                }
            }
        }

        private static boolean isValidTokenId(Token<LatteMarkupTokenId> token) {
            assert (token != null);
            LatteMarkupTokenId id = (LatteMarkupTokenId)token.id();
            return LatteMarkupTokenId.T_SYMBOL.equals((Object)id) || LatteMarkupTokenId.T_VARIABLE.equals((Object)id) || LatteMarkupTokenId.T_MACRO_START.equals((Object)id) || LatteMarkupTokenId.T_MACRO_END.equals((Object)id) || LatteMarkupTokenId.T_ERROR.equals((Object)id) || LatteMarkupTokenId.T_CHAR.equals((Object)id) && VARIABLE_PREFIX.equals(token.text());
        }
    }
}

