/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.dbgp.models.nodes;

import java.util.Collection;
import java.util.List;
import org.netbeans.modules.php.dbgp.ModelNode;
import org.netbeans.modules.php.dbgp.UnsufficientValueException;
import org.netbeans.modules.php.dbgp.models.VariablesModel;
import org.netbeans.modules.php.dbgp.models.nodes.AbstractModelNode;
import org.netbeans.modules.php.dbgp.models.nodes.ArrayVariableNode;
import org.netbeans.modules.php.dbgp.models.nodes.ContextNode;
import org.netbeans.modules.php.dbgp.models.nodes.ObjectVariableNode;
import org.netbeans.modules.php.dbgp.models.nodes.VariableNode;
import org.netbeans.modules.php.dbgp.packets.Property;
import org.netbeans.modules.php.dbgp.packets.PropertyCommand;
import org.netbeans.modules.php.dbgp.packets.PropertyGetCommand;
import org.netbeans.modules.php.dbgp.packets.PropertySetCommand;
import org.netbeans.modules.php.dbgp.packets.PropertyValueCommand;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.openide.text.Line;

public abstract class AbstractVariableNode
extends AbstractModelNode
implements VariableNode {
    protected static final String FIELD_ICON = "org/netbeans/modules/debugger/resources/watchesView/Field";
    private Property myProperty;

    protected AbstractVariableNode(Property property, AbstractModelNode parent) {
        super(parent, property.getChildren());
        this.myProperty = property;
    }

    @Override
    public String getFullName() {
        return this.getProperty().getFullName();
    }

    @Override
    public String getName() {
        String propertyName;
        Property property = this.getProperty();
        String string = propertyName = property != null ? property.getName() : null;
        if (this.getParent() instanceof ArrayVariableNode) {
            StringBuilder builder = new StringBuilder("[");
            builder.append(propertyName);
            builder.append("]");
            return builder.toString();
        }
        return propertyName;
    }

    @Override
    public ModelNode[] getChildren(int from, int to) {
        List<AbstractVariableNode> subList = this.getVariables().subList(from, to);
        return subList.toArray(new ModelNode[subList.size()]);
    }

    @Override
    public int getChildrenSize() {
        return this.getVariables().size();
    }

    @Override
    public String getIconBase() {
        AbstractModelNode node = this.getParent();
        if (node instanceof ObjectVariableNode) {
            return FIELD_ICON;
        }
        return "org/netbeans/modules/debugger/resources/localsView/LocalVariable";
    }

    @Override
    public String getShortDescription() {
        return null;
    }

    @Override
    public String getType() {
        return this.getProperty().getType();
    }

    @Override
    public String getValue() throws UnsufficientValueException {
        return this.getProperty().getStringValue();
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public Line findDeclarationLine() {
        return null;
    }

    @Override
    public boolean isLeaf() {
        return !this.getProperty().hasChildren();
    }

    public void setupCommand(PropertyValueCommand valueCommand) {
        this.setupCommand((PropertyGetCommand)valueCommand);
        valueCommand.setMaxDataSize(this.getProperty().getSize());
    }

    public void setupCommand(PropertyGetCommand getCommand) {
        this.setupCommand((PropertyCommand)getCommand);
        String key = this.getProperty().getKey();
        if (key != null) {
            getCommand.setKey(key);
        }
    }

    public void setupCommand(PropertySetCommand command) {
        this.setupCommand((PropertyCommand)command);
    }

    public void setupFillChildrenCommand(PropertyGetCommand getCommand) {
        this.setupCommand(getCommand);
        int page = this.getProperty().getPage() + 1;
        getCommand.setDataPage(page);
    }

    public boolean isChildrenFilled() {
        int page;
        int pageSize = this.getProperty().getPageSize();
        if (pageSize == 0) {
            return true;
        }
        int childrenSize = this.getProperty().getChildrenSize();
        return childrenSize <= ((page = this.getProperty().getPage()) + 1) * pageSize;
    }

    public int getContext() {
        return this.getRootContext().getIndex();
    }

    protected void setProperty(Property property) {
        Property old = this.getProperty();
        property.setName(old.getName());
        this.myProperty = property;
    }

    protected abstract void collectUpdates(VariablesModel var1, VariableNode var2, Collection<ModelEvent> var3);

    protected Property getProperty() {
        return this.myProperty;
    }

    private ContextNode getRootContext() {
        AbstractModelNode retval;
        for (retval = this; retval != null && !(retval instanceof ContextNode); retval = retval.getParent()) {
        }
        return (ContextNode)retval;
    }

    private void setupCommand(PropertyCommand command) {
        command.setName(this.getFullName());
        command.setContext(this.getContext());
    }
}

