/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.composer;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.URI;
import java.util.EventListener;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.queries.SharabilityQuery;
import org.netbeans.modules.php.composer.files.ComposerJson;
import org.netbeans.modules.php.composer.options.ComposerOptions;
import org.netbeans.spi.queries.SharabilityQueryImplementation2;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;

public final class SharabilityQueryImpl
implements SharabilityQueryImplementation2,
PropertyChangeListener,
PreferenceChangeListener {
    final ComposerJson composerJson;
    private volatile URI vendorDir = null;
    private volatile Boolean versioningIgnored;

    private SharabilityQueryImpl(Project project) {
        assert (project != null);
        this.composerJson = new ComposerJson(project.getProjectDirectory());
    }

    public static SharabilityQueryImplementation2 create(Project project) {
        SharabilityQueryImpl sharabilityQuery = new SharabilityQueryImpl(project);
        sharabilityQuery.composerJson.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)sharabilityQuery, (Object)sharabilityQuery.composerJson));
        ComposerOptions composerOptions = ComposerOptions.getInstance();
        composerOptions.addPreferenceChangeListener((PreferenceChangeListener)WeakListeners.create(PreferenceChangeListener.class, (EventListener)sharabilityQuery, (Object)composerOptions));
        return sharabilityQuery;
    }

    public SharabilityQuery.Sharability getSharability(URI uri) {
        if (this.isVersioningIgnored() && uri.equals(this.getVendorDir())) {
            return SharabilityQuery.Sharability.NOT_SHARABLE;
        }
        return SharabilityQuery.Sharability.UNKNOWN;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("VENDOR_DIR".equals(evt.getPropertyName())) {
            this.vendorDir = null;
        }
    }

    private URI getVendorDir() {
        if (this.vendorDir == null) {
            this.vendorDir = Utilities.toURI((File)this.composerJson.getVendorDir());
        }
        return this.vendorDir;
    }

    public boolean isVersioningIgnored() {
        if (this.versioningIgnored == null) {
            this.versioningIgnored = ComposerOptions.getInstance().isIgnoreVendor();
        }
        return this.versioningIgnored;
    }

    @Override
    public void preferenceChange(PreferenceChangeEvent evt) {
        if ("ignore.vendor".equals(evt.getKey())) {
            this.versioningIgnored = null;
        }
    }
}

