/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.analysis.ui.analyzer;

import java.awt.EventQueue;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.concurrent.TimeUnit;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import org.netbeans.modules.analysis.spi.Analyzer;
import org.netbeans.modules.php.analysis.options.AnalysisOptions;
import org.netbeans.modules.php.analysis.options.AnalysisOptionsValidator;
import org.netbeans.modules.php.analysis.ui.CodeSnifferStandardsComboBoxModel;
import org.netbeans.modules.php.api.validation.ValidationResult;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class CodeSnifferCustomizerPanel
extends JPanel {
    private static final long serialVersionUID = 46872132457657L;
    private static final RequestProcessor RP = new RequestProcessor(CodeSnifferCustomizerPanel.class);
    public static final String ENABLED = "codeSniffer.enabled";
    public static final String STANDARD = "codeSniffer.standard";
    final CodeSnifferStandardsComboBoxModel standardsModel = new CodeSnifferStandardsComboBoxModel();
    final Analyzer.CustomizerContext<Void, CodeSnifferCustomizerPanel> context;
    final Preferences settings;
    private JCheckBox enabledCheckBox;
    private JComboBox<String> standardComboBox;
    private JLabel standardLabel;

    public CodeSnifferCustomizerPanel(Analyzer.CustomizerContext<Void, CodeSnifferCustomizerPanel> context) {
        assert (context != null);
        this.context = context;
        this.settings = context.getSettings();
        this.initComponents();
        this.init();
    }

    private void init() {
        boolean isEnabled = this.settings.getBoolean(ENABLED, false);
        this.enabledCheckBox.setSelected(isEnabled);
        this.enabledCheckBox.addItemListener(e -> {
            this.setStandardComponentsEnabled(this.enabledCheckBox.isSelected());
            this.setCodeSnifferEnabled();
            if (!this.enabledCheckBox.isSelected()) {
                this.context.setError(null);
            } else {
                this.validateData();
            }
        });
        this.standardComboBox.setModel(this.standardsModel);
        this.standardsModel.fetchStandards(this.standardComboBox);
        this.standardsModel.setSelectedItem(this.settings.get(STANDARD, AnalysisOptions.getInstance().getCodeSnifferStandard()));
        this.standardComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (CodeSnifferCustomizerPanel.this.enabledCheckBox.isSelected()) {
                    CodeSnifferCustomizerPanel.this.validateAndSetData();
                }
            }
        });
        RP.schedule(() -> EventQueue.invokeLater(() -> this.setStandardComponentsEnabled(isEnabled)), 1000L, TimeUnit.MILLISECONDS);
    }

    void validateAndSetData() {
        if (this.validateData()) {
            this.setData();
        }
    }

    private boolean validateData() {
        ValidationResult result = new AnalysisOptionsValidator().validateCodeSnifferStandard(this.standardsModel.getSelectedStandard()).getResult();
        if (result.hasErrors()) {
            this.context.setError(((ValidationResult.Message)result.getErrors().get(0)).getMessage());
            return false;
        }
        if (result.hasWarnings()) {
            this.context.setError(((ValidationResult.Message)result.getWarnings().get(0)).getMessage());
            return false;
        }
        this.context.setError(null);
        return true;
    }

    private void setData() {
        this.settings.put(STANDARD, this.standardsModel.getSelectedStandard());
    }

    private void setCodeSnifferEnabled() {
        this.settings.putBoolean(ENABLED, this.enabledCheckBox.isSelected());
    }

    private void setStandardComponentsEnabled(boolean isEnabled) {
        this.standardComboBox.setEnabled(isEnabled);
        this.standardLabel.setEnabled(isEnabled);
    }

    private void initComponents() {
        this.standardLabel = new JLabel();
        this.standardComboBox = new JComboBox();
        this.enabledCheckBox = new JCheckBox();
        Mnemonics.setLocalizedText((JLabel)this.standardLabel, (String)NbBundle.getMessage(CodeSnifferCustomizerPanel.class, (String)"CodeSnifferCustomizerPanel.standardLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.enabledCheckBox, (String)NbBundle.getMessage(CodeSnifferCustomizerPanel.class, (String)"CodeSnifferCustomizerPanel.enabledCheckBox.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.standardLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.standardComboBox, -2, -1, -2)).addComponent(this.enabledCheckBox));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.enabledCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.standardLabel).addComponent(this.standardComboBox, -2, -1, -2))));
    }
}

