/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.payara.tooling.admin;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import org.netbeans.modules.payara.tooling.admin.Command;
import org.netbeans.modules.payara.tooling.admin.CommandGetProperty;
import org.netbeans.modules.payara.tooling.admin.ResultMap;
import org.netbeans.modules.payara.tooling.admin.RunnerRest;
import org.netbeans.modules.payara.tooling.admin.response.MessagePart;
import org.netbeans.modules.payara.tooling.data.PayaraServer;
import org.netbeans.modules.payara.tooling.logging.Logger;

public class RunnerRestGetProperty
extends RunnerRest {
    private static final Logger LOGGER = new Logger(RunnerRestGetProperty.class);
    ResultMap<String, String> result;

    public RunnerRestGetProperty(PayaraServer server, Command command) {
        super(server, command, "/command/", null);
    }

    @Override
    protected ResultMap<String, String> createResult() {
        this.result = new ResultMap<String, String>();
        return this.result;
    }

    @Override
    protected boolean processResponse() {
        String METHOD = "processResponse";
        List<MessagePart> childMessages = this.report.getTopMessagePart().getChildren();
        if (childMessages == null || childMessages.isEmpty()) {
            return false;
        }
        this.result.value = new HashMap(childMessages.size());
        for (MessagePart msg : childMessages) {
            String message = msg.getMessage();
            int equalsIndex = message.indexOf(61);
            if (equalsIndex >= 0) {
                String keyPart = message.substring(0, equalsIndex);
                String valuePart = message.substring(equalsIndex + 1);
                try {
                    this.result.value.put(keyPart, valuePart);
                    this.result.value.put(keyPart, URLDecoder.decode(valuePart, "UTF-8"));
                    this.result.value.put(keyPart, URLDecoder.decode((String)this.result.value.get(keyPart), "UTF-8"));
                }
                catch (UnsupportedEncodingException ex) {
                    LOGGER.log(Level.INFO, "processResponse", "unsupportedEncoding", this.result.value.get(keyPart));
                }
                catch (IllegalArgumentException iae) {
                    LOGGER.log(Level.INFO, "processResponse", "illegalArgument", new Object[]{valuePart, this.result.value.get(keyPart)});
                }
                continue;
            }
            LOGGER.log(Level.INFO, "processResponse", "emptyString", message);
            this.result.value.put(message, "");
        }
        return true;
    }

    @Override
    protected void handleSend(HttpURLConnection hconn) throws IOException {
        OutputStreamWriter wr = new OutputStreamWriter(hconn.getOutputStream());
        CommandGetProperty gpCommand = (CommandGetProperty)this.command;
        StringBuilder data = new StringBuilder();
        data.append("pattern=").append(gpCommand.propertyPattern);
        wr.write(data.toString());
        wr.flush();
        wr.close();
    }
}

