/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.payara.tooling.server.config;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.modules.payara.tooling.data.PayaraServer;
import org.netbeans.modules.payara.tooling.data.PayaraVersion;
import org.netbeans.modules.payara.tooling.server.config.Config;
import org.netbeans.modules.payara.tooling.server.config.ConfigBuilder;
import org.netbeans.modules.payara.tooling.server.config.ServerConfigException;

public class ConfigBuilderProvider {
    private static final URL CONFIG_V3 = ConfigBuilderProvider.class.getResource("PayaraV3.xml");
    private static final Config.Next CONFIG_V4_1 = new Config.Next(PayaraVersion.PF_4_1_144, ConfigBuilderProvider.class.getResource("PayaraV4.xml"));
    private static final Config.Next CONFIG_V5_181 = new Config.Next(PayaraVersion.PF_5_181, ConfigBuilderProvider.class.getResource("PayaraV5.xml"));
    private static final Config.Next CONFIG_V5_192 = new Config.Next(PayaraVersion.PF_5_192, ConfigBuilderProvider.class.getResource("PayaraV5_192.xml"));
    private static final Config config = new Config(CONFIG_V3, CONFIG_V4_1, CONFIG_V5_181, CONFIG_V5_192);
    private static final Map<PayaraServer, ConfigBuilder> builders = new HashMap<PayaraServer, ConfigBuilder>();

    public static URL getBuilderConfig(PayaraVersion version) {
        return ConfigBuilderProvider.config.configFiles[ConfigBuilderProvider.config.index[version.ordinal()]];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ConfigBuilder getBuilder(PayaraServer server) {
        ConfigBuilder builder;
        if (server == null) {
            throw new ServerConfigException("Payara server entity shall not be null");
        }
        Map<PayaraServer, ConfigBuilder> map = builders;
        synchronized (map) {
            builder = builders.get(server);
            if (builder != null) {
                return builder;
            }
            String serverHome = server.getServerHome();
            builder = new ConfigBuilder(config, serverHome, serverHome, serverHome);
            builders.put(server, builder);
        }
        return builder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void destroyBuilder(PayaraServer server) {
        if (server == null) {
            throw new ServerConfigException("Payara server entity shall not be null");
        }
        Map<PayaraServer, ConfigBuilder> map = builders;
        synchronized (map) {
            builders.remove(server);
        }
    }
}

