/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.fish.payara.micro.project.ui;

import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import org.netbeans.modules.fish.payara.micro.project.MicroVersion;
import org.netbeans.modules.fish.payara.micro.project.VersionRepository;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

class PayaraMicroPanel
extends JPanel {
    private JCheckBox autoBindHttpCheckBox;
    private JLabel autoBindHttpLabel;
    private JComboBox microVersionCombobox;
    private JLabel microVersionLabel;

    PayaraMicroPanel(J2eeModule.Type projectType) {
        this.initComponents();
        this.getAccessibleContext().setAccessibleDescription(this.getName());
    }

    @Override
    public String getName() {
        return NbBundle.getMessage(PayaraMicroPanel.class, (String)"LBL_MavenProjectSettings");
    }

    void readSettings(WizardDescriptor descriptor) {
        String autoBindHTTP;
        String microVersionText = (String)descriptor.getProperty("payaraMicroVersion");
        if (microVersionText != null) {
            VersionRepository.toMicroVersion(microVersionText).ifPresent(microVersion -> this.microVersionCombobox.setSelectedItem(microVersion));
        }
        if ((autoBindHTTP = (String)descriptor.getProperty("autoBindHttp")) == null) {
            autoBindHTTP = Boolean.TRUE.toString();
        }
        this.autoBindHttpCheckBox.setSelected(Boolean.valueOf(autoBindHTTP));
    }

    void storeSettings(WizardDescriptor descriptor) {
        descriptor.putProperty("payaraMicroVersion", (Object)((MicroVersion)this.microVersionCombobox.getSelectedItem()).getVersion());
        descriptor.putProperty("autoBindHttp", (Object)String.valueOf(this.autoBindHttpCheckBox.isSelected()));
    }

    private void initComponents() {
        this.microVersionCombobox = new JComboBox();
        this.microVersionLabel = new JLabel();
        this.autoBindHttpLabel = new JLabel();
        this.autoBindHttpCheckBox = new JCheckBox();
        this.microVersionCombobox.setModel(new DefaultComboBoxModel<Object>(VersionRepository.getInstance().getMicroVersion().toArray()));
        Mnemonics.setLocalizedText((JLabel)this.microVersionLabel, (String)NbBundle.getMessage(PayaraMicroPanel.class, (String)"PayaraMicroPanel.microVersionLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.autoBindHttpLabel, (String)NbBundle.getMessage(PayaraMicroPanel.class, (String)"PayaraMicroPanel.autoBindHttpLabel.text"));
        this.autoBindHttpLabel.setToolTipText(NbBundle.getMessage(PayaraMicroPanel.class, (String)"TLTP_AUTO_BIND_HTTP"));
        Mnemonics.setLocalizedText((AbstractButton)this.autoBindHttpCheckBox, (String)NbBundle.getMessage(PayaraMicroPanel.class, (String)"PayaraMicroPanel.autoBindHttpCheckBox.text"));
        this.autoBindHttpCheckBox.setToolTipText(NbBundle.getMessage(PayaraMicroPanel.class, (String)"TLTP_AUTO_BIND_HTTP"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.microVersionLabel).addComponent(this.autoBindHttpLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.autoBindHttpCheckBox).addContainerGap(-1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.microVersionCombobox, 0, -1, Short.MAX_VALUE).addGap(69, 69, 69)))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.microVersionLabel).addComponent(this.microVersionCombobox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.autoBindHttpCheckBox).addComponent(this.autoBindHttpLabel)).addContainerGap(255, Short.MAX_VALUE)));
    }
}

