/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.payara.eecommon.api.config;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.dd.api.webservices.Webservices;
import org.netbeans.modules.j2ee.deployment.common.api.ConfigurationException;
import org.netbeans.modules.j2ee.deployment.common.api.Datasource;
import org.netbeans.modules.j2ee.deployment.common.api.DatasourceAlreadyExistsException;
import org.netbeans.modules.j2ee.deployment.common.api.MessageDestination;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.deployment.plugins.spi.config.ContextRootConfiguration;
import org.netbeans.modules.j2ee.deployment.plugins.spi.config.DatasourceConfiguration;
import org.netbeans.modules.j2ee.deployment.plugins.spi.config.EjbResourceConfiguration;
import org.netbeans.modules.j2ee.deployment.plugins.spi.config.MessageDestinationConfiguration;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModel;
import org.netbeans.modules.j2ee.sun.dd.api.ASDDVersion;
import org.netbeans.modules.j2ee.sun.dd.api.CommonDDBean;
import org.netbeans.modules.j2ee.sun.dd.api.DDProvider;
import org.netbeans.modules.j2ee.sun.dd.api.RootInterface;
import org.netbeans.modules.j2ee.sun.dd.api.client.SunApplicationClient;
import org.netbeans.modules.j2ee.sun.dd.api.common.EjbRef;
import org.netbeans.modules.j2ee.sun.dd.api.common.MessageDestination;
import org.netbeans.modules.j2ee.sun.dd.api.common.MessageDestinationRef;
import org.netbeans.modules.j2ee.sun.dd.api.common.ResourceRef;
import org.netbeans.modules.j2ee.sun.dd.api.common.WebserviceEndpoint;
import org.netbeans.modules.j2ee.sun.dd.api.ejb.Ejb;
import org.netbeans.modules.j2ee.sun.dd.api.ejb.EnterpriseBeans;
import org.netbeans.modules.j2ee.sun.dd.api.ejb.MdbConnectionFactory;
import org.netbeans.modules.j2ee.sun.dd.api.ejb.SunEjbJar;
import org.netbeans.modules.j2ee.sun.dd.api.web.SunWebApp;
import org.netbeans.modules.payara.eecommon.api.Utils;
import org.netbeans.modules.payara.eecommon.api.XmlFileCreator;
import org.netbeans.modules.payara.eecommon.api.config.DescriptorListener;
import org.netbeans.modules.payara.eecommon.api.config.J2EEBaseVersion;
import org.netbeans.modules.payara.eecommon.api.config.J2EEVersion;
import org.netbeans.modules.payara.eecommon.api.config.J2eeModuleHelper;
import org.netbeans.modules.payara.eecommon.api.config.JavaEEModule;
import org.netbeans.modules.payara.eecommon.dd.loader.PayaraDDProvider;
import org.netbeans.modules.payara.tooling.data.PayaraVersion;
import org.netbeans.modules.payara.tooling.utils.OsUtils;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Pair;
import org.openide.util.RequestProcessor;

public abstract class PayaraConfiguration
implements ContextRootConfiguration,
EjbResourceConfiguration,
MessageDestinationConfiguration,
DatasourceConfiguration {
    private static final Logger LOGGER = Logger.getLogger("payara-eecommon");
    private static final String RESOURCE_FILES_SUFFIX = ".xml";
    static final String[] RESOURCE_FILES = new String[]{"glassfish-resources.xml", "sun-resources.xml"};
    protected final J2eeModule module;
    protected final J2eeModuleHelper moduleHelper;
    protected final File primaryDD;
    protected final File secondaryDD;
    protected DescriptorListener descriptorListener;
    protected PayaraVersion version;
    private ASDDVersion appServerVersion;
    private ASDDVersion minASVersion;
    private ASDDVersion maxASVersion;
    private boolean deferredAppServerChange;
    private final String defaultcr;
    private static String[] serverIds = new String[]{"pfv3ee6", "pfv4ee7", "pfv5ee8"};
    private static final RequestProcessor RP = new RequestProcessor("PayaraConfiguration.setContextRoot");
    private static final Object configurationMonitor = new Object();
    private static final WeakHashMap<File, WeakReference<PayaraConfiguration>> configurationMap = new WeakHashMap();

    private static String resourceFilePath(J2eeModule module, String fileName) {
        String configDir = JavaEEModule.getConfigDir(module.getType());
        if (configDir == null) {
            throw new IllegalArgumentException("Unknown Java EE module type.");
        }
        return OsUtils.joinPaths((String)configDir, (String)fileName);
    }

    private static int[] versionToResourceFilesIndexes(PayaraVersion version) {
        if (version == null) {
            return new int[]{0, 1};
        }
        if (PayaraVersion.ge((Enum)version, (Enum)PayaraVersion.PF_4_1_144)) {
            return new int[]{0};
        }
        return new int[]{1};
    }

    private static int versionToNewResourceFilesIndex(PayaraVersion version) {
        if (version == null || PayaraVersion.ge((Enum)version, (Enum)PayaraVersion.PF_4_1_144)) {
            return 0;
        }
        return 1;
    }

    public static final Pair<File, Boolean> getExistingResourceFile(J2eeModule module, PayaraVersion version) {
        int[] indexes;
        for (int index : indexes = PayaraConfiguration.versionToResourceFilesIndexes(version)) {
            String name = PayaraConfiguration.resourceFilePath(module, RESOURCE_FILES[index]);
            File file = module.getDeploymentConfigurationFile(name);
            if (file != null && file.isFile() && file.canRead()) {
                return Pair.of((Object)file, (Object)true);
            }
            file = new File(module.getResourceDirectory(), RESOURCE_FILES[index]);
            if (file.isFile() && file.canRead()) {
                return Pair.of((Object)file, (Object)false);
            }
            file = new File(module.getResourceDirectory(), "glassfish-resources");
            if (!file.isFile() || !file.canRead()) continue;
            return Pair.of((Object)file, (Object)false);
        }
        return null;
    }

    public static final Pair<File, Boolean> getNewResourceFile(J2eeModule module, PayaraVersion version) {
        int index = PayaraConfiguration.versionToNewResourceFilesIndex(version);
        if (PayaraVersion.lt((Enum)version, (Enum)PayaraVersion.PF_4_1_144)) {
            return Pair.of((Object)new File(module.getResourceDirectory(), RESOURCE_FILES[index]), (Object)false);
        }
        String name = PayaraConfiguration.resourceFilePath(module, RESOURCE_FILES[index]);
        return Pair.of((Object)module.getDeploymentConfigurationFile(name), (Object)true);
    }

    protected PayaraConfiguration(J2eeModule module, PayaraVersion version) throws ConfigurationException {
        this(module, J2eeModuleHelper.getSunDDModuleHelper(module.getType()), version);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected PayaraConfiguration(J2eeModule module, J2eeModuleHelper moduleHelper, PayaraVersion version) throws ConfigurationException {
        this.module = module;
        this.moduleHelper = moduleHelper;
        this.version = version;
        if (moduleHelper == null) throw new ConfigurationException("Unsupported module type: " + module.getType());
        this.primaryDD = moduleHelper.getPrimaryDDFile(module);
        this.secondaryDD = moduleHelper.getSecondaryDDFile(module);
        if (null == this.primaryDD) {
            throw new ConfigurationException("No primaryDD for module type: " + module.getType());
        }
        try {
            String path;
            int dex;
            if (null == this.primaryDD.getParentFile()) {
                throw new ConfigurationException("module is not initialized completely");
            }
            PayaraConfiguration.addConfiguration(this.primaryDD, this);
            this.defaultcr = this.primaryDD.getName().endsWith("-web.xml") ? ((dex = (path = this.primaryDD.getParent().replaceAll("[\\\\/]web[\\\\/]WEB-INF", "").replaceAll("[\\\\/]src[\\\\/]main[\\\\/]webapp[\\\\/]WEB-INF", "")).lastIndexOf(File.separatorChar)) < 0 ? null : "/" + path.substring(dex + 1)) : null;
            this.appServerVersion = ASDDVersion.SUN_APPSERVER_8_1;
            this.deferredAppServerChange = false;
            J2eeModule.Type mt = module.getType();
            String moduleVersion = module.getModuleVersion();
            this.minASVersion = this.computeMinASVersion(moduleVersion);
            this.appServerVersion = this.maxASVersion = this.computeMaxASVersion();
            J2EEBaseVersion j2eeVersion = J2EEBaseVersion.getVersion(mt, moduleVersion);
            if (j2eeVersion == null) return;
            if (J2EEVersion.JAVAEE_5_0.compareSpecification(j2eeVersion) < 0) return;
            return;
        }
        catch (RuntimeException ex) {
            PayaraConfiguration.removeConfiguration(this.primaryDD);
            ConfigurationException ce = new ConfigurationException(this.primaryDD.getAbsolutePath(), (Throwable)ex);
            throw ce;
        }
    }

    @Deprecated
    public PayaraConfiguration() {
        throw new UnsupportedOperationException("JSR-88 configuration not supported.");
    }

    public void dispose() {
        PayaraConfiguration storedCfg;
        if (this.descriptorListener != null) {
            this.descriptorListener.removeListeners();
            this.descriptorListener = null;
        }
        if ((storedCfg = PayaraConfiguration.getConfiguration(this.primaryDD)) != this) {
            LOGGER.log(Level.INFO, "Stored DeploymentConfiguration ({0}) instance not the one being disposed of ({1}).", new Object[]{storedCfg, this});
        }
        if (storedCfg != null) {
            PayaraConfiguration.removeConfiguration(this.primaryDD);
        }
    }

    private ASDDVersion computeMinASVersion(String j2eeModuleVersion) {
        return this.moduleHelper.getMinASVersion(j2eeModuleVersion, ASDDVersion.SUN_APPSERVER_7_0);
    }

    private ASDDVersion computeMaxASVersion() {
        ASDDVersion result = this.getTargetAppServerVersion();
        if (result == null) {
            result = this.primaryDD.getName().startsWith("glassfish-") ? ASDDVersion.SUN_APPSERVER_10_1 : ASDDVersion.SUN_APPSERVER_10_0;
            LOGGER.log(Level.WARNING, NbBundle.getMessage(PayaraConfiguration.class, (String)"ERR_UnidentifiedTargetServer", (Object)result.toString()));
        }
        return result;
    }

    public ASDDVersion getMinASVersion() {
        return this.minASVersion;
    }

    public ASDDVersion getMaxASVersion() {
        return this.maxASVersion;
    }

    public ASDDVersion getAppServerVersion() {
        return this.appServerVersion;
    }

    public void setAppServerVersion(ASDDVersion asVersion) {
        if (asVersion.compareTo((Object)this.getMinASVersion()) < 0) {
            throw new IllegalArgumentException(asVersion.toString() + " is lower than required minimum version " + this.getMinASVersion().toString());
        }
        if (asVersion.compareTo((Object)this.getMaxASVersion()) > 0) {
            throw new IllegalArgumentException(asVersion.toString() + " is higher than required maximum version " + this.getMaxASVersion().toString());
        }
        if (!asVersion.equals(this.appServerVersion) || this.deferredAppServerChange) {
            this.appServerVersion = asVersion;
            this.deferredAppServerChange = false;
        }
    }

    void internalSetAppServerVersion(ASDDVersion asVersion) {
        if (!asVersion.equals(this.appServerVersion)) {
            this.appServerVersion = asVersion;
            this.deferredAppServerChange = true;
        }
    }

    protected ASDDVersion getTargetAppServerVersion() {
        ASDDVersion result = null;
        J2eeModuleProvider provider = this.getProvider(this.primaryDD.getParentFile());
        if (null == provider) {
            return result;
        }
        String serverType = Utils.getInstanceReleaseID(provider);
        if (Arrays.asList(serverIds).contains(serverType)) {
            String instance = provider.getServerInstanceID();
            if (Utils.notEmpty(instance)) {
                try {
                    File asInstallFolder;
                    String asInstallPath = instance.substring(1, instance.indexOf("]deployer:"));
                    if (asInstallPath.contains(File.pathSeparator)) {
                        asInstallPath = asInstallPath.substring(0, asInstallPath.indexOf(File.pathSeparator));
                    }
                    if ((asInstallFolder = new File(asInstallPath)).exists()) {
                        result = this.getInstalledAppServerVersion(asInstallFolder);
                    }
                }
                catch (IndexOutOfBoundsException ex) {
                    LOGGER.log(Level.WARNING, NbBundle.getMessage(PayaraConfiguration.class, (String)"ERR_NoServerInstallLocation", (Object)instance));
                }
                catch (NullPointerException ex) {
                    LOGGER.log(Level.INFO, ex.getLocalizedMessage(), ex);
                }
            }
        } else if ("SUNWebserver7".equals(serverType)) {
            result = ASDDVersion.SUN_APPSERVER_8_1;
        }
        return result;
    }

    protected ASDDVersion getInstalledAppServerVersion(File asInstallFolder) {
        return PayaraConfiguration.getInstalledAppServerVersionFromDirectory(asInstallFolder);
    }

    static ASDDVersion getInstalledAppServerVersionFromDirectory(File asInstallFolder) {
        File dtdFolder = new File(asInstallFolder, "lib/dtds/");
        if (dtdFolder.exists()) {
            if (new File(dtdFolder, "payara-web-app_4.dtd").exists()) {
                return ASDDVersion.SUN_APPSERVER_10_1;
            }
            if (new File(dtdFolder, "glassfish-web-app_3_0-1.dtd").exists()) {
                return ASDDVersion.SUN_APPSERVER_10_1;
            }
            if (new File(dtdFolder, "sun-web-app_3_0-0.dtd").exists()) {
                return ASDDVersion.SUN_APPSERVER_10_0;
            }
            if (new File(dtdFolder, "sun-domain_1_3.dtd").exists()) {
                return ASDDVersion.SUN_APPSERVER_9_0;
            }
            if (new File(dtdFolder, "sun-domain_1_2.dtd").exists()) {
                return ASDDVersion.SUN_APPSERVER_9_0;
            }
            if (new File(dtdFolder, "sun-domain_1_1.dtd").exists()) {
                return ASDDVersion.SUN_APPSERVER_8_1;
            }
            if (new File(dtdFolder, "sun-domain_1_0.dtd").exists()) {
                return ASDDVersion.SUN_APPSERVER_7_0;
            }
        }
        return null;
    }

    protected void createDefaultSunDD(File sunDDFile) throws IOException {
        FileObject sunDDTemplate = Utils.getSunDDFromProjectsModuleVersion(this.module, sunDDFile.getName());
        if (sunDDTemplate != null) {
            FileObject configFolder = FileUtil.createFolder((File)sunDDFile.getParentFile());
            FileSystem fs = configFolder.getFileSystem();
            XmlFileCreator creator = new XmlFileCreator(sunDDTemplate, configFolder, sunDDTemplate.getName(), sunDDTemplate.getExt());
            fs.runAtomicAction((FileSystem.AtomicAction)creator);
        }
    }

    public J2eeModule getJ2eeModule() {
        return this.module;
    }

    public J2EEBaseVersion getJ2eeVersion() {
        return J2EEBaseVersion.getVersion(this.module.getType(), this.module.getModuleVersion());
    }

    public final org.netbeans.modules.j2ee.dd.api.common.RootInterface getStandardRootDD() {
        org.netbeans.modules.j2ee.dd.api.common.RootInterface stdRootDD = null;
        J2eeModuleHelper j2eeModuleHelper = J2eeModuleHelper.getSunDDModuleHelper(this.module.getType());
        if (j2eeModuleHelper != null) {
            stdRootDD = j2eeModuleHelper.getStandardRootDD(this.module);
        }
        return stdRootDD;
    }

    public final Webservices getWebServicesRootDD() {
        Webservices wsRootDD = null;
        J2eeModuleHelper j2eeModuleHelper = J2eeModuleHelper.getSunDDModuleHelper(this.module.getType());
        if (j2eeModuleHelper != null) {
            wsRootDD = j2eeModuleHelper.getWebServicesRootDD(this.module);
        }
        return wsRootDD;
    }

    public <T> MetadataModel<T> getMetadataModel(Class<T> type) {
        return this.module.getMetadataModel(type);
    }

    protected J2eeModuleProvider getProvider(File file) {
        J2eeModuleProvider provider = null;
        if (file != null) {
            FileObject fo = FileUtil.toFileObject((File)(file = FileUtil.normalizeFile((File)file)));
            if (fo != null) {
                Project project = FileOwnerQuery.getOwner((FileObject)fo);
                if (project != null) {
                    Lookup lookup = project.getLookup();
                    provider = (J2eeModuleProvider)lookup.lookup(J2eeModuleProvider.class);
                }
            } else {
                File parent = file.getParentFile();
                if (parent != null) {
                    provider = this.getProvider(parent);
                }
            }
        }
        return provider;
    }

    void updateDefaultEjbJndiName(String ejbName, String prefix, ChangeOperation op) {
        try {
            FileObject primaryDDFO = this.getPayaraDD(this.primaryDD, op == ChangeOperation.CREATE);
            if (primaryDDFO != null) {
                boolean changed = false;
                RootInterface ddRoot = PayaraDDProvider.getDefault().getDDRoot(primaryDDFO);
                if (ddRoot instanceof SunEjbJar) {
                    SunEjbJar sunEjbJar = (SunEjbJar)ddRoot;
                    EnterpriseBeans eb = sunEjbJar.getEnterpriseBeans();
                    if (eb == null && op == ChangeOperation.CREATE) {
                        eb = sunEjbJar.newEnterpriseBeans();
                        sunEjbJar.setEnterpriseBeans(eb);
                    }
                    if (eb != null) {
                        Ejb ejb = (Ejb)this.findNamedBean((CommonDDBean)eb, ejbName, "Ejb", "EjbName");
                        if (ejb == null && op == ChangeOperation.CREATE) {
                            ejb = eb.newEjb();
                            ejb.setEjbName(ejbName);
                            eb.addEjb(ejb);
                        }
                        if (ejb != null) {
                            String defaultJndiName;
                            assert (ejbName.equals(ejb.getEjbName()));
                            String string = defaultJndiName = ejbName.startsWith(prefix) ? ejbName : prefix + ejbName;
                            if (op == ChangeOperation.CREATE && Utils.strEmpty(ejb.getJndiName())) {
                                ejb.setJndiName(defaultJndiName);
                                changed = true;
                            } else if (op == ChangeOperation.DELETE && Utils.strEquals(defaultJndiName, ejb.getJndiName())) {
                                ejb.setJndiName(null);
                                if (ejb.isTrivial("EjbName")) {
                                    eb.removeEjb(ejb);
                                    if (eb.isTrivial(null)) {
                                        sunEjbJar.setEnterpriseBeans(null);
                                    }
                                }
                                changed = true;
                            }
                        }
                    }
                }
                if (changed) {
                    ddRoot.write(primaryDDFO);
                }
            }
        }
        catch (IOException ex) {
            this.handleEventRelatedIOException(ex);
        }
        catch (Exception ex) {
            this.handleEventRelatedException(ex);
        }
    }

    void updateDefaultEjbEndpointUri(String linkName, String portName, ChangeOperation op) {
        try {
            FileObject primaryDDFO = this.getPayaraDD(this.primaryDD, true);
            if (primaryDDFO != null) {
                boolean changed = false;
                RootInterface ddRoot = PayaraDDProvider.getDefault().getDDRoot(primaryDDFO);
                if (ddRoot instanceof SunEjbJar) {
                    SunEjbJar sunEjbJar = (SunEjbJar)ddRoot;
                    EnterpriseBeans eb = sunEjbJar.getEnterpriseBeans();
                    if (eb == null && op == ChangeOperation.CREATE) {
                        eb = sunEjbJar.newEnterpriseBeans();
                        sunEjbJar.setEnterpriseBeans(eb);
                    }
                    if (eb != null) {
                        Ejb ejb = (Ejb)this.findNamedBean((CommonDDBean)eb, linkName, "Ejb", "EjbName");
                        if (ejb == null && op == ChangeOperation.CREATE) {
                            ejb = eb.newEjb();
                            ejb.setEjbName(linkName);
                            eb.addEjb(ejb);
                        }
                        if (ejb != null) {
                            assert (linkName.equals(ejb.getEjbName()));
                            WebserviceEndpoint endpoint = (WebserviceEndpoint)this.findNamedBean((CommonDDBean)ejb, portName, "WebserviceEndpoint", "PortComponentName");
                            if (endpoint == null && op == ChangeOperation.CREATE) {
                                endpoint = ejb.newWebserviceEndpoint();
                                endpoint.setPortComponentName(portName);
                                ejb.addWebserviceEndpoint(endpoint);
                            }
                            if (endpoint != null) {
                                assert (portName.equals(endpoint.getPortComponentName()));
                                if (op == ChangeOperation.CREATE && Utils.strEmpty(endpoint.getEndpointAddressUri())) {
                                    String defaultUri = portName;
                                    endpoint.setEndpointAddressUri(defaultUri);
                                    changed = true;
                                } else if (op == ChangeOperation.DELETE) {
                                    endpoint.setEndpointAddressUri(null);
                                    if (endpoint.isTrivial("PortComponentName")) {
                                        ejb.removeWebserviceEndpoint(endpoint);
                                        if (ejb.isTrivial("EjbName")) {
                                            eb.removeEjb(ejb);
                                            if (eb.isTrivial(null)) {
                                                sunEjbJar.setEnterpriseBeans(null);
                                            }
                                        }
                                    }
                                    changed = true;
                                }
                            }
                        }
                    }
                }
                if (changed) {
                    ddRoot.write(primaryDDFO);
                }
            }
        }
        catch (IOException ex) {
            this.handleEventRelatedIOException(ex);
        }
        catch (Exception ex) {
            this.handleEventRelatedException(ex);
        }
    }

    public String getContextRoot() throws ConfigurationException {
        String contextRoot;
        block7: {
            contextRoot = this.defaultcr;
            if (J2eeModule.Type.WAR.equals(this.module.getType())) {
                try {
                    RootInterface rootDD = this.getPayaraDDRoot(false);
                    if (!(rootDD instanceof SunWebApp)) break block7;
                    contextRoot = ((SunWebApp)rootDD).getContextRoot();
                    if (contextRoot != null && contextRoot.equals("/")) {
                        contextRoot = "";
                    } else if (null == contextRoot) {
                        contextRoot = this.defaultcr;
                    }
                }
                catch (IOException ex) {
                    LOGGER.log(Level.WARNING, ex.getLocalizedMessage(), ex);
                    String defaultMessage = " retrieving context-root from sun-web.xml";
                    this.displayError(ex, defaultMessage);
                }
            } else {
                LOGGER.log(Level.WARNING, "PayaraConfiguration.getContextRoot() invoked on incorrect module type: {0}", this.module.getType());
            }
        }
        return contextRoot;
    }

    public void setContextRoot(final String contextRoot) throws ConfigurationException {
        try {
            if (J2eeModule.Type.WAR.equals(this.module.getType())) {
                if (null != this.defaultcr && this.defaultcr.equals(contextRoot)) {
                    final FileObject sunDDFO = this.getPayaraDD(this.primaryDD, false);
                    if (null != sunDDFO) {
                        RP.post(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    RootInterface rootDD;
                                    if (sunDDFO != null && (rootDD = PayaraDDProvider.getDefault().getDDRoot(sunDDFO)) instanceof SunWebApp) {
                                        SunWebApp swa = (SunWebApp)rootDD;
                                        swa.setContextRoot(null);
                                        swa.write(sunDDFO);
                                    }
                                }
                                catch (IOException ex) {
                                    LOGGER.log(Level.INFO, ex.getLocalizedMessage(), ex);
                                    String defaultMessage = " trying set context-root in sun-web.xml";
                                    PayaraConfiguration.this.displayError(ex, defaultMessage);
                                }
                                catch (Exception ex) {
                                    LOGGER.log(Level.INFO, ex.getLocalizedMessage(), ex);
                                    String defaultMessage = " trying set context-root in sun-web.xml";
                                    PayaraConfiguration.this.displayError(ex, defaultMessage);
                                }
                            }
                        });
                    }
                } else {
                    final FileObject sunDDFO = this.getPayaraDD(this.primaryDD, true);
                    RP.post(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                RootInterface rootDD;
                                if (sunDDFO != null && (rootDD = PayaraDDProvider.getDefault().getDDRoot(sunDDFO)) instanceof SunWebApp) {
                                    SunWebApp swa = (SunWebApp)rootDD;
                                    if (contextRoot == null || contextRoot.trim().length() == 0) {
                                        swa.setContextRoot("/");
                                    } else {
                                        swa.setContextRoot(contextRoot);
                                    }
                                    swa.write(sunDDFO);
                                }
                            }
                            catch (IOException ex) {
                                LOGGER.log(Level.INFO, ex.getLocalizedMessage(), ex);
                                String defaultMessage = " trying set context-root in sun-web.xml";
                                PayaraConfiguration.this.displayError(ex, defaultMessage);
                            }
                            catch (Exception ex) {
                                LOGGER.log(Level.INFO, ex.getLocalizedMessage(), ex);
                                String defaultMessage = " trying set context-root in sun-web.xml";
                                PayaraConfiguration.this.displayError(ex, defaultMessage);
                            }
                        }
                    });
                }
            } else {
                LOGGER.log(Level.WARNING, "PayaraConfiguration.setContextRoot() invoked on incorrect module type: {0}", this.module.getType());
            }
        }
        catch (IOException ex) {
            throw new ConfigurationException("", (Throwable)ex);
        }
    }

    public abstract Set<Datasource> getDatasources() throws ConfigurationException;

    public abstract boolean supportsCreateDatasource();

    public abstract Datasource createDatasource(String var1, String var2, String var3, String var4, String var5) throws UnsupportedOperationException, ConfigurationException, DatasourceAlreadyExistsException;

    public void bindDatasourceReference(String referenceName, String jndiName) throws ConfigurationException {
        if (Utils.strEmpty(referenceName) || Utils.strEmpty(jndiName)) {
            return;
        }
        try {
            FileObject primaryDDFO = this.getPayaraDD(this.primaryDD, true);
            if (primaryDDFO != null) {
                RootInterface ddRoot = PayaraDDProvider.getDefault().getDDRoot(primaryDDFO);
                ResourceRef ref = (ResourceRef)this.findNamedBean((CommonDDBean)ddRoot, referenceName, "ResourceRef", "ResRefName");
                if (ref != null) {
                    assert (referenceName.equals(ref.getResRefName()));
                    ref.setJndiName(jndiName);
                } else {
                    if (ddRoot instanceof SunWebApp) {
                        ref = ((SunWebApp)ddRoot).newResourceRef();
                    } else if (ddRoot instanceof SunApplicationClient) {
                        ref = ((SunApplicationClient)ddRoot).newResourceRef();
                    }
                    if (null != ref) {
                        ref.setResRefName(referenceName);
                        ref.setJndiName(jndiName);
                        ddRoot.addValue("ResourceRef", (Object)ref);
                    }
                }
                ddRoot.write(primaryDDFO);
            }
        }
        catch (IOException ex) {
            String message = NbBundle.getMessage(PayaraConfiguration.class, (String)"ERR_ExceptionBindingResourceRef", (Object)ex.getClass().getSimpleName());
            throw new ConfigurationException(message, (Throwable)ex);
        }
        catch (Exception ex) {
            String message = NbBundle.getMessage(PayaraConfiguration.class, (String)"ERR_ExceptionBindingResourceRef", (Object)ex.getClass().getSimpleName());
            throw new ConfigurationException(message, (Throwable)ex);
        }
    }

    public void bindDatasourceReferenceForEjb(String ejbName, String ejbType, String referenceName, String jndiName) throws ConfigurationException {
        if (Utils.strEmpty(ejbName) || Utils.strEmpty(ejbType) || Utils.strEmpty(referenceName) || Utils.strEmpty(jndiName)) {
            return;
        }
        try {
            RootInterface ddRoot;
            FileObject primaryDDFO = this.getPayaraDD(this.primaryDD, true);
            if (primaryDDFO != null && (ddRoot = PayaraDDProvider.getDefault().getDDRoot(primaryDDFO)) instanceof SunEjbJar) {
                ResourceRef ref;
                Ejb ejb;
                SunEjbJar sunEjbJar = (SunEjbJar)ddRoot;
                EnterpriseBeans eb = sunEjbJar.getEnterpriseBeans();
                if (eb == null) {
                    eb = sunEjbJar.newEnterpriseBeans();
                    sunEjbJar.setEnterpriseBeans(eb);
                }
                if ((ejb = (Ejb)this.findNamedBean((CommonDDBean)eb, ejbName, "Ejb", "EjbName")) == null) {
                    ejb = eb.newEjb();
                    ejb.setEjbName(ejbName);
                    eb.addEjb(ejb);
                }
                if ((ref = (ResourceRef)this.findNamedBean((CommonDDBean)ejb, referenceName, "ResourceRef", "ResRefName")) != null) {
                    assert (referenceName.equals(ref.getResRefName()));
                    ref.setJndiName(jndiName);
                } else {
                    ref = ejb.newResourceRef();
                    ref.setResRefName(referenceName);
                    ref.setJndiName(jndiName);
                    ejb.addValue("ResourceRef", (Object)ref);
                }
                sunEjbJar.write(primaryDDFO);
            }
        }
        catch (IOException ex) {
            String message = NbBundle.getMessage(PayaraConfiguration.class, (String)"ERR_ExceptionBindingResourceRef", (Object)ex.getClass().getSimpleName());
            throw new ConfigurationException(message, (Throwable)ex);
        }
        catch (Exception ex) {
            String message = NbBundle.getMessage(PayaraConfiguration.class, (String)"ERR_ExceptionBindingResourceRef", (Object)ex.getClass().getSimpleName());
            throw new ConfigurationException(message, (Throwable)ex);
        }
    }

    public String findDatasourceJndiName(String referenceName) throws ConfigurationException {
        if (Utils.strEmpty(referenceName)) {
            return null;
        }
        String jndiName = null;
        try {
            RootInterface ddRoot = this.getPayaraDDRoot(false);
            ResourceRef ref = (ResourceRef)this.findNamedBean((CommonDDBean)ddRoot, referenceName, "ResourceRef", "ResRefName");
            if (ref != null) {
                assert (referenceName.equals(ref.getResRefName()));
                jndiName = ref.getJndiName();
            }
        }
        catch (IOException ex) {
            String message = NbBundle.getMessage(PayaraConfiguration.class, (String)"ERR_ExceptionReadingResourceRef", (Object)ex.getClass().getSimpleName());
            throw new ConfigurationException(message, (Throwable)ex);
        }
        catch (Exception ex) {
            String message = NbBundle.getMessage(PayaraConfiguration.class, (String)"ERR_ExceptionReadingResourceRef", (Object)ex.getClass().getSimpleName());
            throw new ConfigurationException(message, (Throwable)ex);
        }
        return jndiName;
    }

    public String findDatasourceJndiNameForEjb(String ejbName, String referenceName) throws ConfigurationException {
        if (Utils.strEmpty(ejbName) || Utils.strEmpty(referenceName)) {
            return null;
        }
        String jndiName = null;
        try {
            ResourceRef ref;
            Ejb ejb;
            SunEjbJar sunEjbJar;
            EnterpriseBeans eb;
            RootInterface ddRoot = this.getPayaraDDRoot(false);
            if (ddRoot instanceof SunEjbJar && (eb = (sunEjbJar = (SunEjbJar)ddRoot).getEnterpriseBeans()) != null && (ejb = (Ejb)this.findNamedBean((CommonDDBean)eb, ejbName, "Ejb", "EjbName")) != null && (ref = (ResourceRef)this.findNamedBean((CommonDDBean)ejb, referenceName, "ResourceRef", "ResRefName")) != null) {
                assert (referenceName.equals(ref.getResRefName()));
                jndiName = ref.getJndiName();
            }
        }
        catch (IOException ex) {
            String message = NbBundle.getMessage(PayaraConfiguration.class, (String)"ERR_ExceptionReadingResourceRef", (Object)ex.getClass().getSimpleName());
            throw new ConfigurationException(message, (Throwable)ex);
        }
        catch (Exception ex) {
            String message = NbBundle.getMessage(PayaraConfiguration.class, (String)"ERR_ExceptionReadingResourceRef", (Object)ex.getClass().getSimpleName());
            throw new ConfigurationException(message, (Throwable)ex);
        }
        return jndiName;
    }

    public String findJndiNameForEjb(String ejbName) throws ConfigurationException {
        if (Utils.strEmpty(ejbName)) {
            return null;
        }
        String jndiName = null;
        try {
            Ejb ejb;
            SunEjbJar sunEjbJar;
            EnterpriseBeans eb;
            RootInterface ddRoot = this.getPayaraDDRoot(false);
            if (ddRoot instanceof SunEjbJar && (eb = (sunEjbJar = (SunEjbJar)ddRoot).getEnterpriseBeans()) != null && (ejb = (Ejb)this.findNamedBean((CommonDDBean)eb, ejbName, "Ejb", "EjbName")) != null) {
                assert (ejbName.equals(ejb.getEjbName()));
                jndiName = ejb.getJndiName();
            }
        }
        catch (IOException ex) {
            String message = NbBundle.getMessage(PayaraConfiguration.class, (String)"ERR_ExceptionReadingEjb", (Object)ex.getClass().getSimpleName());
            throw new ConfigurationException(message, (Throwable)ex);
        }
        catch (Exception ex) {
            String message = NbBundle.getMessage(PayaraConfiguration.class, (String)"ERR_ExceptionReadingEjb", (Object)ex.getClass().getSimpleName());
            throw new ConfigurationException(message, (Throwable)ex);
        }
        return jndiName;
    }

    public void bindEjbReference(String referenceName, String jndiName) throws ConfigurationException {
        if (Utils.strEmpty(referenceName) || Utils.strEmpty(jndiName)) {
            return;
        }
        try {
            if (Double.parseDouble(this.module.getModuleVersion()) > 2.45) {
                return;
            }
        }
        catch (NumberFormatException ex) {
            LOGGER.log(Level.WARNING, ex.getLocalizedMessage(), ex);
        }
        try {
            FileObject primaryDDFO = this.getPayaraDD(this.primaryDD, true);
            if (primaryDDFO != null) {
                RootInterface ddRoot = PayaraDDProvider.getDefault().getDDRoot(primaryDDFO);
                EjbRef ref = (EjbRef)this.findNamedBean((CommonDDBean)ddRoot, referenceName, "EjbRef", "EjbRefName");
                if (ref != null) {
                    assert (referenceName.equals(ref.getEjbRefName()));
                    ref.setJndiName(jndiName);
                } else {
                    if (ddRoot instanceof SunWebApp) {
                        ref = ((SunWebApp)ddRoot).newEjbRef();
                    } else if (ddRoot instanceof SunApplicationClient) {
                        ref = ((SunApplicationClient)ddRoot).newEjbRef();
                    }
                    if (ref != null) {
                        ref.setEjbRefName(referenceName);
                        ref.setJndiName(jndiName);
                        ddRoot.addValue("EjbRef", (Object)ref);
                    }
                }
                ddRoot.write(primaryDDFO);
            }
        }
        catch (IOException ex) {
            String message = NbBundle.getMessage(PayaraConfiguration.class, (String)"ERR_ExceptionBindingEjbRef", (Object)ex.getClass().getSimpleName());
            throw new ConfigurationException(message, (Throwable)ex);
        }
        catch (Exception ex) {
            String message = NbBundle.getMessage(PayaraConfiguration.class, (String)"ERR_ExceptionBindingEjbRef", (Object)ex.getClass().getSimpleName());
            throw new ConfigurationException(message, (Throwable)ex);
        }
    }

    public void bindEjbReferenceForEjb(String ejbName, String ejbType, String referenceName, String jndiName) throws ConfigurationException {
        if (Utils.strEmpty(ejbName) || Utils.strEmpty(ejbType) || Utils.strEmpty(referenceName) || Utils.strEmpty(jndiName)) {
            return;
        }
        try {
            if (Double.parseDouble(this.module.getModuleVersion()) > 2.15) {
                return;
            }
        }
        catch (NumberFormatException ex) {
            LOGGER.log(Level.WARNING, ex.getLocalizedMessage(), ex);
        }
        try {
            RootInterface ddRoot;
            FileObject primaryDDFO = this.getPayaraDD(this.primaryDD, true);
            if (primaryDDFO != null && (ddRoot = PayaraDDProvider.getDefault().getDDRoot(primaryDDFO)) instanceof SunEjbJar) {
                EjbRef ref;
                Ejb ejb;
                SunEjbJar sunEjbJar = (SunEjbJar)ddRoot;
                EnterpriseBeans eb = sunEjbJar.getEnterpriseBeans();
                if (eb == null) {
                    eb = sunEjbJar.newEnterpriseBeans();
                    sunEjbJar.setEnterpriseBeans(eb);
                }
                if ((ejb = (Ejb)this.findNamedBean((CommonDDBean)eb, ejbName, "Ejb", "EjbName")) == null) {
                    ejb = eb.newEjb();
                    ejb.setEjbName(ejbName);
                    eb.addEjb(ejb);
                }
                if ((ref = (EjbRef)this.findNamedBean((CommonDDBean)ejb, referenceName, "EjbRef", "EjbRefName")) != null) {
                    assert (referenceName.equals(ref.getEjbRefName()));
                    ref.setJndiName(jndiName);
                } else {
                    ref = ejb.newEjbRef();
                    ref.setEjbRefName(referenceName);
                    ref.setJndiName(jndiName);
                    ejb.addValue("EjbRef", (Object)ref);
                }
                sunEjbJar.write(primaryDDFO);
            }
        }
        catch (IOException ex) {
            String message = NbBundle.getMessage(PayaraConfiguration.class, (String)"ERR_ExceptionBindingEjbRef", (Object)ex.getClass().getSimpleName());
            throw new ConfigurationException(message, (Throwable)ex);
        }
        catch (Exception ex) {
            String message = NbBundle.getMessage(PayaraConfiguration.class, (String)"ERR_ExceptionBindingEjbRef", (Object)ex.getClass().getSimpleName());
            throw new ConfigurationException(message, (Throwable)ex);
        }
    }

    public abstract Set<org.netbeans.modules.j2ee.deployment.common.api.MessageDestination> getMessageDestinations() throws ConfigurationException;

    public abstract boolean supportsCreateMessageDestination();

    public abstract org.netbeans.modules.j2ee.deployment.common.api.MessageDestination createMessageDestination(String var1, MessageDestination.Type var2) throws UnsupportedOperationException, ConfigurationException;

    public void bindMdbToMessageDestination(String mdbName, String name, MessageDestination.Type type) throws ConfigurationException {
        if (Utils.strEmpty(mdbName) || Utils.strEmpty(name)) {
            return;
        }
        try {
            RootInterface ddRoot;
            FileObject primaryDDFO = this.getPayaraDD(this.primaryDD, true);
            if (primaryDDFO != null && (ddRoot = PayaraDDProvider.getDefault().getDDRoot(primaryDDFO)) instanceof SunEjbJar) {
                Ejb ejb;
                SunEjbJar sunEjbJar = (SunEjbJar)ddRoot;
                EnterpriseBeans eb = sunEjbJar.getEnterpriseBeans();
                if (eb == null) {
                    eb = sunEjbJar.newEnterpriseBeans();
                    sunEjbJar.setEnterpriseBeans(eb);
                }
                if ((ejb = (Ejb)this.findNamedBean((CommonDDBean)eb, mdbName, "Ejb", "EjbName")) == null) {
                    ejb = eb.newEjb();
                    ejb.setEjbName(mdbName);
                    eb.addEjb(ejb);
                }
                ejb.setJndiName(name);
                String factory = name + "Factory";
                MdbConnectionFactory connFactory = ejb.newMdbConnectionFactory();
                connFactory.setJndiName(factory);
                ejb.setMdbConnectionFactory(connFactory);
                ddRoot.write(primaryDDFO);
            }
        }
        catch (IOException ex) {
            String message = NbBundle.getMessage(PayaraConfiguration.class, (String)"ERR_ExceptionBindingMdb", (Object)ex.getClass().getSimpleName());
            throw new ConfigurationException(message, (Throwable)ex);
        }
        catch (Exception ex) {
            String message = NbBundle.getMessage(PayaraConfiguration.class, (String)"ERR_ExceptionBindingMdb", (Object)ex.getClass().getSimpleName());
            throw new ConfigurationException(message, (Throwable)ex);
        }
    }

    public String findMessageDestinationName(String mdbName) throws ConfigurationException {
        if (Utils.strEmpty(mdbName)) {
            return null;
        }
        String destinationName = null;
        try {
            Ejb ejb;
            SunEjbJar sunEjbJar;
            EnterpriseBeans eb;
            RootInterface ddRoot = this.getPayaraDDRoot(false);
            if (ddRoot instanceof SunEjbJar && (eb = (sunEjbJar = (SunEjbJar)ddRoot).getEnterpriseBeans()) != null && (ejb = (Ejb)this.findNamedBean((CommonDDBean)eb, mdbName, "Ejb", "EjbName")) != null) {
                assert (mdbName.equals(ejb.getEjbName()));
                destinationName = ejb.getJndiName();
            }
        }
        catch (IOException ex) {
            String message = NbBundle.getMessage(PayaraConfiguration.class, (String)"ERR_ExceptionBindingMdb", (Object)ex.getClass().getSimpleName());
            throw new ConfigurationException(message, (Throwable)ex);
        }
        catch (Exception ex) {
            String message = NbBundle.getMessage(PayaraConfiguration.class, (String)"ERR_ExceptionBindingMdb", (Object)ex.getClass().getSimpleName());
            throw new ConfigurationException(message, (Throwable)ex);
        }
        return destinationName;
    }

    public void bindMessageDestinationReference(String referenceName, String connectionFactoryName, String destName, MessageDestination.Type type) throws ConfigurationException {
        if (Utils.strEmpty(referenceName) || Utils.strEmpty(connectionFactoryName) || Utils.strEmpty(destName)) {
            return;
        }
        try {
            FileObject primaryDDFO = this.getPayaraDD(this.primaryDD, true);
            if (primaryDDFO != null) {
                RootInterface ddRoot = PayaraDDProvider.getDefault().getDDRoot(primaryDDFO);
                MessageDestinationRef destRef = (MessageDestinationRef)this.findNamedBean((CommonDDBean)ddRoot, referenceName, "MessageDestinationRef", "MessageDestinationRefName");
                if (destRef != null) {
                    assert (referenceName.equals(destRef.getMessageDestinationRefName()));
                    destRef.setJndiName(referenceName);
                } else {
                    if (ddRoot instanceof SunWebApp) {
                        destRef = ((SunWebApp)ddRoot).newMessageDestinationRef();
                    } else if (ddRoot instanceof SunApplicationClient) {
                        destRef = ((SunApplicationClient)ddRoot).newMessageDestinationRef();
                    }
                    if (null != destRef) {
                        destRef.setJndiName(referenceName);
                        destRef.setMessageDestinationRefName(referenceName);
                        ddRoot.addValue("MessageDestinationRef", (Object)destRef);
                    }
                }
                ResourceRef factoryRef = (ResourceRef)this.findNamedBean((CommonDDBean)ddRoot, connectionFactoryName, "ResourceRef", "ResRefName");
                if (factoryRef != null) {
                    assert (connectionFactoryName.equals(factoryRef.getResRefName()));
                    factoryRef.setJndiName(connectionFactoryName);
                } else {
                    if (ddRoot instanceof SunWebApp) {
                        factoryRef = ((SunWebApp)ddRoot).newResourceRef();
                    } else if (ddRoot instanceof SunApplicationClient) {
                        factoryRef = ((SunApplicationClient)ddRoot).newResourceRef();
                    }
                    if (null != factoryRef) {
                        factoryRef.setResRefName(connectionFactoryName);
                        factoryRef.setJndiName(connectionFactoryName);
                        ddRoot.addValue("ResourceRef", (Object)factoryRef);
                    }
                }
                ddRoot.write(primaryDDFO);
            }
        }
        catch (IOException ex) {
            String message = NbBundle.getMessage(PayaraConfiguration.class, (String)"ERR_ExceptionBindingMdb", (Object)ex.getClass().getSimpleName());
            throw new ConfigurationException(message, (Throwable)ex);
        }
        catch (Exception ex) {
            String message = NbBundle.getMessage(PayaraConfiguration.class, (String)"ERR_ExceptionBindingMdb", (Object)ex.getClass().getSimpleName());
            throw new ConfigurationException(message, (Throwable)ex);
        }
    }

    public void bindMessageDestinationReferenceForEjb(String ejbName, String ejbType, String referenceName, String connectionFactoryName, String destName, MessageDestination.Type type) throws ConfigurationException {
        try {
            FileObject primaryDDFO = this.getPayaraDD(this.primaryDD, true);
            if (primaryDDFO != null) {
                Ejb ejb;
                RootInterface ddRoot = PayaraDDProvider.getDefault().getDDRoot(primaryDDFO);
                SunEjbJar sunEjbJar = (SunEjbJar)ddRoot;
                EnterpriseBeans eb = sunEjbJar.getEnterpriseBeans();
                if (eb == null) {
                    eb = sunEjbJar.newEnterpriseBeans();
                    sunEjbJar.setEnterpriseBeans(eb);
                }
                if ((ejb = (Ejb)this.findNamedBean((CommonDDBean)eb, ejbName, "Ejb", "EjbName")) == null) {
                    ejb = eb.newEjb();
                    ejb.setEjbName(ejbName);
                    eb.addEjb(ejb);
                }
                if ("Session".equals(ejbType) || "Entity".equals(ejbType)) {
                    ResourceRef ref = (ResourceRef)this.findNamedBean((CommonDDBean)ejb, connectionFactoryName, "ResourceRef", "ResRefName");
                    if (ref != null) {
                        assert (referenceName.equals(ref.getResRefName()));
                        ref.setJndiName(connectionFactoryName);
                    } else {
                        ref = ejb.newResourceRef();
                        ref.setResRefName(connectionFactoryName);
                        ref.setJndiName(connectionFactoryName);
                        ejb.addResourceRef(ref);
                    }
                    MessageDestinationRef destRef = (MessageDestinationRef)this.findNamedBean((CommonDDBean)ejb, referenceName, "MessageDestinationRef", "MessageDestinationRefName");
                    if (destRef != null) {
                        assert (referenceName.equals(destRef.getMessageDestinationRefName()));
                        destRef.setJndiName(referenceName);
                    } else {
                        destRef = ejb.newMessageDestinationRef();
                        destRef.setJndiName(referenceName);
                        destRef.setMessageDestinationRefName(referenceName);
                        ejb.addMessageDestinationRef(destRef);
                    }
                } else if ("MessageDriven".equals(ejbType)) {
                    ejb.setJndiName(referenceName);
                    MdbConnectionFactory connFactory = ejb.newMdbConnectionFactory();
                    connFactory.setJndiName(connectionFactoryName);
                    ejb.setMdbConnectionFactory(connFactory);
                    MessageDestination destination = (MessageDestination)this.findNamedBean((CommonDDBean)eb, referenceName, "MessageDestination", "JndiName");
                    if (destination == null) {
                        destination = eb.newMessageDestination();
                        destination.setJndiName(referenceName);
                        eb.addMessageDestination(destination);
                    }
                }
                ddRoot.write(primaryDDFO);
            }
        }
        catch (IOException ex) {
            String message = NbBundle.getMessage(PayaraConfiguration.class, (String)"ERR_ExceptionBindingMdb", (Object)ex.getClass().getSimpleName());
            throw new ConfigurationException(message, (Throwable)ex);
        }
        catch (Exception ex) {
            String message = NbBundle.getMessage(PayaraConfiguration.class, (String)"ERR_ExceptionBindingMdb", (Object)ex.getClass().getSimpleName());
            throw new ConfigurationException(message, (Throwable)ex);
        }
    }

    public void saveConfiguration(OutputStream outputStream) throws ConfigurationException {
        try {
            if (this.module.getType().equals(J2eeModule.Type.WAR)) {
                FileObject configFO = FileUtil.toFileObject((File)this.primaryDD);
                if (configFO != null) {
                    RootInterface rootDD = PayaraDDProvider.getDefault().getDDRoot(configFO);
                    rootDD.write(outputStream);
                }
            } else {
                LOGGER.log(Level.WARNING, "Deployment plan not supported in PayaraConfiguration.save()");
            }
        }
        catch (Exception ex) {
            throw new ConfigurationException(ex.getMessage(), (Throwable)ex);
        }
    }

    protected RootInterface getPayaraDDRoot(boolean create) throws IOException {
        RootInterface payaraDDRoot = null;
        FileObject primaryDDFO = this.getPayaraDD(this.primaryDD, create);
        if (primaryDDFO != null) {
            payaraDDRoot = PayaraDDProvider.getDefault().getDDRoot(primaryDDFO);
        } else {
            FileObject secondaryDDFO = this.getPayaraDD(this.secondaryDD, create);
            if (secondaryDDFO != null) {
                payaraDDRoot = DDProvider.getDefault().getDDRoot(secondaryDDFO);
            }
        }
        return payaraDDRoot;
    }

    public RootInterface getPayaraDDRoot(File payaraDD, boolean create) throws IOException {
        RootInterface payaraDDRoot = null;
        FileObject primaryDDFO = this.getPayaraDD(payaraDD, create);
        if (primaryDDFO != null) {
            payaraDDRoot = PayaraDDProvider.getDefault().getDDRoot(primaryDDFO);
        }
        return payaraDDRoot;
    }

    protected FileObject getPayaraDD(File payaraDDFile, boolean create) throws IOException {
        if (!payaraDDFile.exists()) {
            if (create) {
                this.createDefaultSunDD(payaraDDFile);
            } else {
                return null;
            }
        }
        return FileUtil.toFileObject((File)payaraDDFile);
    }

    protected void displayError(Exception ex, String defaultMessage) {
        String message = ex.getLocalizedMessage();
        if (message == null || message.length() == 0) {
            message = ex.getClass().getSimpleName() + defaultMessage;
        }
        NotifyDescriptor.Message msg = new NotifyDescriptor.Message((Object)message, 0);
        DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)msg);
    }

    protected <T extends CommonDDBean> T findNamedBean(CommonDDBean parentDD, String referenceName, String beanProp, String nameProp) {
        CommonDDBean result = null;
        CommonDDBean[] beans = (CommonDDBean[])parentDD.getValues(beanProp);
        if (beans != null) {
            for (int i = 0; i < beans.length; ++i) {
                String name = (String)beans[i].getValue(nameProp);
                if (!referenceName.equals(name)) continue;
                result = beans[i];
                break;
            }
        }
        return (T)result;
    }

    void addDescriptorListener(FileObject target) {
        this.addDescriptorListener((org.netbeans.modules.j2ee.dd.api.common.RootInterface)("webservices.xml".equals(target.getNameExt()) ? this.getWebServicesRootDD() : this.getStandardRootDD()));
    }

    private void addDescriptorListener(org.netbeans.modules.j2ee.dd.api.common.RootInterface rootDD) {
        if (rootDD != null) {
            this.descriptorListener.addListener(rootDD);
        }
    }

    protected void handleEventRelatedIOException(IOException ex) {
        LOGGER.log(Level.INFO, ex.getLocalizedMessage(), ex);
    }

    protected void handleEventRelatedException(Exception ex) {
        LOGGER.log(Level.INFO, ex.getLocalizedMessage(), ex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addConfiguration(File key, PayaraConfiguration config) {
        Object object = configurationMonitor;
        synchronized (object) {
            configurationMap.put(key, new WeakReference<PayaraConfiguration>(config));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeConfiguration(File key) {
        Object object = configurationMonitor;
        synchronized (object) {
            configurationMap.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PayaraConfiguration getConfiguration(File key) {
        PayaraConfiguration config = null;
        WeakReference<PayaraConfiguration> ref = null;
        Object object = configurationMonitor;
        synchronized (object) {
            ref = configurationMap.get(key);
        }
        if (ref != null) {
            config = (PayaraConfiguration)ref.get();
        }
        return config;
    }

    public static enum ChangeOperation {
        CREATE,
        DELETE;

    }
}

