/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.payara.common.nodes;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFileChooser;
import org.netbeans.modules.payara.common.CommonServerSupport;
import org.netbeans.modules.payara.common.PartialCompletionException;
import org.netbeans.modules.payara.common.PayaraInstance;
import org.netbeans.modules.payara.common.nodes.Hk2ItemNode;
import org.netbeans.modules.payara.common.nodes.Refreshable;
import org.netbeans.modules.payara.common.nodes.actions.ConnectionPoolAdvancedAttributesCookie;
import org.netbeans.modules.payara.common.nodes.actions.DeployDirectoryCookie;
import org.netbeans.modules.payara.common.nodes.actions.DisableModulesCookie;
import org.netbeans.modules.payara.common.nodes.actions.EditDetailsCookie;
import org.netbeans.modules.payara.common.nodes.actions.EnableModulesCookie;
import org.netbeans.modules.payara.common.nodes.actions.RefreshModulesCookie;
import org.netbeans.modules.payara.common.nodes.actions.UndeployModuleCookie;
import org.netbeans.modules.payara.common.nodes.actions.UnregisterResourceCookie;
import org.netbeans.modules.payara.common.ui.BasePanel;
import org.netbeans.modules.payara.common.ui.ConnectionPoolAdvancedAttributesCustomizer;
import org.netbeans.modules.payara.common.utils.Util;
import org.netbeans.modules.payara.tooling.admin.Command;
import org.netbeans.modules.payara.tooling.admin.CommandDeleteResource;
import org.netbeans.modules.payara.tooling.admin.CommandDeploy;
import org.netbeans.modules.payara.tooling.admin.CommandDisable;
import org.netbeans.modules.payara.tooling.admin.CommandEnable;
import org.netbeans.modules.payara.tooling.admin.CommandGetProperty;
import org.netbeans.modules.payara.tooling.admin.CommandSetProperty;
import org.netbeans.modules.payara.tooling.admin.CommandUndeploy;
import org.netbeans.modules.payara.tooling.admin.ResultMap;
import org.netbeans.modules.payara.tooling.admin.ResultString;
import org.netbeans.modules.payara.tooling.admin.ServerAdmin;
import org.netbeans.modules.payara.tooling.data.PayaraServer;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.WindowManager;

public class Hk2Cookie {
    private static PayaraInstance getPayaraInstance(Lookup lookup) {
        CommonServerSupport commonModule = (CommonServerSupport)lookup.lookup(CommonServerSupport.class);
        return commonModule != null ? commonModule.getInstance() : null;
    }

    static class EditDetails
    extends Cookie
    implements EditDetailsCookie {
        private static final String QUERY_PREFIX = "resources.*";
        private static final String QUERY_ITEM = ".*";
        private static final String QUERY_SEPARATOR = ".";
        private final String query;
        final Class customizer;

        EditDetails(Lookup lookup, String name, String cmdSuffix, Class customizer) {
            super(lookup, name);
            int nameLen = name != null ? name.length() : 0;
            StringBuilder sb = new StringBuilder(QUERY_PREFIX.length() + QUERY_SEPARATOR.length() + nameLen + QUERY_ITEM.length());
            sb.append(QUERY_PREFIX);
            if (nameLen > 0 && !"jdbc-resource".equals(cmdSuffix)) {
                sb.append(QUERY_SEPARATOR);
                sb.append(name);
                sb.append(QUERY_ITEM);
            }
            this.query = sb.toString();
            this.customizer = customizer;
        }

        @Override
        public void openCustomizer() {
            final BasePanel retVal = this.getBasePanel();
            retVal.initializeUI();
            RequestProcessor.getDefault().post(new Runnable(){

                @Override
                public void run() {
                    if (instance != null) {
                        HashMap<String, String> value;
                        Future future = ServerAdmin.exec((PayaraServer)instance, (Command)new CommandGetProperty(query));
                        try {
                            ResultMap result = (ResultMap)future.get();
                            value = result.getValue();
                        }
                        catch (InterruptedException | ExecutionException ie) {
                            Logger.getLogger("payara").log(Level.INFO, ie.getMessage(), ie);
                            value = new HashMap<String, String>();
                        }
                        retVal.initializeData(name, value);
                    }
                }
            });
            DialogDescriptor dd = new DialogDescriptor((Object)retVal, NbBundle.getMessage(this.getClass(), (String)"TITLE_RESOURCE_EDIT", (Object)this.name), false, new ActionListener(){

                private void appendErrorReport(StringBuilder sb, String key, String value) {
                    if (sb.length() > 0) {
                        sb.append(", ");
                    }
                    sb.append(key);
                    sb.append("=");
                    sb.append(value != null ? value : "<null>");
                }

                @Override
                public void actionPerformed(ActionEvent event) {
                    if (event.getSource().equals(NotifyDescriptor.OK_OPTION) && instance != null) {
                        Map<String, String> properties = retVal.getData();
                        Set<String> keys = properties.keySet();
                        StringBuilder sb = new StringBuilder();
                        for (String key : keys) {
                            String value = properties.get(key);
                            Future future = ServerAdmin.exec((PayaraServer)instance, (Command)new CommandSetProperty(key, value));
                            try {
                                ResultString resultString = (ResultString)future.get();
                            }
                            catch (InterruptedException | ExecutionException ie) {
                                this.appendErrorReport(sb, key, value);
                            }
                        }
                        if (sb.length() > 0) {
                            Exceptions.printStackTrace((Throwable)new PartialCompletionException(sb.toString()));
                        }
                    }
                }
            });
            Dialog d = DialogDisplayer.getDefault().createDialog(dd);
            d.setVisible(true);
        }

        private BasePanel getBasePanel() {
            BasePanel temp;
            try {
                temp = (BasePanel)this.customizer.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
                temp = new BasePanel.Error();
                Exceptions.printStackTrace((Throwable)ex);
            }
            return temp;
        }
    }

    static class Refresh
    implements RefreshModulesCookie {
        private final Children children;

        Refresh(Children children) {
            this.children = children;
        }

        @Override
        public RequestProcessor.Task refresh() {
            return this.refresh(null, null);
        }

        @Override
        public RequestProcessor.Task refresh(String expected, String unexpected) {
            if (this.children instanceof Refreshable) {
                ((Refreshable)this.children).updateKeys();
                boolean foundExpected = expected == null;
                boolean foundUnexpected = false;
                for (Node node : this.children.getNodes()) {
                    if (!foundExpected && node.getDisplayName().equals(expected)) {
                        foundExpected = true;
                    }
                    if (foundUnexpected || !node.getDisplayName().equals(unexpected)) continue;
                    foundUnexpected = true;
                }
                if (!foundExpected) {
                    Logger.getLogger("payara").log(Level.WARNING, null, new IllegalStateException("did not find a child node, named " + expected));
                }
                if (foundUnexpected) {
                    Logger.getLogger("payara").log(Level.WARNING, null, new IllegalStateException("found unexpected child node, named " + unexpected));
                }
            }
            return null;
        }
    }

    static class Unregister
    extends Cookie
    implements UnregisterResourceCookie {
        final String cmdSuffix;
        final String cmdPropertyName;
        final boolean cascadeDelete;

        Unregister(Lookup lookup, String name, String cmdSuffix, String cmdPropertyName, boolean cascadeDelete) {
            super(lookup, name);
            this.cmdSuffix = cmdSuffix;
            this.cmdPropertyName = cmdPropertyName;
            this.cascadeDelete = cascadeDelete;
        }

        @Override
        public Future<ResultString> unregister() {
            if (this.instance != null) {
                Future future = ServerAdmin.exec((PayaraServer)this.instance, (Command)new CommandDeleteResource(this.name, this.cmdSuffix, this.cmdPropertyName, this.cascadeDelete));
                this.status = new WeakReference<Future>(future);
                return future;
            }
            return null;
        }
    }

    static class Deploy
    extends Cookie
    implements DeployDirectoryCookie {
        Deploy(Lookup lookup) {
            super(lookup, null);
        }

        @Override
        public Future<ResultString> deployDirectory() {
            JFileChooser chooser = new JFileChooser();
            chooser.setDialogTitle(NbBundle.getMessage(Hk2ItemNode.class, (String)"LBL_ChooseButton"));
            chooser.setDialogType(2);
            chooser.setFileSelectionMode(1);
            chooser.setMultiSelectionEnabled(false);
            int returnValue = chooser.showDialog(WindowManager.getDefault().getMainWindow(), NbBundle.getMessage(Hk2ItemNode.class, (String)"LBL_ChooseButton"));
            if (this.instance != null || returnValue != 0) {
                return null;
            }
            File dir = new File(chooser.getSelectedFile().getAbsolutePath());
            Future future = ServerAdmin.exec((PayaraServer)this.instance, (Command)new CommandDeploy(dir.getParentFile().getName(), Util.computeTarget(this.instance.getProperties()), dir, null, null, null, this.instance.isHotDeployEnabled()));
            this.status = new WeakReference<Future>(future);
            return future;
        }
    }

    static class Undeploy
    extends Cookie
    implements UndeployModuleCookie {
        Undeploy(Lookup lookup, String name) {
            super(lookup, name);
        }

        @Override
        public Future<ResultString> undeploy() {
            if (this.instance != null) {
                Future future = ServerAdmin.exec((PayaraServer)this.instance, (Command)new CommandUndeploy(this.name, Util.computeTarget(this.instance.getProperties())));
                this.status = new WeakReference<Future>(future);
                return future;
            }
            return null;
        }
    }

    static class ConnectionPoolAdvancedAttributes
    extends Cookie
    implements ConnectionPoolAdvancedAttributesCookie {
        private static final String QUERY_PREFIX = "resources.*";
        private static final String QUERY_ITEM = ".*";
        private static final String QUERY_SEPARATOR = ".";
        private final String query;
        final Class customizer;

        ConnectionPoolAdvancedAttributes(Lookup lookup, String name, String cmdSuffix, Class customizer) {
            super(lookup, name);
            int nameLen = name != null ? name.length() : 0;
            StringBuilder sb = new StringBuilder(QUERY_PREFIX.length() + QUERY_SEPARATOR.length() + nameLen + QUERY_ITEM.length());
            sb.append(QUERY_PREFIX);
            if (nameLen > 0 && !"jdbc-resource".equals(cmdSuffix)) {
                sb.append(QUERY_SEPARATOR);
                sb.append(name);
                sb.append(QUERY_ITEM);
            }
            this.query = sb.toString();
            this.customizer = customizer;
        }

        @Override
        public void openCustomizer() {
            final ConnectionPoolAdvancedAttributesCustomizer retVal = new ConnectionPoolAdvancedAttributesCustomizer();
            retVal.initializeUI();
            RequestProcessor.getDefault().post(new Runnable(){

                @Override
                public void run() {
                    if (instance != null) {
                        HashMap<String, String> value;
                        Future future = ServerAdmin.exec((PayaraServer)instance, (Command)new CommandGetProperty(query));
                        try {
                            ResultMap result = (ResultMap)future.get();
                            value = result.getValue();
                        }
                        catch (InterruptedException | ExecutionException ie) {
                            Logger.getLogger("payara").log(Level.INFO, ie.getMessage(), ie);
                            value = new HashMap<String, String>();
                        }
                        retVal.initializeData(name, value);
                    }
                }
            });
            DialogDescriptor dd = new DialogDescriptor((Object)retVal, NbBundle.getMessage(this.getClass(), (String)"TITLE_CONNECTION_POOL_ADVANCED_ATTRIBUTES", (Object)this.name), false, new ActionListener(){

                private void appendErrorReport(StringBuilder sb, String key, String value) {
                    if (sb.length() > 0) {
                        sb.append(", ");
                    }
                    sb.append(key);
                    sb.append("=");
                    sb.append(value != null ? value : "<null>");
                }

                @Override
                public void actionPerformed(ActionEvent event) {
                    if (event.getSource().equals(NotifyDescriptor.OK_OPTION) && instance != null) {
                        Map<String, String> properties = retVal.getData();
                        Set<String> keys = properties.keySet();
                        StringBuilder sb = new StringBuilder();
                        for (String key : keys) {
                            String value = properties.get(key);
                            Future future = ServerAdmin.exec((PayaraServer)instance, (Command)new CommandSetProperty(key, value));
                            try {
                                ResultString resultString = (ResultString)future.get();
                            }
                            catch (InterruptedException | ExecutionException ie) {
                                this.appendErrorReport(sb, key, value);
                            }
                        }
                        if (sb.length() > 0) {
                            Exceptions.printStackTrace((Throwable)new PartialCompletionException(sb.toString()));
                        }
                    }
                }
            });
            Dialog d = DialogDisplayer.getDefault().createDialog(dd);
            d.setVisible(true);
        }
    }

    static class Disable
    extends Cookie
    implements DisableModulesCookie {
        Disable(Lookup lookup, String name) {
            super(lookup, name);
        }

        @Override
        public Future<ResultString> disableModule() {
            if (this.instance != null) {
                Future future = ServerAdmin.exec((PayaraServer)this.instance, (Command)new CommandDisable(this.name, Util.computeTarget(this.instance.getProperties())));
                this.status = new WeakReference<Future>(future);
                return future;
            }
            return null;
        }
    }

    static class Enable
    extends Cookie
    implements EnableModulesCookie {
        Enable(Lookup lookup, String name) {
            super(lookup, name);
        }

        @Override
        public Future<ResultString> enableModule() {
            if (this.instance != null) {
                Future future = ServerAdmin.exec((PayaraServer)this.instance, (Command)new CommandEnable(this.name, Util.computeTarget(this.instance.getProperties())));
                this.status = new WeakReference<Future>(future);
                return future;
            }
            return null;
        }
    }

    protected static abstract class Cookie {
        protected volatile WeakReference<Future<ResultString>> status;
        protected final PayaraInstance instance;
        protected final String name;

        protected Cookie(Lookup lookup, String name) {
            this.instance = Hk2Cookie.getPayaraInstance(lookup);
            this.name = name;
        }

        public boolean isRunning() {
            WeakReference<Future<ResultString>> localref = this.status;
            if (localref == null) {
                return false;
            }
            Future future = (Future)localref.get();
            return future != null && !future.isDone();
        }
    }
}

