/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.payara.common;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import org.netbeans.modules.payara.common.parser.TreeParser;
import org.netbeans.modules.payara.common.wizards.ServerWizardIterator;
import org.netbeans.modules.payara.tooling.data.PayaraPlatformVersionAPI;
import org.netbeans.modules.payara.tooling.data.PayaraVersion;
import org.netbeans.modules.payara.tooling.utils.ServerUtils;
import org.openide.WizardDescriptor;
import org.openide.util.NbBundle;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

@Deprecated
public enum ServerDetails implements PayaraPlatformVersionAPI
{
    PAYARA_SERVER_4_1_144(PayaraVersion.PF_4_1_144, "deployer:pfv4ee7", 41144, false),
    PAYARA_SERVER_4_1_151(PayaraVersion.PF_4_1_151, "deployer:pfv4ee7", 41151, false),
    PAYARA_SERVER_4_1_152(PayaraVersion.PF_4_1_152, "deployer:pfv4ee7", 41152, false),
    PAYARA_SERVER_4_1_153(PayaraVersion.PF_4_1_153, "deployer:pfv4ee7", 41153, false),
    PAYARA_SERVER_4_1_1_154(PayaraVersion.PF_4_1_1_154, "deployer:pfv4ee7", 411154, false),
    PAYARA_SERVER_4_1_1_161(PayaraVersion.PF_4_1_1_161, "deployer:pfv4ee7", 411161),
    PAYARA_SERVER_4_1_1_162(PayaraVersion.PF_4_1_1_162, "deployer:pfv4ee7", 411162),
    PAYARA_SERVER_4_1_1_163(PayaraVersion.PF_4_1_1_163, "deployer:pfv4ee7", 411163),
    PAYARA_SERVER_4_1_1_164(PayaraVersion.PF_4_1_1_164, "deployer:pfv4ee7", 411164),
    PAYARA_SERVER_4_1_1_171(PayaraVersion.PF_4_1_1_171, "deployer:pfv4ee7", 411171),
    PAYARA_SERVER_4_1_2_172(PayaraVersion.PF_4_1_2_172, "deployer:pfv4ee7", 412172),
    PAYARA_SERVER_4_1_2_173(PayaraVersion.PF_4_1_2_173, "deployer:pfv4ee7", 412173),
    PAYARA_SERVER_4_1_2_174(PayaraVersion.PF_4_1_2_174, "deployer:pfv4ee7", 412174),
    PAYARA_SERVER_4_1_2_181(PayaraVersion.PF_4_1_2_181, "deployer:pfv4ee7", 412181),
    PAYARA_SERVER_5_181(PayaraVersion.PF_5_181, "deployer:pfv5ee8", 5181),
    PAYARA_SERVER_5_182(PayaraVersion.PF_5_182, "deployer:pfv5ee8", 5182),
    PAYARA_SERVER_5_183(PayaraVersion.PF_5_183, "deployer:pfv5ee8", 5183),
    PAYARA_SERVER_5_184(PayaraVersion.PF_5_184, "deployer:pfv5ee8", 5184),
    PAYARA_SERVER_5_191(PayaraVersion.PF_5_191, "deployer:pfv5ee8", 5191),
    PAYARA_SERVER_5_192(PayaraVersion.PF_5_192, "deployer:pfv5ee8", 5192),
    PAYARA_SERVER_5_193(PayaraVersion.PF_5_193, "deployer:pfv5ee8", 5193),
    PAYARA_SERVER_5_194(PayaraVersion.PF_5_194, "deployer:pfv5ee8", 5194),
    PAYARA_SERVER_5_201(PayaraVersion.PF_5_201, "deployer:pfv5ee8", 5201),
    PAYARA_SERVER_5_202(PayaraVersion.PF_5_202, "deployer:pfv5ee8", 5202, false);

    private final PayaraVersion version;
    private final String displayName;
    private final String uriFragment;
    private final String indirectUrl;
    private final String directUrl;
    private final String licenseUrl;
    private final int versionInt;
    private final boolean downloadable;
    private static final String DOWNLOAD_URL = "https://oss.sonatype.org/service/local/repositories/releases/content/fish/payara/distributions/payara/%s/payara-%s.zip";
    private static final String CDDL_LICENSE = "https://raw.githubusercontent.com/payara/Payara/master/LICENSE.txt";

    public static WizardDescriptor.InstantiatingIterator getInstantiatingIterator() {
        return new ServerWizardIterator(Arrays.asList(ServerDetails.values()));
    }

    public static int getVersionFromInstallDirectory(File payaraDir) {
        if (payaraDir == null) {
            return -1;
        }
        PayaraPlatformVersionAPI version = ServerUtils.getPlatformVersion((String)payaraDir.getAbsolutePath());
        Optional<ServerDetails> serverDetails = Optional.empty();
        if (version != null) {
            serverDetails = Arrays.stream(ServerDetails.values()).filter(value -> value.getVersion() == version).findAny();
        }
        return serverDetails.map(ServerDetails::getVersionInt).orElse(-1);
    }

    @Deprecated
    public static int getVersionFromDomainXml(File domainXml) throws IllegalStateException {
        if (null == domainXml || !domainXml.isFile() || !domainXml.canRead()) {
            return -1;
        }
        return ServerDetails.hasDefaultConfig(domainXml) ? PAYARA_SERVER_5_194.getVersionInt() : PAYARA_SERVER_5_181.getVersionInt();
    }

    private static boolean hasDefaultConfig(File domainXml) throws IllegalStateException {
        DomainParser dp = new DomainParser();
        ArrayList<TreeParser.Path> paths = new ArrayList<TreeParser.Path>();
        paths.add(new TreeParser.Path("/domain/configs/config", dp));
        TreeParser.readXml(domainXml, paths);
        return dp.hasDefaultConfig();
    }

    private ServerDetails(PayaraVersion version, String uriFragment, int versionInt) {
        this(version, uriFragment, versionInt, true);
    }

    private ServerDetails(PayaraVersion version, String uriFragment, int versionInt, boolean downloadable) {
        this.version = version;
        this.displayName = NbBundle.getMessage(ServerDetails.class, (String)"STR_SERVER_NAME", (Object[])new Object[]{version.toString()});
        this.uriFragment = uriFragment;
        this.versionInt = versionInt;
        this.indirectUrl = null;
        this.directUrl = String.format(DOWNLOAD_URL, version.toString(), version.toString());
        this.licenseUrl = CDDL_LICENSE;
        this.downloadable = downloadable;
    }

    public String toString() {
        return this.displayName;
    }

    public String getUriFragment() {
        return this.uriFragment;
    }

    public int getVersionInt() {
        return this.versionInt;
    }

    public PayaraVersion getVersion() {
        return this.version;
    }

    public boolean isDownloadable() {
        return this.downloadable;
    }

    public boolean isInstalledInDirectory(File payaraDir) {
        return ServerDetails.getVersionFromInstallDirectory(payaraDir) == this.getVersionInt();
    }

    public String getDirectUrl() {
        return this.directUrl;
    }

    public String getIndirectUrl() {
        return this.indirectUrl;
    }

    public String getLicenseUrl() {
        return this.licenseUrl;
    }

    public short getMajor() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public short getMinor() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public short getUpdate() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String getBuild() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String toFullString() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean isMinimumSupportedVersion() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean isEE7Supported() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean isEE8Supported() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean isEE9Supported() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean isEE10Supported() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean equalsMajorMinor(PayaraPlatformVersionAPI version) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean equals(PayaraPlatformVersionAPI version) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    static class DomainParser
    extends TreeParser.NodeReader {
        private boolean hasDefaultConfig = false;

        DomainParser() {
        }

        private boolean hasDefaultConfig() {
            return this.hasDefaultConfig;
        }

        @Override
        public void readAttributes(String qname, Attributes attributes) throws SAXException {
            String name = attributes.getValue("name");
            if ("default-config".equals(name)) {
                this.hasDefaultConfig = true;
            }
        }
    }
}

